@extends('layouts.master')
@section('content')

<style>
.card-header {
    color: #fff;
    background-color: #007bff;
}

ul.no-bullets {
  list-style-type: none; /* Remove bullets */
  padding: 0; /* Remove padding */
  margin: 0; /* Remove margins */
}

ul > label, ul > li {
    width:50% !important;
}

hr {
    width:95% !important;
}
</style>
<div class="content-wrapper" style="min-height: 1604.44px;">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Email Draft Details</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('emails.index') }}">Email Draft</a></li>
                        <li class="breadcrumb-item active">Email Draft Details</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="row">
                            <div class="col-12">
                                <div class="card-header">
                                    <h3 class="card-title">Email Draft Details</h3>
                                </div>
                                <div class="card-body">
                                    <ul class="row no-bullets">
                                        <label>Email Type</label><li>{{ $email->email_type }}</li><hr>
                                        <label>Subject</label><li>{{ $email->subject }}</li><hr>
                                        <label>Content</label><li>{!! $email->content !!}</li><hr>
                                        <label>Created Date </label><li>{{ date('j-m-Y H:i:s', strtotime($email->created_at)) }}</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection