
    <table id="example2"
            class="table table-bordered table-hover dataTable dtr-inline"
            aria-describedby="example2_info">
        <thead>
        <tr>
            <th>
                Customer_id</th>
            <th>
                Name
            </th>
            <th>
                Email
            </th>
            <th>
                Assign
            </th>
            <th>
                Assign Admin
            </th>
        </tr>
        </thead>
        <tbody>
        @foreach($users as $val)
            <tr>
                <td class="dtr-control sorting_1" tabindex="0">
                    {{$val->CustomerID}}
                </td>
                <td class="dtr-control sorting_1" tabindex="0">
                    {{$val->CustomerName}}
                </td>
                <td class="dtr-control sorting_1" tabindex="0">
                    {{$val->Email}}
                </td>
                <td>
                    <input type="checkbox" class="btn bg-gradient-success btn-sm assign-user-checkbox-{{$val->user_id}}"   data-user-id="{{$val->user_id}}"
                            id="{{$val->user_id}}" onclick="assignUser(this)" value="true"
                            @if(in_array($val->user_id,$assignedUserIds)) checked @endif>
                </td>
                <td>
                <input type="checkbox" class="btn bg-gradient-success btn-sm assign-admin-checkbox-{{$val->user_id}}"
                data-id="{{$val->user_id}}" onclick="storeadminassign(this)"
                @if(isset($assignedUsers[$val->user_id]) && $assignedUsers[$val->user_id]->is_admin == "true")
                    value="true"
                @else
                    value="false"
                @endif
                @if(isset($assignedUsers[$val->user_id]) && $assignedUsers[$val->user_id]->is_admin == "true")
                    checked
                @endif>
            </td>

            </tr>
        @endforeach
        </tbody>
    </table>


    <div class="modal fade" id="isadmin-modal" data-backdrop="false">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title-admin" id="modal-title-admin"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="post" id="storeadminassignForm" action="{{ route('event.storeadminassign') }}" data-url="{{ route('event.storeadminassign') }}">@csrf
                    <div class="modal-body">
                        <input type="hidden" name="id" id="admin_id">
                        <input type="hidden" name="isadminvalue" id="isadminvalue">
                        <input type="hidden" name="event_id" id="eventId" value="{{$eventid}}">
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">OK</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <div class="modal fade" id="assign-modal" data-backdrop="false">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="post" action="{{ route('event.assignUser') }}" id="assignUserForm" data-url="{{ route('event.assignUser') }}">@csrf
                    <div class="modal-body">
                        <input type="hidden" name="user_id" id="id">
                        <input type="hidden" name="operation" id="operation">
                        <input type="hidden" name="event_id" id="eventId" value="{{$eventid}}">
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">OK</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        function storeadminassign(elm) {
            var id = $(elm).attr('data-id');
            var isadminvalue = elm.value;
            // console.log($(elm).prop('checked'));
            if (isadminvalue != "true") {
                $("#modal-title-admin").html("Are you sure? you want to make it admin?");
            } else {
                $("#modal-title-admin").html("Are you sure? you want to remove admin?");
            }

            $("#admin_id").val(id);
            $("#isadminvalue").val(isadminvalue);
            $("#isadmin-modal").modal('show');
        }
        function setLoader(flag){
            if(flag){
                $("#overlay").fadeIn(300);
            }
            else{
                $("#overlay").fadeOut(300);
                // setTimeout(function() {
                //             }, 300);
            }
        }
        // setLoader(true);
        $("#assignUserForm").submit(function(e){
            e.preventDefault();
            const Url = $(this).data('url')
            if ((Url !== undefined && Url !== null)) {
                var form_id = $(this)[
                    0];
                var formData = new FormData(form_id);
                setLoader(true);

                $.ajax({
                        type: "POST",
                        url: Url,
                        data: formData,
                        dataType: "json",
                        cache: false,
                        processData: false,
                        contentType: false,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr(
                                'content')
                        },
                        success: function(response) {
                            setLoader(false);

                            console.log(response);
                            if (response.status) {
                    $('#modalContent').html(response.html);

                                swal({
                title: response.message,
                icon: 'success'
                                    });
                                        $("#assign-modal").modal('hide');
                                        // console.log(response.is_admin);
                                        console.log(response);

                                        // assign-user-checkbox-{{$val->user_id}}
                                        $('.assign-user-checkbox-'+response.id).val(response.is_assign);
                                    //   window.LaravelDataTables["users-table"].ajax.reload();


                            } else {

   swal({
                title: response.message,
                icon: 'error'
                                    });
                                // alert(response.message)
                            }
                        },
                        error: function(xhr) {
                            setLoader(false);
                            var error = xhr.responseJSON;
                            // console.log(xhr.responseJSON);
                            if (xhr.status == 422) {
                                Object.entries(error.error).forEach(function(item, index) {
                                    const [key, value] = item;
                                    $(`.${key}-error`).html(value);
                                })
                            } else {
                                // alert(error.message)

                                swal({
                title: error.message,
                icon: 'error'
                                    });
                            }


                        }
                    });

            }
        })

        $("#storeadminassignForm").submit(function(e) {
            e.preventDefault();
            const Url = $(this).data('url')
            if ((Url !== undefined && Url !== null)) {
                var form_id = $(this)[
                    0];
                var formData = new FormData(form_id);
                setLoader(true);

                $.ajax({
                        type: "POST",
                        url: Url,
                        data: formData,
                        dataType: "json",
                        cache: false,
                        processData: false,
                        contentType: false,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr(
                                'content')
                        },
                        success: function(response) {
                            setLoader(false);

                            console.log(response);
                            if (response.status) {

                    $('#modalContent').html(response.html);

                                swal({
                title: response.message,
                icon: 'success'
                                    });
                                        $("#isadmin-modal").modal('hide');
                                        console.log(response.is_admin);
                                        $('.assign-admin-checkbox-'+response.id).val(response.is_admin);
                                        // if(response.is_admin == "true")
                                        //     $('.assign-admin-checkbox-'+response.id).prop('checked',true);
                                        // else
                                        //     $('.assign-admin-checkbox-'+response.id).prop('checked',false);

                                    //   window.LaravelDataTables["users-table"].ajax.reload();



                            } else {
                                swal({
                title: response.message,
                icon: 'error'
                                    });
                                // alert(response.message)
                            }
                        },
                        error: function(xhr) {
                            setLoader(false);
                            var error = xhr.responseJSON;
                            // console.log(xhr.responseJSON);
                            if (xhr.status == 422) {
                                Object.entries(error.error).forEach(function(item, index) {
                                    const [key, value] = item;
                                    $(`.${key}-error`).html(value);
                                })
                            } else {
                                // alert(error.message)

                                swal({
                title: error.message,
                icon: 'error'
                                    });
                            }


                        }
                    });

            }
        })
    </script>


    <script>
        function assignUser(elm) {
            var id = $(elm).attr('id');

            var operation = $(elm).prop('checked') ? 'add' : 'remove';

            if ($(elm).prop('checked') == true) {
                $("#operation").val('add');
                $("#modal-title").html("Are you sure? you want to add?");
            } else {
                $("#operation").val('remove');
                $("#modal-title").html("Are you sure? you want to remove?");
            }

            $("#id").val(id);
            $("#assign-modal").modal('show');

        }
    </script>

