@extends('layouts.master')
@section('content')
<style>
      #overlay {
            position: fixed;
            top: 0;
            z-index: 1070;
            width: 100%;
            height: 100%;
            display: none;
            background: rgba(0, 0, 0, 0.6);
        }

        .cv-spinner {
            height: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
            margin-right: 24%;
        }

        .spinner {
            width: 40px;
            height: 40px;
            border: 4px #ddd solid;
            border-top: 4px #2e93e6 solid;
            border-radius: 50%;
            animation: sp-anime 0.8s infinite linear;
        }

</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Event/Folder  List</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active">Event/Folder </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Event/Folder </h3>
                            <div class="card-tools">
                                @if(Auth::user()->type != "user")
                                <a href="{{ route('event.addevent') }}" class="btn btn-sm btn-primary"><i class="fa fa-plus"></i> Add Event/Folder </a>
                                @endif
                            </div>
                        </div>
                        <div class="card-body table-responsive">
                            {{ $dataTable->table() }}
                        </div>
                    </div>
                </div>
                <!-- <div class="col-6">
                    <img style="width: 800px;height:800px;" src="https://frenzinsoftwares.com/frenzincrm_help/assignevent.gif" alt="category.gif">
                </div> -->
            </div>
        </div>
    </div>
    

    <div id="overlay">
        <div class="cv-spinner">
            <span class="spinner"></span>
        </div>
    </div>

<!-- Modal for displaying the form or view for assign event and Admin-->
<div class="modal fade" id="assignTeamModal" tabindex="-1" role="dialog" aria-labelledby="assignTeamModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="assignTeamModalLabel"></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="modalContent">
                <!-- Content will be loaded here -->
            </div>
            <!-- <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="saveChangesButton">Save changes</button>
            </div> -->
        </div>
    </div>
</div>
</div>
@push('scripts')
{{ $dataTable->scripts() }}
@endpush
<script>
    function deletePopupevent(elm) {
        let url = $(elm).data('url');
        swal({
            title: 'Are you sure want to Delete Event ? All Clients associated with this Event will be Deleted',
            icon: 'error',
            dangerMode: true,
            buttons: true,
            confirm: "Confirm",
        }).then(function(isConfirm) {
            if (isConfirm === true) {
                $.ajax({
                    type: 'GET',
                    url: url,
                    dataType: 'json',
                    success: function(data) {
                        window.location.reload();
                        // console.log(data);
                    },
                    error: function(data) {
                        console.log(data);
                    }
                });
            }
        });
    }
    </script>

    <!-- Script to handle the modal and AJAX -->

    <script>
    $(document).ready(function() {
        // Open the modal and fetch the content using AJAX when the "Assign Team Member" button is clicked
        $(document).on('click', '.assign-team-member', function() {
            $("#overlay").fadeIn(300);
            var eventId = $(this).data('id'); // Get the event id from data-id attribute

            var event_name  =  $(this).data('name');
            var slug = 'Assign '+ event_name +  ' to Team Members';
            $('#assignTeamModalLabel').html(slug)

            $.ajax({
                url: '{{ route("event.add") }}',  // Make sure this is the correct URL
                type: 'GET',
                data: {
                    id: eventId  // Send the event id as a parameter
                },
                success: function(response) {
                    setTimeout(function() {
                                $("#overlay").fadeOut(300);
                            }, 300);
                    // Append the HTML content returned from the controller to the modal body
                    $('#modalContent').html(response);
                    
                    // Open the modal
                    $('#assignTeamModal').modal('show');
                },
                error: function(xhr, status, error) {
                    // Handle any errors here
                    console.log('AJAX error: ' + status + ' ' + error);
                }
            });
        });
    });
</script>

@endsection

