<!DOCTYPE html>
<html lang="en">
<head>
  <title>Add Expence</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <style>
  .fakeimg {
    height: 200px;
    background: #aaa;
  }
  </style>
</head>
<body>

<!-- <div class="p-2 bg-primary text-white text-center">
  <h1>Add Expence</h1>
</div> -->

<div class="container mt-5">
  <div class="row">
    <div class="col-sm-12">
      @if ($message = Session::get('success'))
          <div class="alert alert-success alert-dismissible fade show">
              {{ $message }}
              <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"><i class="bi bi-x"></i></button>
          </div>
      @endif
       <form method="post" action="{{ route('saveexpence') }}" name="form" enctype="multipart/form-data">
        @csrf
        <input type="hidden" name="customer_id" value="{{ $customerid }}">
        <div class="mb-3 mt-3">
          <label for="expensetype" class="form-label">Expense Type <span class="text-danger">*</span></label>
          <select class="form-control" id="expensetype" name="expensetype" required>
            <option value="">Select</option>
            @foreach($expencetype as $obj)
              <option value="{{$obj->id}}">{{$obj->name}}</option>
            @endforeach
          </select>
        </div>
        <div class="mb-3">
          <label for="amount" class="form-label">Amount <span class="text-danger">*</span></label>
          <input type="number" class="form-control" id="amount" placeholder="Enter amount" name="amount" value="{{ old('amount') }}" required>
        </div>
        <div class="mb-3">
          <label for="start_location" class="form-label">Start Location</label>
          <input type="text" class="form-control" id="start_location" placeholder="Enter start location" name="start_location" value="{{ old('start_location') }}">
        </div>
        <div class="mb-3">
          <label for="end_location" class="form-label">End Location</label>
          <input type="text" class="form-control" id="end_location" placeholder="Enter end location" name="end_location" value="{{ old('end_location') }}">
        </div>
        <div class="mb-3">
          <label for="file" class="form-label">File</label>
          <input type="file" class="form-control" id="file" name="file[]" accept="image/*"  value="{{ old('file') }}" multiple>
        </div>
        <button type="submit" class="btn btn-primary">Submit</button>
      </form>
    </div>
  </div>
</div>
</body>
</html>
