@extends('layouts.master')
@section('content')
  <style>
    .board {
      display: flex;
      gap: 10px;
      overflow-x: auto;
    }
    .column {
      background: #343a40;
      padding: 10px;
      width: 300px;
      border-radius: 8px;
    }
    .column h3 {
      margin-top: 0;
      font-size: 16px;
      border-bottom: 1px solid #ccc;
      padding-bottom: 5px;
      color: #fff;
    }
    .task {
      background: #fff;
      border-radius: 6px;
      padding: 10px;
      margin-bottom: 10px;
      box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    .priority {
      font-weight: bold;
    }
    .assigned {
      color: #666;
      font-size: 12px;
    }
    .draggable-item {
        cursor: move;
    }
    .priority span,.assigned span{
        width: 70px;
        display: inline-block;
    }
    #overlay {
        position: fixed;
        top: 0;
        z-index: 1070;
        width: 100%;
        height: 100%;
        display: none;
        background: rgba(0, 0, 0, 0.6);
    }

    .cv-spinner {
        height: 100%;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .spinner {
        width: 40px;
        height: 40px;
        border: 4px #ddd solid;
        border-top: 4px #2e93e6 solid;
        border-radius: 50%;
        animation: sp-anime 0.8s infinite linear;
    }
    .select2-container--default .select2-selection--multiple .select2-selection__choice{
            color: #000;
        }
  </style>
<div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Client List</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                            <li class="breadcrumb-item active">Client</li>
                        </ol>
                    </div>
                    <div class="container-fluid">
                        <div class="card-body">
                            <form method="get" id="myform" name="myform" action="{{ route('newvisitor.list') }}"
                                enctype="multipart/form-data">
                                <input type="hidden" value="" name="type" id="formType">
                                <div class="form-group row">
                                    <div class="col-2">
                                        <label for="">Select Event/Folder</label>
                                        <select class="form-control custom-select" name="event_id" id="event_id">
                                            <option value="all" @if ($event_id == 'all') selected @endif>All
                                            </option>
                                            @foreach ($events as $val)
                                                <option value="{{ $val->id }}"
                                                    @if ($event_id == $val->id) selected @endif>{{ $val->event_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @if(Auth::user()->type != "user")
                                    <div class="col-2">
                                        <label for="">Select Team Member</label>
                                        <select class="form-control custom-select" name="CustomerID" id="CustomerID">
                                            <option value="all" @if ($CustomerID == 'all') selected @endif>All
                                            </option>
                                            @foreach ($users as $username)
                                                <option value="{{ $username->CustomerID }}"
                                                    @if ($CustomerID == $username->CustomerID) selected @endif>
                                                    {{ $username->CustomerName }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @endif

                                    <div class="col-2">
                                        <label for="">Select Source of Lead </label>
                                        <select class="form-control custom-select" name="sourceoflead" id="sourceoflead">
                                            <option value="all" @if ($sourceoflead == 'all') selected @endif>All
                                            </option>
                                            @foreach ($sourceofleadList as $val)
                                                <option value="{{ $val->name }}"
                                                    @if ($val->name == $sourceoflead) selected @endif>{{ $val->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select Category</label>
                                        <select class="form-control custom-select" name="category_id" id="category_id">
                                            <option value="all" @if ($category_id == 'all') selected @endif>All
                                            </option>
                                            @foreach ($categories as $val)
                                                <option value="{{ $val->id }}"
                                                    @if ($val->id == $category_id) selected @endif>{{ $val->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select Sub Category</label>
                                        <select class="form-control custom-select" name="sub_category_id"
                                            id="sub_category_id">
                                            <option value="all" @if ($sub_category_id == 'all') selected @endif>All
                                            </option>
                                        </select>
                                    </div>
                                    <div class="col-2">
                                        <label for="action">Action</label>
                                        <select class="form-control custom-select" name="action" id="action" style="width: 100%; height: 40px;">
                                            <option value="all">All</option>
                                            @foreach($actionList as $action)
                                                <option value="{{ $action->title }}" {{ request()->get('action') == $action->title ? 'selected' : '' }}>
                                                    {{ $action->title }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select Start Date</label>
                                        <input type="date" name="start_date" id="start_date" class="form-control"
                                            value="{{ $start_date }}">
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select End Date</label>
                                        <input type="date" name="end_date" id="end_date" class="form-control"
                                            value="{{ $end_date }}">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="col-2">
                                        <label for="">Region</label>
                                        <select class="form-control custom-select" name="region" id="region">
                                            <option value="all" @if ($region == 'all') selected @endif>All
                                            </option>
                                            @if ($regions)
                                                @foreach ($regions as $val)
                                                    <option value="{{ $val->id }}"
                                                        @if ($region == $val->id) selected @endif>
                                                        {{ $val->name }}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>

                                    <div class="col-2">
                                        <label for="">Is International</label>
                                        <select class="form-control custom-select" name="is_international"
                                            id="is_international">
                                            <option value="all" @if ($is_international == 'all') selected @endif>All
                                            </option>
                                            <option value="false" @if ($is_international == 'false') selected @endif>India
                                            </option>
                                            <option value="true" @if ($is_international == 'true') selected @endif>
                                                International</option>
                                        </select>
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select Country</label>
                                        <select class="form-control custom-select" name="country_id" id="country_id">
                                            <option value="all" @if ($country_id == 'all') selected @endif>All
                                            </option>
                                        </select>
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select State</label>
                                        <select class="form-control custom-select" name="state_id" id="state_id">
                                            <option value="all" @if ($state_id == 'all') selected @endif>All
                                            </option>
                                        </select>
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select City</label>
                                        <select class="form-control custom-select" name="city_id" id="city_id">
                                            <option value="all" @if ($city_id == 'all') selected @endif>All
                                            </option>
                                        </select>
                                    </div>

                                </div>
                                <div class="form-group">
                                    <button type="submit" class="btn btn-2 bg-gradient-info btn-1"
                                        style="color:white;">Submit</button>
                                    
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Client</h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"
                                        title="Collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="board">
                                    @foreach($actionList as $action)
                                        <div class="column card-body">
                                        <h3>{{ $action->title }} ({{ $action->totalcount }})</h3>
                                            <div class="todo-{{$action->id}}"  data-status="{{ $action->title }}">
                                                @foreach($action->visitorlist as $visitor)
                                                    <div class="task draggable-item" data-id="{{ $visitor->id }}" data-event_id="{{ $visitor->event_id }}">
                                                        <div>#{{ $visitor->id }}</div>
                                                        <div class="priority"><span>Client</span> : {{ $visitor->name }}</div>
                                                        <div class="assigned"><span>Company</span> : {{ $visitor->company_name }}</div>
                                                        <div class="assigned"><span>Event/Folder</span> : {{ $visitor->event_name }}</div>
                                                        <div class="assigned"><span>Remarks</span> : {{ $visitor->remarks }}</div>
                                                        <div class="assigned"><span>Mobile No.</span> : {{ $visitor->mobile_no }}</div>
                                                        <div class="assigned"><span>Email</span> : {{ $visitor->email }}</div>
                                                        <div class="assigned"><span>Visited Date</span> : {{ $visitor->visited_date }}</div>
                                                        <div class="assigned"><span>Date</span> : {{ $visitor->updated_at }}</div>
                                                        <div class="assigned pt-2">
                                                            @if(auth()->user()->getUser() && auth()->user()->getUser()->is_admin == "true" && $visitor->email_permission == '1')
                                                                <button type="submit" data-modal="sendEmail_Modal"  data-url="{{ route('send.email.modal') }}" data-event_id ="{{ $visitor->event_id }}" data-visitor_id ="{{ $visitor->id }}" class="btn btn-primary btn-sm mr-2 sendEmail">Send Email</button>              
                                                            @endif
                                                            <a href="{{ route('visitor.edit',$visitor->id) }}" class="btn btn-primary btn-sm mr-2" data-toggle="tooltip" data-placement="bottom" title="Edit "><i class="fas fa-pen-alt" aria-hidden="true"></i></a>

                                                            <a data-toggle="modal" data-target="#deletePopup" data-url="{{ route('visitor.destroy',$visitor->id) }}"  data-id="{{ $visitor->id }}" onclick="deletePopupvisitor(this)" class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="right" title="Delete "><i class="fas fa-trash" aria-hidden="true"></i></a>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<div id="overlay">
    <div class="cv-spinner">
        <span class="spinner"></span>
    </div>
</div>
<script>
    $(document).ready(function() {
        var categoryId = "{{ $category_id }}";
        if (categoryId !== 'all') {
            fetchSubCategories(categoryId);
        }
        var region = "{{ $region }}";
        if (region !== 'all') {
            $('#is_international').attr('disabled', true);
            $('#country_id').attr('disabled', true);
            $('#state_id').attr('disabled', true);
            $('#city_id').attr('disabled', true);
        }
        var isInternational = "{{ $is_international }}";
        if (isInternational !== 'all' && isInternational !== 'false') {
            fetchCountries();
        } else if (isInternational !== 'all' && isInternational === 'false') {
            var options = [];
            var selectedValue = 'selected';
            var valueId = 99;
            var valueName = "India";
            selectData = '<option value="' + valueId + '" ' + selectedValue + ' >' + valueName +
                '</option>';
            options.push(selectData);
            $('#country_id').html('<option value="all">All</option>' +
                options);
            $('#country_id').attr('disabled', true);
            fetchStates('99');
        }
        var countryId = "{{ $country_id }}";
        console.log('countryId_2'+countryId)
        if (countryId !== 'all') {
            fetchStates(countryId);
        }
        var stateId = "{{ $state_id }}";
        if (stateId !== 'all') {
            fetchCities(stateId);
        }
        console.log($('meta[name="csrf-token"]').attr('content'));
        $('.token').val($('meta[name="csrf-token"]').attr('content'));
    });
    $('#category_id').change(function() {
        var id = $(this).val();
        if (id !== 'all') {
            fetchSubCategories(id);
        }
    });

    function fetchSubCategories(id) {
        var url = "{{ route('get_sub_categories') }}";
        $.ajax({
            url: url,
            type: "GET",
            data: {
                category_id: id,
            },
            success: function(response) {
                var options = [];
                var rData = [];
                rData = response.data;
                $.each(rData, function(index, value) {
                    var selectData = '';
                    var subCategory = "{{ $sub_category_id }}";
                    var selectedValue = subCategory == value.id ? 'selected' : '';
                    selectData = '<option value="' + value.id + '" ' + selectedValue + ' >' + value
                        .name +
                        '</option>';
                    options.push(selectData);
                });
                $('#sub_category_id').html('<option value="all">All</option>' +
                    options);
            },
            error: function(error) {
                console.log(error);
            }
        });
    }

    $('#is_international').change(function() {
        var isInternational = $(this).val();
        $('#country_id').html('<option value="all">All</option>');
        $('#state_id').html('<option value="all">All</option>');
        $('#city_id').html('<option value="all">All</option>');
        $('#country_id').attr('disabled', false);
        if (isInternational !== 'all' && isInternational !== 'false') {
            fetchCountries();
        } else if (isInternational !== 'all' && isInternational === 'false') {
            var options = [];
            var selectedValue = 'selected';
            var valueId = 99;
            var valueName = "India";
            selectData = '<option value="' + valueId + '" ' + selectedValue + ' >' + valueName +
                '</option>';
            options.push(selectData);
            $('#country_id').html('<option value="all">All</option>' +
                options);
            $('#country_id').attr('disabled', true);
            fetchStates('99');
            // fetchStates('99');
        }
    });

    function fetchCountries() {
        var url = "{{ route('get_countries') }}";
        $.ajax({
            url: url,
            type: "GET",
            success: function(response) {
                var options = [];
                var rData = [];
                rData = response.data;
                $.each(rData, function(index, value) {
                    var selectData = '';
                    var country = "{{ $country_id }}";
                    var selectedValue = country == value.name ? 'selected' : '';
                    selectData = '<option value="' + value.name + '" ' + selectedValue + ' >' + value
                        .name +
                        '</option>';
                    options.push(selectData);
                });
                $('#country_id').html('<option value="all">All</option>' +
                    options);
            },
            error: function(error) {
                console.log(error);
            }
        });
    }

    $('#country_id').change(function() {
        var countryId = $(this).val();
        if (countryId !== 'all') {
            fetchStates(countryId);
        }
    });

    function fetchStates(countryId) {
        var url = "{{ route('get_states') }}";
        $.ajax({
            url: url,
            type: "GET",
            data: {
                countryId: countryId,
            },
            success: function(response) {
                var options = [];
                var rData = [];
                rData = response.data;
                $.each(rData, function(index, value) {
                console.log('value__'+value);
                    var selectData = '';
                    var state = "{{ $state_id }}";
                    var selectedValue = state == value.state ? 'selected' : '';
                    selectData = '<option value="' + value.state + '" ' + selectedValue + ' >' + value
                        .state +
                        '</option>';
                    options.push(selectData);
                });
                $('#state_id').html('<option value="all">All</option>' +
                    options);
            },
            error: function(error) {
                console.log(error);
            }
        });
    }

    $('#state_id').change(function() {
        var stateId = $(this).val();
        var selectedOption = $(this).find('option:selected');
        var countryUid = selectedOption.data('country_id');
        if (stateId !== 'all') {
            // alert(selectedText);
            fetchCities(stateId,countryUid);
        }
    });

    function fetchCities(stateId) {
        var url = "{{ route('get_cities') }}";
        $.ajax({
            url: url,
            type: "GET",
            data: {
                stateId: stateId,
            },
            success: function(response) {
                var options = [];
                var rData = [];
                rData = response.data;
                $.each(rData, function(index, value) {
                    var selectData = '';
                    var city = "{{ $city_id }}";
                    var selectedValue = city == value.district ? 'selected' : '';
                    selectData = '<option value="' + value.district + '" ' + selectedValue + ' >' + value
                        .district +
                        '</option>';
                    options.push(selectData);
                });
                $('#city_id').html('<option value="all">All</option>' +
                    options);
            },
            error: function(error) {
                console.log(error);
            }
        });
    }
    $('#region').change(function() {
        var region = $(this).val();
        if (region !== 'all') {
            $('#is_international').attr('disabled', true);
            $('#country_id').attr('disabled', true);
            $('#state_id').attr('disabled', true);
            $('#city_id').attr('disabled', true);
        } else {
            $('#is_international').attr('disabled', false);
            $('#country_id').attr('disabled', false);
            $('#state_id').attr('disabled', false);
            $('#city_id').attr('disabled', false);
        }
    });

    function deletePopupvisitor(elm) {
        let id = $(elm).data('id');
        let url = $(elm).data('url');
        swal({
            title: 'Are you sure!',
            icon: 'error',
            dangerMode: true,
            buttons: true,
            confirm: "Confirm",
        }).then(function(isConfirm) {
            if (isConfirm === true) {
                $.ajax({
                    type: 'GET',
                    url: url,
                    dataType: 'json',
                    success: function(data) {
                        location.reload(true);
                    },
                    error: function(data) {
                        console.log(data);
                    }
                });
            }
        });
    }
    $(document).on("click", ".sendEmail", function() {
        // alert('dsfsdf');
        $('.sendEmail').prop('disabled', true);
        const modal = $(this).data('modal')
        const Url = $(this).data('url')
        const event_id = $(this).data('event_id')
        const visitor_id = $(this).data('visitor_id')
        const visit_data_id = $(this).data('visit_data_id')

        if ((Url !== undefined && Url !== null) && (modal !== undefined && modal !== null)) {

            $.ajax({
                type: "GET",
                url: Url,
                dataType: "json",
                cache: false,
                data: {
                    event_id: event_id,
                    visitor_id: visitor_id,
                    visit_data_id: visit_data_id
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    $('.sendEmail').prop('disabled', false);
                    $('#ajaxModalHtml').html(response.modalHtml)
                    $('#' + modal).modal('show');

                },
                error: function(error) {
                    $('.sendEmail').prop('disabled', false);
                    console.log('something went wrong');
                }
            });
        }
    });
</script>
<script src="https://cdn.jsdelivr.net/npm/sortablejs@1.14.0/Sortable.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize SortableJS for each column
    const columns = [];
    <?php 
        foreach($actionList as $action){
    ?>
        var selecttort = 'todo-'+'{{ $action->id }}';
        var json = { el: document.querySelector('.'+selecttort), status: '{{ $action->title }}' };
        console.log(json);
        columns.push(json);
    <?php
        }
    ?>
    
    console.log(columns);
    columns.forEach(column => {
        new Sortable(column.el, {
            group: 'shared',
            animation: 150,
            ghostClass: 'sortable-ghost',
            onEnd: function(evt) {
                var id = evt.item.getAttribute('data-id');
                var event_id = evt.item.getAttribute('data-event_id');
                var status = evt.to.getAttribute('data-status');
                updateItemOrder(id,event_id, status);
            }
        });
    });
    
    function updateItemOrder(visitor_id,event_id, status) {
        console.log(visitor_id,event_id,status);
        $("#overlay").fadeIn(300);
        $.ajax({
            type: "GET",
            url: "{{route('visit.data.modal')}}",
            dataType: "json",
            cache: false,
            data: {
                event_id: event_id,
                visitor_id: visitor_id,
                visit_data_id: visitor_id,
                action: status
            },
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                $('.sendEmail').prop('disabled', false);
                $('#ajaxModalHtml').html(response.modalHtml);
                $('#addVisitModal').modal('show');

                $('#products').select2({
                    placeholder: "Select a product...",
                    dropdownParent: $('#addVisitModal')
                });

                setTimeout(function() {
                    $("#overlay").fadeOut(300);
                }, 500);


                $("#addVisitModal").on('hidden.bs.modal', function () {
                    //actions you want to perform after modal is closed.
                    console.log("test");
                    window.location.reload();
                });
            },
            error: function(error) {
                $('.sendEmail').prop('disabled', false);
                console.log('something went wrong');
            }
        });
        
    }

    // Real-time updates with Echo (optional)
    @if(config('broadcasting.default') === 'pusher')
        window.Echo.channel('items-reordered')
        .listen('ItemsReordered', (data) => {
            // Handle real-time updates here
            console.log('Received real-time update', data);
            window.location.reload(); // Simple approach - better to update DOM directly
        });
    @endif
});
</script>
  @endsection