@extends('layouts.master')
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Edit Image</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('product.list') }}">Product List</a></li>
                        <li class="breadcrumb-item active">Edit Image</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('product.imageStore') }}" name="form"
                                enctype="multipart/form-data">
                                @csrf
                                <input type="hidden" name="id" id="id" value="{{$iamges_name->id}}">
                                <input type="hidden" name="fk_product_id" id="fk_product_id" value="{{$iamges_name->fk_product_id}}">

                                <div class="form-group">
                                    <div class="col-8">
                                        <label for="">Description</label>
                                        <input type="text" name="description"
                                            class="form-control @error('description') is-invalid @enderror" id="description"
                                            placeholder="Enter Description" value="{{$iamges_name->description}}" required>

                                        @if ($errors->has('description'))
                                        <div class="form-text text-danger">
                                            {{ $errors->first('description') }}
                                        </div>
                                        @endif
                                    </div>
                                    <br>
                                    <div class="col-8">
                                        <?php 
                                           $imageName = basename($iamges_name->image);     
                                        ?>
                                        <label for="">Image</label> : {{$imageName}}
                                        <input type="file" name="image" class="form-control @error('image') is-invalid @enderror" id="image" value="">
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection