@extends('layouts.master')
@section('content')
<style>
img {
    height:auto;
    width: 60px;
object-fit: scale-down;
}

#cke_notifications_area_technical_specification{
    display: none !important;
}
.ck-editor__editable {
    min-height: 200px !important;
}

</style>
<link
  rel="stylesheet"
  href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@6.1/dist/fancybox/fancybox.css"
/>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Product List</h1>
                </div>
                <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active">Product</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Product</h3>
                            <div class="card-tools">
                                <a href="{{ route('product.add') }}" class="btn btn-sm btn-primary"><i class="fa fa-plus"></i> Add Product</a>
                            </div>
                        </div>
                        <div class="card-body table-responsive">
                            {{ $dataTable->table() }}
                        </div>
                    </div>
                </div>
                <!-- <div class="col-4" style="margin-top: -50px;">
                    <img style="width: 800px;height:800px;" src="https://frenzinsoftwares.com/frenzincrm_help/products.gif" alt="products.gif">

                </div> -->
            </div>
        </div>
    </div>
</div>
<!-- image file Modal -->
<div class="modal fade" id="modalimagefile" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalimagefileTitle">File List</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="table-responsive text-nowrap">
                    <div class="card-tools">
                        <form method="get" action="{{ route('product.addimage') }}" name="form"
                            enctype="multipart/form-data">
                            <button type="submit" class="btn btn-sm btn-primary" style="float: right;">Add More</button>
                            <input type="hidden" name="product_id" id="product_id" class="form-control" value="">
                        </form>
                        <br>
                    </div>
                    <br>
                    <table class="table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>File</th>
                                <th>Description</th>
                                <th></th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0" id="showfilewithimage">
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!--name product Modal -->
<div class="modal fade" id="editnameModal" tabindex="-1" role="dialog" aria-labelledby="editnameModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="editnameModalLabel">Update Product Name</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <form action="{{ route('product.updateName') }}" data-after-ajax-call="afterEditName" class="ajaxModalForm" method="post" enctype="multipart/form-data" data-redirect="{{ route('product.list') }}">
                @csrf
                <input type="hidden" name="id" id="modalId" class="form-control" value="">
                <div class="form-group">
                    <label for="">Name</label>
                    <input type="text" name="name" class="form-control" id="modalname" value="modalname" required>
                    <span class="text-danger error-text name-error common-ajax-error"></span>
                </div>
                @if(Session::get('productqr') == 1)

                <div class="form-group">
                    <div class="form-check">
                      <input class="form-check-input" type="checkbox" id="qrcodecheck" name="qrcodecheck">
                      <label class="form-check-label" for="qrcodecheck">Generate QR Code</label>
                    </div>
                </div>

                <div class="form-group displayIfQrRequired">
                    <label for="">Product Code</label>
                    <input type="text" name="product_code" class="form-control" id="product_code" placeholder="Product Code" value="">
                    <span class="text-danger error-text product_code-error common-ajax-error"></span>
                </div>
                <div class="form-group displayIfQrRequired">
                    <label for="">Product Message</label>
                    <textarea name="product_message" rows="15" class="form-control" id="product_message" placeholder="Product Message"></textarea>
                </div>
                @endif
                <div class="form-group">
                    <label for="">HSN Code</label>
                    <input type="text" name="hsn_code" class="form-control" id="hsnCode" placeholder="HSN Code" value="">
                </div>

                <div class="form-group">
                    <label for="">Price</label>
                    <input type="number" name="price" class="form-control" id="Price" placeholder="Price" value="Price">
                </div>
                <div class="form-group">
                    <label for="gst">GST(%)</label>
                    <input type="number" name="gst" class="form-control" id="gst" placeholder="GST(%)" value="">
                </div>
                <div class="form-group">
                    <label for="technical_specification">Technical Specification</label>
                    <textarea class="editor" cols="10" rows="10" name="technical_specification" id="technical_specification"></textarea>
                </div>
                <div class="form-group">
                    <label for="">Quotation Image</label>
                    <input type="file" name="quotation_image" class="form-control" id="quotation_image"  accept="image/*">
                </div>
                <div class="d-flex justify-content-end gap-2">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">  <span class="submit-text">Update</span>
                                              <div class="spinner-border text-light submit-loader" role="status"
                                                  style="width:16px;height:16px;display:none;">
                                                  <span class="visually-hidden"></span>
                                              </div></button>
                </div>
            </form>
        </div>

      </div>
    </div>
  </div>
@push('scripts')
{{ $dataTable->scripts() }}

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="{{ asset('js/commonAjax.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@6.1/dist/fancybox/fancybox.umd.js"></script>
<script>
    $(document).ready(function(){
Fancybox.bind("[data-fancybox]", {
  Carousel: {
    Thumbs: false,
    Toolbar: {
      display: {
        left: [],
        middle: [],
        right: ["close"],
      },
    },
    Zoomable: {
      Panzoom: {
        maxScale: "cover",
        panMode: "mousemove",
        mouseMoveFactor: 1.1,
      },
    },
  },
});
});
    </script>
@endpush

<script>
    function showfilewithimage(elm) {
        var product_id = $(elm).attr('data-id');
        $.ajax({
            url: "{{ url('ajax/get_imagefile') }}",
            type: "GET",
            data: {
                product_id: product_id,
            },
            success: function(response) {
                if (response) {
                    $("#showfilewithimage").html('');
                    $.each(response['data'], function(i, item) {
                        var url = '{{route("product.editimage", "file_id=:id")}}';
                        url = url.replace(':id', item.id);

                        var url_file = '{{route("product.filedestroy", "fileid=:id")}}';
                        url_file = url_file.replace(':id', item.id);

                        var imageName = item.image.split('/').pop();
                        var imageNameX = item.image.split('.').pop();
                        var filename = '';
                        if(imageNameX === 'pdf'){
                            filename = `<i class="far fa-file-pdf pdf-icon fa-2x" style="color:red;"></i> ${imageName}`;
                        }else if(imageNameX === 'mp4' || imageNameX === '3gp' || imageNameX === 'mkv'){
                            filename = `<img src="{{ url('video.png') }}" alt="" class="img" style="height:30px;width:30px;"> ${imageName}`;
                        }else{
                            filename = `<img src="${item['image']}" alt="" class="img">`;
                        }
                        var html = `<tr>
                            <td><strong>${item['id']}</strong></td>
                            <td>
                                <a href="${item['image']}" target="_blank" style="text-decoration: none;">
                                    ${filename}
                                </a>
                            </td>
                            <td>${item['description']}</td>
                            <td>
                                <a href="${url}">
                                    <button style="margin-left:-25px;color: white;" class="btn btn-block bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Edit">
                                        <i class="bx bxs-edit" aria-hidden="true"></i>Edit
                                    </button>
                                </a>
                            </td>
                            <td>
                                <a data-toggle="modal" data-target="#deletePopupfile" data-url="${url_file}" onclick="deletePopupfile(this)">
                                    <button class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="right" title="Delete ">
                                        <i class="fas fa-trash" aria-hidden="true"></i>
                                    </button>
                                </a>
                            </td>
                        </tr>`;
                        $('#product_id').val(product_id);
                        $("#showfilewithimage").append(html);
                        $("#modalimagefile").modal('show');
                    });
                } else {
                    $("#showfilewithimage").html('');
                    $('#product_id').val(product_id);
                    $("#modalimagefile").modal('show');
                    // alert('no data found!')
                }
            },
            error: function(error) {
                console.log(error);
            }
        });
    }

function deletePopupProduct(elm) {
    let id = $(elm).data('id');
    let url = $(elm).data('url');
    Swal.fire({
    title: 'Are you sure?',
    text: "This action cannot be undone!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Yes, confirm',
    cancelButtonText: 'Cancel',
}).then((result) => {
    if (result.isConfirmed) {
            $.ajax({
                type: 'GET',
                url: url,
                dataType: 'json',
                success: function(data) {
                    window.location.reload();
                    // console.log(data);
                },
                error: function(data) {
                    console.log(data);
                }
            });
        }
    });
}
    function deletePopupfile(elm) {
        let id = $(elm).data('id');
        let url = $(elm).data('url');
        Swal.fire({
    title: 'Are you sure?',
    text: "This action cannot be undone!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Yes, confirm',
    cancelButtonText: 'Cancel',
}).then((result) => {
    if (result.isConfirmed) {
                $.ajax({
                    type: 'GET',
                    url: url,
                    dataType: 'json',
                    success: function(data) {
                        window.location.reload();
                        // console.log(data);
                    },
                    error: function(data) {
                        console.log(data);
                    }
                });
            }
        });
    }
    function afterEditName(form, btn, response) {
        // afterAjax
        if(response.status){
            //refresh data table
            console.log("refresh data table");
            $(".dataTable").DataTable().ajax.reload();
        }
    }
    function editname(id) {
        $('#modalname').val($('.btn-'+id).data('name'));
        $('#hsnCode').val($('.btn-'+id).data('hsn_code'));
        $('.displayIfQrRequired').hide();
        // console.log($('.btn-'+id).data('product_code'),$('.btn-'+id).data('product_message'))
        if(($('.btn-'+id).data('product_code').toString().trim()).length > 0){
            $('#qrcodecheck').prop('checked', true).trigger('change');
        }else{
            $('#qrcodecheck').prop('checked', false).trigger('change');
        }
        $('#product_code').val($('.btn-'+id).data('product_code'));
        $('#product_message').val($('.btn-'+id).data('product_message'));
        $('#Price').val($('.btn-'+id).data('price'));
        $('#gst').val($('.btn-'+id).data('gst'));
        console.log($('.btn-'+id).data());
        //console.log($('.btn-'+id).data('technical_specification'));
        var editor = CKEDITOR.instances.technical_specification;
        //console.log(editor);
        if (editor) { // Check if the editor instance exists
            editor.setData($('.btn-'+id).data('technical_specification'));
        }


        $('#modalId').val(id);
        $('#editnameModal').modal('show');
    }
    $(document).ready(function() {
        $(document).on("change","#qrcodecheck",function(){
            if($(this).is(':checked')){
                $('.displayIfQrRequired').show();
            }else{
                $('.displayIfQrRequired').hide();
            }
        });
        // CKEDITOR.replace( 'content' );
        CKEDITOR.replace('technical_specification', {
            height: 200
        });
    });
</script>

@endsection
