@extends('layouts.master')
@section('content')

<style>
.card-header {
    color: #fff;
    background-color: #007bff;
}

img {
    height: 150px;
    width: 166px;
}

#fullpage {
    display: none;
    position: absolute;
    top: 0;
    left: 0;
    width: 81.4vw;
    height: 60vh;
    background-size: contain;
    background-repeat: no-repeat no-repeat;
    background-position: center center;
    background-color: black;
}


.item {
    width: 200px;
    text-align: center;
    display: block;
    background-color: transparent;
    border: 1px solid transparent;
    margin-right: 10px;
    margin-bottom: 1px;
    margin-top: 10px;
    float: left;
}
</style>
<div class="content-wrapper" style="min-height: 1604.44px;">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Product Details</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('product.list') }}">Product List</a></li>
                        <li class="breadcrumb-item active">Product Detail</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary card-outline">
                        <div class="card-body box-profile">
                            <div id="fullpage" onclick="this.style.display='none';"></div>
                            <div class="gallery" onload="getPics()">
                                <div style="overflow-x: scroll;display: flex;">
                                    @foreach($product_images as $images)
                                    <div class="item">
                                        <img src="{{$images->image}}" alt="">
                                        <p>{{ $images->description }}</p>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script>
function getPics() {} 
const imgs = document.querySelectorAll('.gallery img');
const fullPage = document.querySelector('#fullpage');

imgs.forEach(img => {
    img.addEventListener('click', function() {
        fullPage.style.backgroundImage = 'url(' + img.src + ')';
        fullPage.style.display = 'block';
    });
});
</script>
@endsection