<!DOCTYPE html>
<html lang="en">
<head>
  <title>Quotation</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Google Font: Source Sans Pro -->
<link rel="stylesheet"
	href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
<!-- Font Awesome Icons -->
<link rel="stylesheet" href="{{ asset('/assets/plugins/fontawesome-free/css/all.min.css') }}">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="{{ asset('assets/plugins/jquery/jquery.min.js') }}"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" crossorigin="anonymous"></script>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js">
    </script>

<style>
	.select2-container .select2-selection--single {
    height: 40px;
	}
	
	.select2-container--default .select2-selection--single .select2-selection__clear {
    height: 39px;
    margin-top: -5px;
	}
	.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 39px;
	}
	.select2-container .select2-selection--single .select2-selection__clear {
    font-size: 1.8em;
	}
	.select2-container--default .select2-selection--single .select2-selection__arrow{
		   height: 38px;
	}
</style>
</head>
<body>

<div class="container mt-3 mb-3">
  <h2>Generate Quotation</h2>
  <hr>
  <form method="post" id="quotationform" action="{{ route('generatequotation') }}" name="quotationform" autocomplete="off">
	@csrf
	<input type="hidden" name="visitorid" value="{{ $visitorid }}" >
	<input type="hidden" name="userid" value="{{ $userid }}">
	<div class="row">
		<div class="col-md-12">
			<label for="invoicenumber" class="form-label">INVOICE NUMBER</label>
  			<input type="text" class="form-control" id="invoicenumber" name="invoicenumber" value="" required>
		</div>
		<div class="col-md-12 mt-2">
			<label for="invoicedate" class="form-label">INVOICE DATE</label>
  			<input type="text" class="form-control" id="invoicedate" name="invoicedate" value="" readonly required>
		</div>
		<div class="col-md-12 mt-2">
			<label for="modeofpayment" class="form-label">MODE OF PAMENT</label>
  			<input type="text" class="form-control" id="modeofpayment" name="modeofpayment" value="" required>
		</div>
		<div class="col-md-12 mt-2">
			<label for="gstn" class="form-label">GST NUMBER</label>
  			<input type="text" class="form-control" id="gstn" name="gstn" value="" required>
		</div>
		<div class="col-md-12 mt-2">
			<div class="form-check form-check-inline">
			  <input class="form-check-input" type="radio" name="gst" id="IGST" value="IGST" checked>
			  <label class="form-check-label" for="IGST">IGST</label>
			</div>
			<div class="form-check form-check-inline">
			  <input class="form-check-input" type="radio" name="gst" id="CGST" value="CGST ">
			  <label class="form-check-label" for="CGST">CGST </label>
			</div>
			<hr>
		</div>
		<div class="col-md-12">
			<h5>Add Product</h5>
			<hr>
		</div>
		<div class="col-md-12">
			<div class="dynamic-machine" id="dynamic-machine-1">
					<div class="mb-1 mt-1" >
						<select name="machine[]" class="form-control" id="dynamic-machine-list-1" onchange="machineOnChange('1')" required>
							<option value="" >Select</option>
							@foreach($machinList as $machin)
								<option value="{{ $machin->id }}" data-id="{{ $machin->price }}">{{ $machin->name }}</option>
							@endforeach 
						</select>
					</div>
					<div class="mb-1 mt-1" >
						<input type="number" name="machineprice[]" class="form-control" id="machineprice-1" placeholder="Price"  value="" onkeyup="calculatePrice('1')" required>
					</div>
					<div class="mb-1 mt-1" >
						<input type="number" name="machinqty[]" class="form-control" id="machinqty-1" placeholder="QTY"  value=""  onkeyup="calculatePrice('1')" required>
					</div>
					<div class="mb-3 mt-1" >
						<input type="number" name="machinetotalprice[]" class="form-control" id="machinetotalprice-1" placeholder="Total Price"  value="" readonly style="background-color: #f2f2f2;">
					</div>
			</div>
		</div>
		<div class="col-md-12 text-end">
			<div class="mt-1 append-buttons">
				<div class="clearfix">
					<button type="button" id="add-machinebutton"
						class="btn btn-secondary btn-sm float-left text-uppercase shadow-sm"><i
							class="fa fa-plus fa-fw"></i>
					</button>
					<button type="button" id="remove-machinebutton"
						class="btn btn-danger btn-sm float-left text-uppercase ml-1"
						disabled="disabled"><i class="fa fa-minus fa-fw"></i>
					</button>
				</div>
			</div>
		</div>
		<div class="col-md-12 mt-2">
			<button type="submit" class="btn btn-primary">Save</button>
		</div>
	</div>
	
  </form>
</div>

<script>
		$(function () {
        $("#invoicedate").datepicker({ 
            autoclose: true, 
            todayHighlight: true,
            format: 'dd-mm-yyyy' 
        }).datepicker('update', new Date());
    });
    $(document).ready(function() {
	    	// Add and remove dynamic machine
				var dynamicmachineCounter = 1;

				$('#dynamic-machine-list-1').val('');
				$('#dynamic-machine-list-1').select2({
				  placeholder: 'Select Product'
				});

				$('#add-machinebutton').click(function() {
		        dynamicmachineCounter++;
						var dynamicField = '<div class="dynamic-machine" id="dynamic-machine-'+dynamicmachineCounter+'"><div class="mb-1 mt-1" ><select name="machine[]" class="form-control" id="dynamic-machine-list-'+dynamicmachineCounter+'" onchange="machineOnChange('+dynamicmachineCounter+')">@foreach($machinList as $machin)<option value="{{ $machin->id }}" data-id="{{ $machin->price }}">{{ $machin->name }}</option>=@endforeach</select></div><div class="mb-1 mt-1" ><input type="number" name="machineprice[]" class="form-control" id="machineprice-'+dynamicmachineCounter+'" placeholder="Price"  value="" onkeyup="calculatePrice('+dynamicmachineCounter+')" required></div><div class="mb-1 mt-1" ><input type="number" name="machinqty[]" class="form-control" id="machinqty-'+dynamicmachineCounter+'" placeholder="QTY"  value="" onkeyup="calculatePrice('+dynamicmachineCounter+')" required></div><div class="mb-3 mt-1" ><input type="number" name="machinetotalprice[]" class="form-control" id="machinetotalprice-'+dynamicmachineCounter+'" placeholder="Total Price"  value="" readonly style="background-color: #f2f2f2;"></div></div>';
						$('.dynamic-machine').last().after(dynamicField);
						$('#dynamic-machine-list-'+dynamicmachineCounter).val('');
						$('#dynamic-machine-list-'+dynamicmachineCounter).select2({
							placeholder: 'Select Product'
						});
		        $('#remove-machinebutton').prop('disabled', false);
		    });

		    $('#remove-machinebutton').click(function() {
						console.log(dynamicmachineCounter);
		        if (dynamicmachineCounter > 1) {
		            $('#dynamic-machine-' + dynamicmachineCounter).remove();
		            dynamicmachineCounter--;

		            // Disable remove button if only one dynamic machine left
		            if (dynamicmachineCounter === 1) {
		                $(this).prop('disabled', true);
		            }
		        }
		    });
  	});
		function machineOnChange(index){
			var id = $('#dynamic-machine-list-'+index).val();
			var price = $('#dynamic-machine-list-'+index).find(':selected').data('id');
			//console.log(id,price,index);
			$('#machineprice-'+index).val(price);
			$('#machinqty-'+index).val(1);
			$('#machinetotalprice-'+index).val(price);
		}
		function calculatePrice(index){
				var machineprice = $('#machineprice-'+index).val();
				var machinqty = $('#machinqty-'+index).val();
				var totalprice = machineprice * machinqty;
				//console.log(machineprice,machinqty,totalprice);
				$('#machinetotalprice-'+index).val(totalprice);
		}
</script>
</body>
</html>
