<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Proforma Invoice</title>
    <style>
        body {
            font-family: sans-serif;
            /* Use a generic sans-serif font */
            font-size: 11px;
            /* Adjust base font size if needed */          
        }

        table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
        }

        th,
        td {
            border: 1px solid black;
            padding: 6px;
            /* Adjust padding for spacing */
            text-align: left;
            vertical-align: top;
            line-height: 1.2;
            /* Adjust line height for spacing */
        }

        th {
            text-align: center;
        }

        .no-border {
            border: none;
        }

        .bold-text {
            font-weight: bold;
        }

        .underline {
            text-decoration: underline;
        }

        .small-text {
            font-size: smaller;
        }

        .combined-border-left {
            border-left: 1px solid black;
        }

        .combined-border-top {
            border-top: 1px solid black;
        }

        .combined-border-bottom {
            border-bottom: 1px solid black;
        }

        .combined-border-right {
            border-right: 1px solid black;
        }

        .remove-bottom-border {
            border-bottom: none;
        }

        .remove-top-border {
            border-top: none;
        }

        .remove-right-border {
            border-right: none;
        }

        .remove-left-border {
            border-left: none;
        }

        .outer-border {
            border: 1px solid black;
        }

        hr {
            border: none;
            border-top: 1px solid black;
            /* margin: 20px 0; */
        }

        .border-top-none {
            border-top: none !important
        }

        .border-bottom-none {
            border-bottom: none !important
        }

        .border-left-none {
            border-left: none !important
        }

        .border-right-none {
            border-right: none !important
        }

        /* table */
    </style>
</head>

<body>

    <table class="">
        <thead>
            <tr>
                <th colspan="4" class="no-border" style="font-size: 1.2em;">PROFORMA INVOICE</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td colspan="2" style="border-right: none;" class="combined-border-left">
                    <div class="bold-text">PADMAVATI IMPEX</div>
                    GF 28, ASTALAXMI COMPLEX<br>
                    IDGAH ROAD, DARIYAPUR<br>
                    AHMEDABAD<br>
                    9909950208<br>
                    GSTIN/UIN: 24GDFPS7032Q1ZV<br>
                    State Name: Gujarat, Code: 24<br>
                    E-Mail: info.pdmimpex@gmail.com<br><br>
                    <hr>
                    <div class="bold-text">Buyer (Bill to)</div>
                    <div class="bold-text">{{ $visitor->company_name }}</div>
                    
                    {{ $visitor->address }}<br>
                    {{ $visitor->city }}<br>
                    GSTIN/UIN: {{ $gstn  }}<br>
                    State Name : {{ $visitor->state }}, Code : {{ $visitor->address }}<br>
                    Contact : {{ $visitor->mobile_no }}
                    <br>
                    <br>
                    <br>
                </td>
                <td class="" style="border-right: none;">
                    Invoice No.<br>
                    <span class="bold-text">{{ $invoicenumber }}</span>
                    <hr>
                    Delivery Note<br><br>
                    <hr>
                    Reference No. & Date.<br><br>
                    <hr>
                    Buyer's Order No.<br>
                    <span class="bold-text">TELEPHONIC</span><br>
                    <hr>
                    Dispatch Doc No.<br><br>
                    <hr>
                    Dispatched through<br>
                    <span class="bold-text">BY HAND</span><br>
                    <hr>
                    Bill of Lading/LR-RR No.<br>
                    <span class="bold-text">dt. </span><br>
                    <hr>
                    Terms of Delivery
                    <br>
                    <br>
                    <br>
                    <br>
                </td>
                <td class="combined-border-right">
                    Dated<br>
                    <span class="bold-text">{{ $invoicedate }}</span><br>
                    <hr>
                    Mode/Terms of Payment<br>
                    <span class="bold-text">{{ $modeofpayment }}</span><br>
                    <hr>
                    Other References<br><br>
                    <hr>
                    Dated<br>
                    <span class="bold-text">{{ $invoicedate }}</span><br>
                    <hr>
                    Delivery Note Date<br><br>
                    <hr>
                    Destination<br><br>
                    <hr>
                    Motor Vehicle No.
                </td>
            </tr>
        </tbody>
    </table>

    <table>
        <thead>
            <tr>
                <th class="border-top-none border-right-none">SI No.</th>
                <th class="border-top-none border-right-none">Description of Goods</th>
                <th class="border-top-none border-right-none">HSN/SAC</th>
                <th class="border-top-none border-right-none">Quantity</th>
                <th class="border-top-none border-right-none">Rate</th>
                <th class="border-top-none border-right-none">per</th>
                <th class="border-top-none border-right-none">Disc. %</th>
                <th class="border-top-none">Amount</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $i = 1;
            $total = 0;
            $qtytotal = 0;
            foreach ($machinList as $obj) {
            ?>
                <tr class="border-bottom-none">
                    <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;">{{ $i }}</td>
                    <td class="border-bottom-none border-top-none border-right-none">{{ $obj->name }}</td>
                    <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;">{{ $obj->hsn_code }}</td>
                    <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;">{{ $obj->qty }}</td>
                    <td class="border-bottom-none border-top-none border-right-none" style="text-align:right;">{{ number_format($obj->price,2) }}</td>
                    <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;">Nos</td>
                    <td class="border-bottom-none border-top-none border-right-none"></td>
                    <td class="border-bottom-none border-top-none" style="text-align:right;">{{ number_format($obj->price * $obj->qty,2) }}</td>
                </tr>
            <?php
                $newtotal = $obj->price * $obj->qty;
                $total += $newtotal;
                $qtytotal = $qtytotal + $obj->qty;
                $i++;
            }
            ?>
            <tr class="border-bottom-none">
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:right;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none"></td>
                <td class="border-bottom-none border-top-none" style="text-align:right;">{{ number_format($total,2)}}</td>                
            </tr>            
            <?php
                $igst = 0;
                $cgst = 0;
                $sgst = 0;
                $grangtotal = 0;
                if($gst == 'IGST'){
                    $gstval = ($total * 18) / 100;
                    $igst =number_format($gstval,2);
                    $grangtotal = $total + $gstval;
                }else{
                    $gstval1 = ($total * 9) / 100;
                    $gstval2 = ($total * 9) / 100;
                    $cgst = number_format($gstval1,2);
                    $sgst = number_format($gstval2,2);
                    $grangtotal = $total + $gstval1 + $gstval2;
                }
            ?>
            <tr style="" class="border-bottom-none">
                <td  style="height: 200px !important;" class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                @if($gst == 'IGST')
                    <td class="border-bottom-none border-top-none border-right-none">
                        <span style="float:right;"><b><i>Output IGST</i></b><br><!-- <b><i>ROUND OFF</i></b></span><br><br> -->
                        <!-- <span style="float:right;">Less : <br> -->
                    </td>
                @else
                    <td class="border-bottom-none border-top-none border-right-none">
                        <span style="float:right;"><b><i>Output CGST</i></b><br><b><i>Output SGST</i></b> <br><!-- <b><i>ROUND OFF</i></b></span><br><br> -->
                        <!-- <span style="float:right;">Less : <br> -->
                    </td>
                @endif
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:right;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none"></td>
                @if($gst == 'IGST')
                    <td class="border-bottom-none border-top-none" style="text-align:right;">
                    <span style="float:right;"><b>{{ $igst }}</b><br><!-- <b>(-)0.44</b></span><br> --><br>
                </td>
                @else
                    <td class="border-bottom-none border-top-none" style="text-align:right;">
                    <span style="float:right;"><b>{{ $cgst }}</b><br><b>{{ $sgst }}</b> <br><!-- <b>(-)0.44</b></span><br> --><br>
                </td>
                @endif
                
            </tr>
            <tr class="border-bottom-none">
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:right;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none"></td>
                <td class="border-bottom-none border-top-none" style="text-align:right;"></td>                
            </tr>
            <tr class="border-bottom-none">
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:right;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none"></td>
                <td class="border-bottom-none border-top-none" style="text-align:right;"></td>                
            </tr>
            <tr class="border-bottom-none">
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:right;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none"></td>
                <td class="border-bottom-none border-top-none" style="text-align:right;"></td>                
            </tr>
            <tr class="border-bottom-none">
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:right;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none"></td>
                <td class="border-bottom-none border-top-none" style="text-align:right;"></td>                
            </tr>
            <tr class="border-bottom-none">
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:right;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none"></td>
                <td class="border-bottom-none border-top-none" style="text-align:right;"></td>                
            </tr>
            <tr class="border-bottom-none">
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:right;"></td>
                <td class="border-bottom-none border-top-none border-right-none" style="text-align:center;"></td>
                <td class="border-bottom-none border-top-none border-right-none"></td>
                <td class="border-bottom-none border-top-none" style="text-align:right;"></td>                
            </tr>

            <tr class="border-bottom-none">
                <td class="border-right-none" style="text-align:center;"></td>
                <td class="border-right-none" style="text-align:right">Total</td>
                <td class="border-right-none" style="text-align:center;"></td>
                <td class="border-right-none" style="text-align:center;"><b>{{number_format($qtytotal,2)}} Nos</b></td>
                <td class="border-right-none" style="text-align:right;"></td>
                <td class="border-right-none" style="text-align:center;"></td>
                <td class="border-right-none"></td>
                <td class="" style="text-align:right;"> <img height="10" width="10" src="{{asset('assets/images/rupee-indian.png')}}" alt=""> {{ number_format($grangtotal,2) }}</td>
            </tr>
            <tr class="border-bottom-none">
                <td colspan="8" class="border-top-none" style="text-align:left;">
                    <span>Amount Chargeable (in words) <br><b style="font-size: 16px !important">INR {{ \App\Helpers\NumberToWords::convert($grangtotal) }}</b></span>
                </td>
            </tr>
        </tbody>
    </table>
    <table>
        <tbody>
            <tr>
                <td style="height: 50px !important;" class="border-bottom-none border-top-none border-right-none" colspan="12"></td>
                <td style="margin-left:100px;" colspan="2"  class="border-top-none border-left-none border-right-none">
                    Company's Bank Details <br>
                    Bank Name : KOTAK MAHINDRA BANK <br>
                    A/c No. : 7912078318 <br>
                    Branch & IFS Code : NARANPURA, AHMEDABAD & KKBK0000838
                </td>
                <td class="border-top-none border-right-none border-left-none">

                </td>
                <td class="border-top-none  border-left-none">

                </td>
            </tr>
            <tr>
                <td style="height: 50px !important;" class="border-top-none border-right-none" colspan="12">
                   <u>Declaration</u>  <br>
                    We declare that this invoice shows the actual price of the goods described and that all particulars are true and correct.
                </td>
                <td style="margin-left:100px;" colspan="4"  class="border-top-none">
                  <span style="float: right">for PADAMAVATI IMPEX <br><br><br> Authorised Signatory</span>
                </td>
            </tr>
        </tbody>
    </table>
</body>

</html>
