@extends('layouts.master')
@section('content')
<style>
     #cke_notifications_area_content{
            display: none !important;
    }
</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Quotation Configuration</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active">Quotation Configuration</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('setting.editquotation_config') }}" name="form" enctype="multipart/form-data">
                                @csrf
                                <input type="hidden" name="id" value="{{ $quotationconfig ? $quotationconfig->id : ''}}">
                                <div class="form-group ml-3">
                                    <label class="form-label">Header Image</label>
                                    <input class="form-control col-lg-10" type="file" name="header_image" id="header_image"  accept="image/*">
                                    @if($quotationconfig && $quotationconfig->header_image != "")
                                    <img src="{{$quotationconfig->header_image}}" class="mt-4" height="120px"> 
                                    <button type="button" class="btn btn-sm btn-danger" id="delete_header_image" data-id="{{ $quotationconfig ? $quotationconfig->id : ''}}"><i class="fas fa-trash" aria-hidden="true"></i></button>
                                    @endif
                                   
                                </div>
                                <div class="form-group ml-3">
                                    <label class="form-label">Footer Image</label>
                                    <input class="form-control col-lg-10" type="file" name="footer_image" id="footer_image"  accept="image/*">
                                    @if($quotationconfig && $quotationconfig->footer_image != "")
                                    <img src="{{$quotationconfig->footer_image}}" class="mt-4" height="120px"> 
                                    <button type="button" class="btn btn-sm btn-danger" id="delete_footer_image" data-id="{{ $quotationconfig ? $quotationconfig->id : ''}}"><i class="fas fa-trash" aria-hidden="true"></i></button>
                                    @endif
                                </div>
                                <div class="form-group ml-3">
                                    <label class="form-label">Terms and Conditions:</label>
                                    <textarea class="form-control col-lg-10"  name="term_condition" id="content" cols="30" rows="20">{{ $quotationconfig ? $quotationconfig->term_condition : ''}}</textarea>
                                </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary" >Submit</button>
                                </div>
                            </form>
                        </div>
                       
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@push('scripts')
<script>
    /*$(document).ready(function () {
        CKEDITOR.replace('content', {
            height: 250
        });
        
    });*/
    $('#delete_header_image').click(function() {
            var id = $(this).attr('data-id');
            let url = "{{ route('setting.deletequotationconfigimage') }}";
            swal({
                title: 'Are you sure!',
                icon: 'error',
                dangerMode: true,
                buttons: true,
                confirm: "Confirm",
            }).then(function(isConfirm) {
                if (isConfirm === true) {
                    $.ajax({
                        type: 'GET',
                        url: url,
                        data: {
                            id: id,
                            type: "header_image"
                        },
                        dataType: 'json',
                        success: function(data) {
                            location.reload(true);
                        },
                        error: function(data) {
                            console.log(data);
                        }
                    });
                }
            });
        });
        $('#delete_footer_image').click(function() {
            var id = $(this).attr('data-id');
            let url = "{{ route('setting.deletequotationconfigimage') }}";
            swal({
                title: 'Are you sure!',
                icon: 'error',
                dangerMode: true,
                buttons: true,
                confirm: "Confirm",
            }).then(function(isConfirm) {
                if (isConfirm === true) {
                    $.ajax({
                        type: 'GET',
                        url: url,
                        data: {
                            id: id,
                            type: "footer_image"
                        },
                        dataType: 'json',
                        success: function(data) {
                            location.reload(true);
                        },
                        error: function(data) {
                            console.log(data);
                        }
                    });
                }
            });
        });
</script>
@endpush
@endsection