@extends('layouts.master')
@section('content')
<style>
    .select2-container .select2-selection--single {
        height: 38px !important;
    }

    .select2-container--default .select2-results>.select2-results__options {
        max-height: 500px !important;
        overflow-y: auto;
    }

</style>
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Integrations</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                            <li class="breadcrumb-item active">Integrations</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <!-- Default box -->
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title"><b>IndiaMart</b></h3>
                                <a href="#" id="India_Mart_Edit"><i class="fas fa-edit ml-2"></i></a>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"
                                        title="Collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="card-body">
                                <form method="post" action="{{ route('setting.update_key') }}" name="form"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="action"
                                        value="{{ empty($keyname) ? 'insert' : 'update' }}">
                                    <input type="hidden" name="id"
                                        value="{{ !empty($keyname->id) ? $keyname->id : '' }}">

                                        <div class="form-group d-flex">
                                            <div class="col-4">
                                                <label for="">IndiaMart URL</label>
                                                <div class="input-group">
                                                    <input type="text" value="{{ route('indiamart_crm') }}" class="form-control" disabled id="redirectUrl2">
                                                    <div class="input-group-append">
                                                        <span id="copyButton2" class="btn btn-secondary" onclick="copyToClipboard2()" data-toggle="tooltip" title="Copy to clipboard">Copy</span>
                                                    </div>
                                                </div>
                                            </div>
                                            @if(Session::get('bulk_whatsapp') == 1)
                                                <div class="col-4">
                                                    <label for="templateSelect">Select Auto-Reply Whatsapp Template</label>
                                                    <div class="input-group">
                                                        <select class="form-control" id="templateSelect" name="whatsapp_template_id">
                                                            <option value="">No Template Selected</option>
                                                            @foreach ($templates as $template)
                                                                <option value="{{ $template->whatsapp_template_id }}" @if($keyname?->whatsapp_template_id == $template->whatsapp_template_id) selected @endif data-file-type="{{ $template->file_type }}">
                                                                    {{ $template->name }}
                                                                    @if(isset($template->header) && !empty($template->header))
                                                                        - <small>{{ $template->header }}</small>
                                                                    @endif
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                            @endif

                                        </div>

                                    <div class="form-group">
                                        <div class="col-4">
                                            <label for="">IndiaMart Key</label>
                                            <input type="text" name="indiamartkey"
                                                class="form-control @error('indiamartkey') is-invalid @enderror"
                                                id="indiamartkey" placeholder="Enter IndiaMart Key"
                                                value="{{ !empty($keyname->indiamartkey) ? $keyname->indiamartkey : '' }}">

                                            @if ($errors->has('indiamartkey'))
                                                <div class="form-text text-danger">
                                                    {{ $errors->first('indiamartkey') }}
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <button type="submit"
                                            class="btn btn-primary" id="indiamart_submit">Generate</button>
                                    </div>
                                </form>
                            </div>
                        </div>

                        {{-- //TradIndia Key --}}
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title"><b>Trade India</b></h3>
                                <a href="#" id="Tradindia_Edit"><i class="fas fa-edit ml-2"></i></a>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"
                                        title="Collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="card-body">
                                <form method="post" action="{{ route('setting.update_key') }}" name="form"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="action"
                                        value="{{ empty($tradKey) ? 'insert' : 'update' }}">
                                    <input type="hidden" name="id"
                                        value="{{ !empty($tradKey->id) ? $tradKey->id : '' }}">
                                    <input type="hidden" name="tradindiakey">
                                    <!-- <div class="form-group">
                                            <div class="col-4">
                                                <label for="">TradIndiaKey</label>
                                                <input type="text" name="tradindiakey"
                                                    class="form-control @error('tradindiakey') is-invalid @enderror" id="tradindiakey"
                                                    placeholder="Enter TradIndia Key" value="{{ !empty($tradKey->indiamartkey) ? $tradKey->indiamartkey : '' }}" required>

                                                @if ($errors->has('tradindiakey'))
    <div class="form-text text-danger">
                                                    {{ $errors->first('tradindiakey') }}
                                                </div>
    @endif
                                            </div>
                                        </div> -->
                                    <div class="form-group">
                                        <div class="col-4">
                                            <label for="">User Id</label>
                                            <input type="text" name="user_id"
                                                class="form-control @error('user_id') is-invalid @enderror" id="user_id"
                                                placeholder="Enter User Id"
                                                value="{{ !empty($tradKey->user_id) ? $tradKey->user_id : '' }}" required disabled>

                                            @if ($errors->has('user_id'))
                                                <div class="form-text text-danger">
                                                    {{ $errors->first('user_id') }}
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-4">
                                            <label for="">Profile Id</label>
                                            <input type="text" name="profile_id"
                                                class="form-control @error('profile_id') is-invalid @enderror"
                                                id="profile_id" placeholder="Enter Profile Id"
                                                value="{{ !empty($tradKey->profile_id) ? $tradKey->profile_id : '' }}"
                                                required disabled>

                                            @if ($errors->has('profile_id'))
                                                <div class="form-text text-danger">
                                                    {{ $errors->first('profile_id') }}
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-4">
                                            <label for="">Key</label>
                                            <input type="text" name="key"
                                                class="form-control @error('key') is-invalid @enderror" id="key"
                                                placeholder="Enter Key"
                                                value="{{ !empty($tradKey->key) ? $tradKey->key : '' }}" required  disabled>

                                            @if ($errors->has('key'))
                                                <div class="form-text text-danger">
                                                    {{ $errors->first('key') }}
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <button type="submit"
                                            class="btn btn-primary" id="Tradindia_Submit" disabled>Save</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">
                                    <b>ZOHO</b>
                                    <a href="#" id="enableZoho"><i class="fas fa-edit ml-2"></i></a>
                                    @if(isset($zoho_crm))
                                        @if(!empty($zoho_crm->access_token))
                                        <button class="btn btn-success" style="background: #28a745;border:none;margin-left:367px;">Active</button>
                                        @else
                                        <button class="btn btn-danger" style="border:none;margin-left:367px;">Inactive</button>
                                        @endif
                                    @endif
                                </h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="card-body">
                                <form method="post" action="{{ route('zohocCrmSave') }}" name="form" enctype="multipart/form-data" target="_blank">
                                    @csrf


                                    <div class="form-group">
                                        <div class="col-4">
                                            <label for="">Redirect URL</label>
                                            <div class="input-group">
                                                <input type="text" value="{{ route('zoho_crm') }}" class="form-control" disabled id="redirectUrl">
                                                <div class="input-group-append">
                                                    <span id="copyButton" class="btn btn-secondary" onclick="copyToClipboard()" data-toggle="tooltip" title="Copy to clipboard">Copy</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <div class="col-4">
                                            <label for="">Client Id</label>
                                            <input type="text" name="client_id"
                                                class="form-control @error('client_id') is-invalid @enderror"
                                                id="client_id" placeholder="Enter client id"
                                                value="{{ $zoho_crm->client_id ?? '' }}"
                                                required disabled>

                                            @if ($errors->has('client_id'))
                                                <div class="form-text text-danger">
                                                    {{ $errors->first('client_id') }}
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-4">
                                            <label for="">Client Secret</label>
                                            <input type="text" name="client_secret"
                                                class="form-control @error('client_secret') is-invalid @enderror"
                                                id="client_secret" placeholder="Enter client secret"
                                                value="{{ $zoho_crm->client_secret ?? '' }}"
                                                required disabled>

                                            @if ($errors->has('client_secret'))
                                                <div class="form-text text-danger">
                                                    {{ $errors->first('client_secret') }}
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <button type="submit" class="btn btn-primary" id="zohoSubmitButton" disabled>Generate Key</button>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">
                                    <b>Facebook</b>

                                </h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="card-body">

                                <form method="post" class="row ajaxForm" action="{{ route('setting.facebookConfigSave') }}" name="form" enctype="multipart/form-data" target="_blank">
                                    @csrf
                                    <input type="hidden" class="facebookConfingId" name="id" value="0">
                                    <input type="hidden" class="integrationType" name="integrationType" value="add">
                                    <input type="hidden" name="event_id" class="form-control" id="hidden_event_id" >
                                    <div class="col-3">
                                        <label for="event_name">Event Name</label>
                                        <input type="text" name="event_name" class="form-control" id="event_name" placeholder="Enter Event Name">
                                        <span class="text-danger event_name-error common-ajax-error"></span>
                                    </div>
                                    <div class="col-3">
                                        <label for="customer_id">Team Member</label>
                                        <select name="customer_id" class="form-select select2" id="customer_id" placeholder="Select Team Member">
                                            <option value="">Select Team Member</option>
                                            @foreach ($users as $user)
                                                <option value="{{ $user->CustomerID }}">{{ $user?->CustomerName }} - {{ $user?->CustomerID }}</option>
                                            @endforeach
                                        </select>
                                        <span class="text-danger customer_id-error common-ajax-error"></span>

                                    </div>
                                    <div class="col-4">
                                        <label for="app_id">App Id</label>
                                        <input type="text" name="app_id" class="form-control" id="app_id" placeholder="Enter App Id">
                                        <span class="text-danger app_id-error common-ajax-error"></span>
                                    </div>
                                    <div class="col-2 d-flex justify-content-center align-items-end">
                                        <button type="submit" class="btn btn-primary"><span class="submit-text">Add</span>
                                            <div class="spinner-border text-light submit-loader" role="status" style="width:16px;height:16px;display:none;">
                                              <span class="visually-hidden"></span>
                                            </div></button>
                                    </div>
                                    <div class="col-10">
                                        <label for="access_token">Access Token</label>
                                        <input type="text"  autocomplete="off" name="access_token" class="form-control" id="access_token" placeholder="Enter Access Token">
                                        <span class="text-danger access_token-error common-ajax-error"></span>

                                    </div>
                                </form>

                                <div class="mt-4">
                                    <table class="table table-bordered ajaxReloadDatatable mt-4" data-url="{{ route('setting.facebookConfigList') }}" id="facebookDatatable">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Event Name</th>
                                                <th>APP ID</th>
                                                <th>Team Member</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        {{-- <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Default SMTP Settings</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('setting.update_emailconfig') }}" name="form"
                                enctype="multipart/form-data">
                                @csrf
                                <input type="hidden" name="action" value="{{ empty($user_emailconfig) ? 'insert' : 'update' }}">
                                <input type="hidden" name="id" value="{{!empty($user_emailconfig->id) ? $user_emailconfig->id : ''}}">
                                <div class="form-group">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label for="">Host</label>
                                            <input type="text" name="host" class="form-control" id="" placeholder="Enter Host"
                                                value="{{isset($user_emailconfig->host) ? $user_emailconfig->host : ""}}" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="">User Name</label>
                                            <input type="text" name="username" class="form-control" id="" placeholder="Enter username"
                                                value="{{isset($user_emailconfig->username) ? $user_emailconfig->username : ""}}" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="">Password</label>
                                            <input type="password" name="password" class="form-control" id="" placeholder="Enter password"
                                                value="{{isset($user_emailconfig->password) ? $user_emailconfig->password : ""}}" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="">Smtp Port</label>
                                            <input type="text" name="smtp_port" class="form-control" id="" placeholder="Enter smtp_port"
                                                value="{{isset($user_emailconfig->smtp_port) ? $user_emailconfig->smtp_port : ""}}" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="">Smtp Transport</label>
                                            <input type="text" name="smtp_transport" class="form-control" id="" placeholder="Enter smtp_transport"
                                                value="{{isset($user_emailconfig->smtp_transport) ? $user_emailconfig->smtp_transport : ""}}" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="">Smtp Encryption</label>
                                            <input type="text" name="smtp_encryption" class="form-control" id="" placeholder="Enter smtp_encryption"
                                                value="{{isset($user_emailconfig->smtp_encryption) ? $user_emailconfig->smtp_encryption : ""}}" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary">{{ empty($keyname) ? 'Add' : 'Update' }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> --}}

        <!-- Default box -->


    </div>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>

function setAjaxLoader(btn, state) {
    var text = btn.find(".submit-text");
    var loader = btn.find(".submit-loader");
    if (state) {
        loader.show()
        btn.prop("disabled", true);
    } else {
        btn.prop("disabled", false);
        loader.hide()
    }
}

function resetForm(){
    $('.facebookConfingId').val("");
    $('#hidden_event_id').val("");
    $('.integrationType').val("add");

                $('#app_id').val("");
                $('#access_token').val("");
                $('#event_name').val("").prop("readonly", false);
                $('#customer_id').val("").trigger("change.select2");
                $('.ajaxForm button[type="submit"] .submit-text').text("Add");
}
        $(document).ready(function() {

    $('#customer_id').select2();

              // Add toast container once with inline styles
    if ($(".toast-container").length === 0) {
        $("body").append(
            '<div class="toast-container" ' +
            'style="position:fixed;bottom:20px;right:20px;z-index:9999;"></div>'
        );
    }

    $(document).on("click", ".copy-btn", function () {
        let textToCopy = $(this).data("copy");

        // Copy text
        if (navigator.clipboard) {
            navigator.clipboard.writeText(textToCopy).then(() => {
                showToast("Copied: " + textToCopy);
            }).catch(() => {
                showToast("Failed to copy!");
            });
        } else {
            let tempInput = $("<input>");
            $("body").append(tempInput);
            tempInput.val(textToCopy).select();
            document.execCommand("copy");
            tempInput.remove();
            showToast("Copied: " + textToCopy);
        }
    });

    // Toast function with inline styles
    function showToast(message) {
        let $toast = $('<div></div>').text(message).css({
            "background": "#333",
            "color": "#fff",
            "padding": "10px 16px",
            "margin-top": "8px",
            "border-radius": "6px",
            "font-size": "14px",
            "opacity": "0",
            "transform": "translateY(20px)",
            "transition": "all 0.3s ease-in-out"
        });

        $(".toast-container").append($toast);

        // Show animation
        setTimeout(() => {
            $toast.css({"opacity": "1", "transform": "translateY(0)"});
        }, 100);

        // Hide after 3 seconds
        setTimeout(() => {
            $toast.css({"opacity": "0", "transform": "translateY(20px)"});
            setTimeout(() => $toast.remove(), 300);
        }, 3000);
    }

            var table = $('#facebookDatatable').DataTable({
                processing: true,
                serverSide: true,
                cache: false,
                ajax: {
                    type: "POST",
                    url: $('#facebookDatatable').data('url'),
                    cache: false,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: function(d) {
                        d.search = $('#facebookDatatable_filter input[type="search"]').val()
                    }
                },
                columns: [{
                        data: 'id',
                        name: 'id',
                        searchable: false,
                        visible: false
                    },
                    {
                        data: 'event_name',
                        name: 'event_name',
                        searchable: false
                    },
                    {
                        data: 'app_id',
                        name: 'app_id',
                        searchable: false,
                    },
                    {
                        data: 'CustomerName',
                        name: 'users.CustomerName',
                        searchable: false,
                    },
                    {
                        data: 'id',
                        name: 'id',
                        searchable: false,
                        orderable: false,
                        render: function(data, type, row) {
                            let webhookUrl =(`{{route('facebook.webhook',":appId")}}`).replace(":appId", row.app_id);
                            let verifyKey =`${row.app_id}facebook`;
                            return `<a href="javascript:void(0)" class="btn btn-secondary editButton" data-event_id="${row.event_id}" data-id="${data}" data-customer_id="${row.customer_id}" data-app_id="${row.app_id}" data-access_token="${row.access_token}" data-event_name="${row.event_name}">Edit</a><button type="button" class="copy-btn btn btn-warning ml-3" data-copy="${webhookUrl}"><i class="far fa-copy"></i> Copy Webhook Link</button><button type="button" class="copy-btn btn btn-primary ml-3" data-copy="${verifyKey}"><i class="far fa-copy"></i> Copy Verify Key</button>`;
                            // return `<button type="button" class="copy-btn btn btn-warning ml-3" data-copy="${webhookUrl}"><i class="far fa-copy"></i> Webhook</button><button type="button" class="copy-btn btn btn-primary ml-3" data-copy="${verifyKey}"><i class="far fa-copy"></i> Verify Key</button>`;
                        }
                    }
                ],
                order: [
                    [0, 'desc']
                ]
            });

            $(document).on('click', ".editButton", function (e) {
                e.preventDefault();
                const id = $(this).data('id');
                const app_id = $(this).data('app_id');
                const access_token = $(this).data('access_token');
                const event_name = $(this).data('event_name');
                const customer_id = $(this).data('customer_id');
                const event_id = $(this).data('event_id');
                // console.log(id, app_id, access_token, event_name, customer_id);
                resetForm();
                $('.facebookConfingId').val(id);
                $('#app_id').val(app_id);
                $('#access_token').val(access_token);

                if(access_token && (access_token) != ''){
                    $('#access_token').val("*****");
                }

                    // *****
                $('.integrationType').val("edit");

                $('#event_name').val(event_name).prop("readonly", true);
                $('#hidden_event_id').val(event_id);
                $('#customer_id').val(customer_id).trigger("change.select2");
                $('.ajaxForm button[type="submit"] .submit-text').text("Update");
            });

            $(document).on('submit', ".ajaxForm", function (e) {
        e.preventDefault();
        const Url = $(this).prop('action')
        const redirect = $(this).data('redirect')
        const form = $(this)
        const beforeSubmitFunction = form.data('before-ajax-function');
        const Btn = $(this).find('button[type="submit"]');
        if ((Url !== undefined && Url !== null)) {
            var form_id = form[
                0];
            var formData = new FormData(form_id);
            // formData.append("deleteProblemIds", deleteIds);
            form.find(".common-ajax-error").html("");
            if (window[beforeSubmitFunction]) {
                res = window[beforeSubmitFunction](form, formData, Btn);
                if (res == false) {
                    return true;
                }
            }
            setAjaxLoader(Btn, true);
            $.ajax({
                type: form.prop('method'),
                url: Url,
                data: formData,
                dataType: "json",
                cache: false,
                processData: false,
                contentType: false,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr(
                        'content')
                },
                success: function (response) {
                    setAjaxLoader(Btn, false);

                    console.log(response);
                    if (response.status) {
                        if ($(".ajaxReloadDatatable")) {
                            $(".ajaxReloadDatatable").DataTable().ajax.reload();
                        }
                        resetForm();

                        // Swal.fire('Success!', response.message,
                        //     'success').then((result) => {

                        //     });
                    } else {
                        Swal.fire('Error!', response.message,
                            'error');
                    }
                },
                error: function (xhr) {
                    setAjaxLoader(Btn, false);
                    var error = xhr.responseJSON;
                    // console.log(xhr.responseJSON);
                    if (xhr.status == 422) {
                        Object.entries(error.error).forEach(function (item, index) {
                            const [key, value] = item;
                            form.find(`.${key.replaceAll('.', '-')}-error`).html(value);
                        })
                    } else {
                        Swal.fire('Error!', error.message,
                            'error');
                    }


                }
            });
        }
    })
            // Apply CSS using jQuery with !important


            // Initialize Select2 with custom rendering of the dropdown options
            $('#templateSelect').select2({
                templateResult: function(data) {
                    // Create a basic span to hold the option text
                    var $result = $('<span>' + data.text + '</span>');

                    // Apply border between options
                    $result.css({
                        'display': 'block',
                        'padding': '8px',
                        'border-bottom': '1px solid #ddd',  // Adding border
                        'color': '#333'  // Optional: change text color
                    });

                    // Check the custom data attribute 'data-file-type' for image or pdf
                    var fileType = $(data.element).data('file-type');

                    if (fileType === 'image') {
                        // Image Icon for image files (without "image" text)
                        $result.prepend('<img src="{{asset('assets/images/dashboard_icons/file.png')}}" alt="image-icon" style="width: 20px; height: 20px; margin-right: 5px; vertical-align: middle;">');
                    } else if (fileType === 'pdf') {
                        // PDF Icon for pdf files (without "pdf" text)
                        $result.prepend('<img src="{{asset('assets/images/dashboard_icons/pdf.png')}}" alt="pdf-icon" style="width: 20px; height: 22px; margin-right: 5px; vertical-align: middle;">');
                    }

                    // Check if the option contains a hyphen for multi-line text (name + header)
                    if (data.text.indexOf('-') > -1) {
                        var parts = data.text.split('-');
                        return $('<span>' + parts[0] + '<br><small>' + parts[1] + '</small></span>')
                            .css({
                                'display': 'block',
                                'padding': '8px',
                                'border-bottom': '1px solid #ddd', // Border between options
                                'color': '#333'
                            });
                    }

                    return $result;
                },
                templateSelection: function(data) {
                    // Return the selected text (name and header)
                    return data.text;
                }
            });

            // $('.select2-selection--single').css({
            //     'background': '#e9ecef !important',
            //     'border-color': '#80bdff !important' // Adding !important
            // });
        });
    </script>

    <script>
        function copyToClipboard() {
            const urlInput = document.getElementById('redirectUrl');

            // Create a temporary input element to hold the text
            const tempInput = document.createElement('input');
            tempInput.value = urlInput.value;
            document.body.appendChild(tempInput);
            tempInput.select();
            document.execCommand('copy');
            document.body.removeChild(tempInput);

            // Change button text and reset after 2 seconds
            const copyButton = document.getElementById('copyButton');
            copyButton.innerText = 'Copied';

            setTimeout(() => {
                copyButton.innerText = 'Copy';
            }, 1000);
        }

        function copyToClipboard2() {
            const urlInput = document.getElementById('redirectUrl2');

            // Create a temporary input element to hold the text
            const tempInput = document.createElement('input');
            tempInput.value = urlInput.value;
            document.body.appendChild(tempInput);
            tempInput.select();
            document.execCommand('copy');
            document.body.removeChild(tempInput);

            // Change button text and reset after 2 seconds
            const copyButton = document.getElementById('copyButton2');
            copyButton.innerText = 'Copied';

            setTimeout(() => {
                copyButton.innerText = 'Copy';
            }, 1000);
        }

        // Initialize tooltips
        $(document).ready(function(){
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#enableZoho').click(function(event) {
                event.preventDefault();
                $('#client_id').removeAttr('disabled');
                $('#client_secret').removeAttr('disabled');
                $('#zohoSubmitButton').removeAttr('disabled');
            });

            $('#India_Mart_Edit').click(function(event) {
                event.preventDefault();
                // $('#indiamartkey').removeAttr('disabled');
                // $('#indiamart_submit').removeAttr('disabled');
                // $('#templateSelect').removeAttr('disabled');
            });

            $('#Tradindia_Edit').click(function(event) {
                event.preventDefault();
                $('#profile_id').removeAttr('disabled');
                $('#user_id').removeAttr('disabled');
                $('#key').removeAttr('disabled');
                $('#Tradindia_Submit').removeAttr('disabled');
            });
        });
    </script>
@endsection

