@extends('layouts.master')
@section('content')
<style>
.class-link {
    color: #6cc417;
    text-decoration: none;
}

.class-link:hover {
    color: #ffbb00;
}
.error {
    color: red;
}
</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Edit Template </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('template.list') }}">Template List</a></li>
                        <li class="breadcrumb-item active">Edit Template</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form id="editForm"  method="post" action="{{ route('template.update',$template->id) }}" name="form"
                                enctype="multipart/form-data">
                                @csrf
                                <div class="form-group">
                                    <label for="">Template Name</label>
                                    <input type="text" name="name" class="form-control" id="name" placeholder="Template Name"
                                        value="{{$template->name}}" required>
                                </div>
                                <div class="form-group">
                                    <label for="">File Required ?</label>&nbsp;&nbsp;&nbsp;
                                    <input type="radio" name="file_required" id="" value="yes" {{$template->file_type ? 'checked' : ''}}>
                                    <label for="">Yes</label>
                                    <input type="radio" name="file_required" id="" value="no" {{!$template->file_type ? 'checked' : ''}}> <label for="">No</label>
                                </div>
                                {{-- @if ($template->file_type) --}}
                                    <div class="form-group" id="show-file-type" style="{{ ($template->file_type) ? 'display:block' : 'display:none' }}" >
                                        <label for="">File type</label>&nbsp;&nbsp;&nbsp;
                                        <input type="radio" name="file_type" id="" value="image" {{$template->file_type == 'image' ? 'checked' : ''}}>
                                        <label for="">Image</label>
                                        <input type="radio" name="file_type" id="" value="pdf" {{$template->file_type == 'pdf' ? 'checked' : ''}}> <label for="">PDF</label>
                                    </div>
                                {{-- @endif --}}
                                {{-- @if ($template->file_type == 'image') --}}
                                    <div class="form-group" id="show-image"  style="{{ ($template->file_type == 'image') ? 'display:block' : 'display:none' }}">
                                        <label for=""><i class="fa fa-image"></i> Upload
                                            Image (Optional)</label>
                                        <input type="file" name="image" id="image" accept=".png, .jpg, .jpeg" onchange="validate_fileupload(this,'image');">
                                        </br>
                                        <img src="{{$template->file_url}}" alt="Image" class="img" width="200" height="200">
                                    </div>
                                {{-- @endif --}}
                                {{-- @if ($template->file_type == 'pdf') --}}
                                    <div class="form-group" id="show-pdf" style="{{ ($template->file_type == 'pdf') ? 'display:block' : 'display:none' }}" >
                                        <label for=""><i class="fa fa-image"></i> Upload
                                            PDF (Optional)</label>
                                        <input type="file" name="pdf" id="pdf" accept=".pdf" onchange="validate_fileupload(this,'pdf');">
                                        <a href="{{$template->file_url}}" target="_blank" style="text-decoration: none;">
                                            <i class="far fa-file-pdf pdf-icon fa-2x" style="color:red;"></i> {{$template->file}}
                                        </a>
                                    </div>
                                {{-- @endif --}}
                                @if (!$template->file_type)
                                    <div class="form-group" id="show-header">
                                        <label for="">Header</label>
                                        <input type="text" name="header" class="form-control" id="header" placeholder="Header"
                                            value="{{$template->header}}" required>
                                    </div>
                                @endif
                                <div class="form-group">
                                    <label for="">Message</label>
                                </div>
                                <textarea name="message" id="message" rows="25" cols="100"
                                        value="" required>{{$template->message}}</textarea>
                                <div class="form-group">
                                    <label for="">Footer</label>
                                    <input type="text" name="footer" class="form-control" id="footer" placeholder="Footer"
                                        value="{{$template->footer}}" required>
                                </div>
                                <div class="card-footer">
                                    <button type="submit" id="submit-button" class="btn btn-primary">Update</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function validate_fileupload(file,fileType)
    {
        var allowed_extensions;
        if(fileType == 'image'){
            allowed_extensions = new Array("jpg","png","jpeg");
        }else{
            allowed_extensions = new Array("pdf");
        }
        var file_extension = file.value.split('.').pop().toLowerCase(); // split function will split the filename by dot(.), and pop function will pop the last element from the array which will give you the extension as well. If there will be no extension then it will return the filename.

        for(var i = 0; i <= allowed_extensions.length; i++)
        {
            if(allowed_extensions[i]==file_extension)
            {
                return true; // valid file extension
            }
        }
        alert('File extension not supported!');
        file.value='';
        $("input[name='file_type']").prop('checked', false);
        $('#show-image').css('display', 'none');
        $('#show-pdf').css('display', 'none');
        return false;
    }

    $(document).ready(function() {
        jQuery.validator.addMethod("customName", function(value, element) {
            // return this.optional(element) || (parseFloat(value) > 0);
            return this.optional(element) || /^[a-z_]+$/.test( value );
        }, "Enter only lowercase alphabets with underscores instead of spaces");
        $('#editForm').validate({
            rules: {
                name: {
                    required: true,
                    customName: true,
                },
                header: {
                    required: true,
                    maxlength: 60,
                },
                footer: {
                    required: true,
                    maxlength: 60,
                },
                message: {
                    required: true,
                    maxlength: 1024,
                }
            },
            messages: {
                name: {
                    required: "Enter only lowercase alphabets with underscores instead of spaces"
                }
            },
            errorPlacement: function(error, element) {
                error.insertAfter(element);
            }
        });
        $("input[name='file_type']").click(function () {
            if($(this).val() === 'image') {
                $('#show-image').css('display', 'block');
                $("#pdf").val('');
                $('#show-pdf').css('display', 'none');
            }

            if($(this).val() === 'pdf') {
                $('#show-pdf').css('display', 'block');
                $("#image").val('');
                $('#show-image').css('display', 'none');
            }

        });
        $("input[name='file_required']").click(function () {
            if($(this).val() === 'yes') {
                $('#show-file-type').css('display', 'block');
                $("#header").val('');
                $('#header').prop('required',false);
                $('#show-header').css('display', 'none');
            }

            if($(this).val() === 'no') {
                $("input[name='file_type']").prop('checked', false);
                $('#show-file-type').css('display', 'none');
                $('#show-pdf').css('display', 'none');
                $('#show-image').css('display', 'none');
                $("#image").val('');
                $("#pdf").val('');
                $("#header").val('');
                $('#header').prop('required',false);
                $('#header').prop('required',true);
                $('#show-header').css('display', 'block');
            }

        });
        // Handle file input change event for dynamically added fields
        $(document).on('change', 'input[type="file"]', function() {
            var fileInput = $(this);
            var descriptionInput = fileInput.closest('.staresd').find('input[name="description[]"]');

            var files = fileInput.prop('files');
            var descriptions = [];

            for (var i = 0; i < files.length; i++) {
                var fileName = files[i].name;
                descriptions.push(fileName);
            }

            descriptionInput.val(descriptions.join(', '));
        });
    });
</script>

@endsection
