@extends('layouts.master')
@section('content')
<style>
img {
    height:auto;
    width: 60px;
object-fit: scale-down;
}
.error {
    color: red;
}
#overlay {
    position: fixed;
    top: 0;
    z-index: 1070;
    width: 100%;
    height: 100%;
    display: none;
    background: rgba(0, 0, 0, 0.6);
}

.cv-spinner {
    height: 100%;
    display: flex;
    justify-content: center;
    align-items: center;
}

.spinner {
    width: 40px;
    height: 40px;
    border: 4px #ddd solid;
    border-top: 4px #2e93e6 solid;
    border-radius: 50%;
    animation: sp-anime 0.8s infinite linear;
}
</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-2">
                    <h1 class="m-0">Template List</h1>
                </div>
                <div class="col-sm-2">
                    <a href="{{route('template.list')}}" style="text-decoration: none;">
                        <button class="btn bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Refresf List" style="color: white;">
                            Refresh List
                        </button>
                    </a>
                </div>
                <div class="col-sm-8">
                <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active">Template</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Template</h3>
                            <div class="card-tools">
                                <a href="{{ route('template.add') }}" class="btn btn-sm btn-primary"><i class="fa fa-plus"></i> Add Template</a>
                            </div>
                        </div>
                        <div class="card-body">
                            {{ $dataTable->table() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- image file Modal -->
<div class="modal fade" id="modalimagefile" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalimagefileTitle">File List</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="table-responsive text-nowrap">
                    <div class="card-tools">
                        <form method="get" action="{{ route('product.addimage') }}" name="form"
                            enctype="multipart/form-data">
                            <button type="submit" class="btn btn-sm btn-primary" style="float: right;">Add More</button>
                            <input type="hidden" name="product_id" id="product_id" class="form-control" value="">
                        </form>
                        <br>
                    </div>
                    <br>
                    <table class="table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>File</th>
                                <th>Description</th>
                                <th></th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0" id="showfilewithimage">
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!--name product Modal -->
<div class="modal fade" id="editnameModal" tabindex="-1" role="dialog" aria-labelledby="editnameModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="editnameModalLabel">Update Product Name</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <form action="{{ route('product.updateName') }}" method="post">
              @csrf
              <input type="hidden" name="id" id="modalId" class="form-control" value="">
              <div class="form-group">
                  <label for="">Name</label>
                  <input type="text" name="name" class="form-control" id="modalname" value="modalname" required>
              </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Update</button>
        </div>
      </form>
      </div>
    </div>
  </div>
  <!-- Send Test Message Modal -->
  <div class="modal fade" id="sendTestMessageModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="sendTestMessageTitle">Test Message</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="sendTestMessage_form" method="POST">
                    @csrf
                    <input type="hidden" id="test_url" data-url="">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="test_number">Whatsapp Number</label><span class="input-danger">*</span>
                                <input type="number" name="test_number" class="form-control" id="test_number"
                                    placeholder="Enter Number" value="" required>
                                <p class="error" id="invalid_number"></p>
                            </div>
                            <div class="col-12">
                                <div class="">
                                    <button type="submit" name="test_btn" id="testBtn"
                                        class="btn btn-primary">Send Test Message</button>
                                </div>
                            </div>
                            <div class="error" id="cf-response-message"></div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<div id="overlay">
    <div class="cv-spinner">
        <span class="spinner"></span>
    </div>
</div>
@push('scripts')
{{ $dataTable->scripts() }}
@endpush

<script>
    $(document).ready(function() {
        let message = "{!! \Session::get('success') !!}";
        if(message){
            swal({
                title: message,
                icon: 'success',
                button: 'OK'
            });
        }
        $("#testBtn").click(function(e) {
            e.preventDefault();
            let test_number = $('#test_number').val();
            if (test_number === '') {
                $('#invalid_number').text("Input Fields can not be Empty!!");
                $('#invalid_number').css("color", "red");
                return false;
            } else {
                $('#invalid_number').text("");
                var url = $('#test_url').data('url');
                $("#overlay").fadeIn(300);
                $.ajax({
                    url: url,
                    type: "GET",
                    data: {
                        number: test_number,
                    },
                    success: function(response) {
                        if (response) {
                            $('#cf-response-message').text(response.message);
                        }
                        setTimeout(function() {
                            $("#overlay").fadeOut(300);
                        }, 500);
                    },
                    error: function(data) {
                        console.log(data);
                        $('#cf-response-message').text(data.responseText);
                        setTimeout(function() {
                            $("#overlay").fadeOut(300);
                        }, 500);
                    }
                });
            }
        });
        $('#sendTestMessageModal').on('hidden.bs.modal', function () {
            $('#sendTestMessageModal form')[0].reset();
            $('#cf-response-message').text(' ');
        });
    });
    function sendTestMessage(elm) {
        // alert('hi');
        $('#test_url').data("url",$(elm).data('url'));
        $("#sendTestMessageModal").modal('show');
    }
    function showfilewithimage(elm) {
        var product_id = $(elm).attr('data-id');
        $.ajax({
            url: "{{ url('ajax/get_imagefile') }}",
            type: "GET",
            data: {
                product_id: product_id,
            },
            success: function(response) {
                if (response) {
                    $("#showfilewithimage").html('');
                    $.each(response['data'], function(i, item) {
                        var url = '{{route("product.editimage", "file_id=:id")}}';
                        url = url.replace(':id', item.id);

                        var url_file = '{{route("product.filedestroy", "fileid=:id")}}';
                        url_file = url_file.replace(':id', item.id);

                        var imageName = item.image.split('/').pop();
                        var imageNameX = item.image.split('.').pop();
                        var html = `<tr>
                            <td><strong>${item['id']}</strong></td>
                            <td>
                                <a href="${item['image']}" target="_blank" style="text-decoration: none;">
                                    ${imageNameX === 'pdf' ? `<i class="far fa-file-pdf pdf-icon fa-2x" style="color:red;"></i> ${imageName}` : `<img src="${item['image']}" alt="" class="img">`}
                                </a>
                            </td>
                            <td>${item['description']}</td>
                            
                            <td>
                                <a data-toggle="modal" data-target="#deletePopupfile" data-url="${url_file}" onclick="deletePopupfile(this)">
                                    <button class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="right" title="Delete ">
                                        <i class="fas fa-trash" aria-hidden="true"></i>
                                    </button>
                                </a>
                            </td>
                        </tr>`;
                        $('#product_id').val(product_id);
                        $("#showfilewithimage").append(html);
                        $("#modalimagefile").modal('show');
                    });
                } else {
                    $("#showfilewithimage").html('');
                    $('#product_id').val(product_id);
                    $("#modalimagefile").modal('show');
                    // alert('no data found!')
                }
            },
            error: function(error) {
                console.log(error);
            }
        });
    }
    function deletePopupfile(elm) {
        let id = $(elm).data('id');
        let url = $(elm).data('url');
        swal({
            title: 'Are you sure!',
            icon: 'error',
            dangerMode: true,
            buttons: true,
            confirm: "Confirm",
        }).then(function(isConfirm) {
            if (isConfirm === true) {
                $.ajax({
                    type: 'GET',
                    url: url,
                    dataType: 'json',
                    success: function(data) {
                        window.location.reload();
                        // console.log(data);
                    },
                    error: function(data) {
                        console.log(data);
                    }
                });
            }
        });
    }
    function editname(id) {
        $('#modalname').val($('.btn-'+id).data('name'));
        $('#modalId').val(id);
        $('#editnameModal').modal('show');
    }
    function updateDefaultStatus(elm) {
        let id = $(elm).data('id');
        let url = $(elm).data('url');
        let checkedValue = $(elm).prop('checked');
        swal({
            title: 'Are you sure!',
            icon: 'warning',
            buttons: true,
            confirm: "Confirm",
        }).then(function(isConfirm) {
            if (isConfirm === true) {
                $.ajax({
                    type: 'GET',
                    url: url,
                    data: {'checkedValue':checkedValue},
                    dataType: 'json',
                    success: function(data) {
                        window.location.reload();
                        // console.log(data);
                    },
                    error: function(data) {
                        console.log(data);
                    }
                });
            }else{
                $("input[type=checkbox]").each(function () {
                    $(this).prop("checked", false);
                });
            }
        });
    }
    function sendApprovalFunction(elm) {
        let url = $(elm).data('url');
        swal({
            title: 'Are you sure!',
            icon: 'warning',
            buttons: true,
            confirm: "Confirm",
        }).then(function(isConfirm) {
            if (isConfirm === true) {
                $("#overlay").fadeIn(300);
                $.ajax({
                    type: 'GET',
                    url: url,
                    dataType: 'json',
                    success: function(data) {
                        setTimeout(function() {
                            $("#overlay").fadeOut(300);
                        }, 500);
                        window.location.href = "{{ route('template.list')}}";
                        // window.location.reload();
                        // console.log(data);
                    },
                    error: function(data) {
                        console.log(data);
                    }
                });
            }
        });
    }
</script>
@endsection
