@extends('layouts.master')
@section('content')
<style>
    #category-names-container input {
        margin-bottom: 10px;
        /* Add margin at the bottom of each input field */
    }

    #modal-category-names-container input {
        margin-bottom: 10px;
        /* Add margin at the bottom of each input field */
    }

    .error {
        color: red;
    }

    .password-wrapper {
        position: relative;
        display: flex;
        align-items: center;
        /* Center align items vertically */
        height: 2.5em;
        /* Adjust based on your input field height */
    }

    .password-toggle {
        position: absolute;
        right: 10px;
        cursor: pointer;
        font-size: 1.2em;
        z-index: 1;
        /* Ensure it's on top of other elements */
    }

    input.form-control {
        padding-right: 40px;
        /* Add padding to ensure text does not overlap with the icon */
    }
    #overlay {
        position: fixed;
        top: 0;
        z-index: 1070;
        width: 100%;
        height: 100%;
        display: none;
        background: rgba(0, 0, 0, 0.6);
    }

    .cv-spinner {
        height: 100%;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .spinner {
        width: 40px;
        height: 40px;
        border: 4px #ddd solid;
        border-top: 4px #2e93e6 solid;
        border-radius: 50%;
        animation: sp-anime 0.8s infinite linear;
    }
</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Attendances List</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active">Attendances List</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="card-body">
                <form method="get" id="myform" name="myform" action="{{ route('user_attendance.list') }}" enctype="multipart/form-data">
                    <div class="form-group row">
                        <div class="col-2">
                            <label for="">Select Team Member</label>
                            <select class="form-control custom-select" name="teammember_id" id="teammember_id">
                                <option value="all" @if ($teammember_id == 'all') selected @endif>All
                                </option>
                                @foreach ($userdata as $val)
                                    <option value="{{ $val->CustomerID }}"
                                        @if ($teammember_id == $val->CustomerID) selected @endif>
                                        {{ $val->CustomerName }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        
                        <div class="col-2">
                            <label for="">Select Year</label>
                            <select class="form-control custom-select" name="year" id="year">
                                <option value="all" @if ($year == 'all') selected @endif>All
                                </option>
                                <?php
                                $current  = date("Y");
                                    for ($j=2025; $j <= $current; $j++) { 
                                ?>
                                    <option value="{{ $j }}" @if ($year == $j) selected @endif>
                                        {{ $j }}
                                    </option>
                                <?php
                                    }
                                ?>
                            </select>
                        </div>
                        <div class="col-2">
                            <label for="">Select Month</label>
                            <select class="form-control custom-select" name="month" id="month">
                                <option value="all" @if ($month == 'all') selected @endif>All
                                </option>
                                <option value="1" @if($month==1) selected @endif>Jan</option>
                                <option value="2" @if($month==2) selected @endif>Feb</option>
                                <option value="3" @if($month==3) selected @endif>Mar</option>
                                <option value="4" @if($month==4) selected @endif>Apr</option>
                                <option value="5" @if($month==5) selected @endif>May</option>
                                <option value="6" @if($month==6) selected @endif>Jun</option>
                                <option value="7" @if($month==7) selected @endif>Jul</option>
                                <option value="8" @if($month==8) selected @endif>Aug</option>
                                <option value="9" @if($month==9) selected @endif>Sep</option>
                                <option value="10" @if($month==10) selected @endif>Oct</option>
                                <option value="11" @if($month==11) selected @endif>Nov</option>
                                <option value="12" @if($month==12) selected @endif>Dec</option>

                            </select>
                        </div>
                        <div class="col-2">
                            <div class="mt-4">
                                <button type="submit" class="btn btn-2 bg-gradient-info btn-1"
                                style="color:white;">Submit</button>
                            </div>
                        </div>
                        @if ($teammember_id != 'all')
                        <div class="col-4">
                            <div class="mt-4">
                                <h4>Total Attendance : {{ $attendance?->total_days_present ? $attendance->total_days_present : 0 }} Days</h4>
                            </div>
                        </div>
                        @endif
                    </div>
                    
                </form>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Attendances</h3>   
                            <div >
                            <a class="ml-2" target="_blank" href="{{ route('user_attendance.liveuserattendance') }}">View On Map</a>    
                            </div>                     
                        </div>
                        <div class="card-body table-responsive">
                            <form method="post" name="frm_no_kids" id="frm_no_kids" class="getstarted"
                                    action="{{ route('user_attendance.exportuserattendance') }}">
                                    @csrf
                                    <input type="hidden" id="teammember_id" name="teammember_id"
                                        value="{{ $teammember_id }}">
                                    <input type="hidden" id="month" name="month"
                                        value="{{ $month }}">
                                    <input type="hidden" id="year" name="year"
                                        value="{{ $year }}">
                                    <input type="submit" id="submit_export" name="submit_export" style="display:none;">
                                    <button class="btn btn-2 bg-gradient-info btn-1" data-toggle="tooltip" data-placement="left" title="Export" style="color:white">
                                        <i class="bx bxs-edit" aria-hidden="true"></i>Export
                                    </button>
                                </form>

                            {{ $dataTable->table() }}
                        </div>
                    </div>
                </div>
                <!-- <div class="col-4" style="margin-top: -100px;">
                    <img style="width: 800px;height:800px;" src="https://frenzinsoftwares.com/frenzincrm_help/category.gif" alt="category.gif">

                </div> -->
            </div>
        </div>
    </div>
</div>

<!-- Add Category Modal -->
<div class="modal fade" id="addCategoryModal" tabindex="-1" role="dialog" aria-labelledby="addCategoryModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content" id="addCategoryContent">
            <div class="modal-header">
                <h5 class="modal-title" id="addCategoryModalLabel">Add Category</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="{{ route('category.store') }}" method="POST" id="addCategoryForm">
                    <input type="hidden" name="action" value="insert">
                    @csrf
                    <div class="form-group" id="category-names-container">
                        <label for="">Category Name</label>
                        <input type="text" class="form-control" id="category-name-1"
                            placeholder="Enter Category Name"
                            name="name[]"
                            value="{{ old('name') }}" required>

                        @if($errors->has('name'))
                            <div class="form-text text-danger">{{ $errors->first('name') }}</div>
                        @endif
                    </div>

                    <div class="card-footer">
                        <div class="col-md-4 mt-30 append-buttons float-right">
                            <div class="clearfix">
                                <button type="button" id="add-button" class="btn btn-success float-left text-uppercase shadow-sm">
                                    <i class="fa fa-plus fa-fw"></i>Add
                                </button>
                                <button type="button" id="remove-button" class="btn btn-danger float-left text-uppercase ml-1" disabled>
                                    <i class="fa fa-minus fa-fw"></i>Remove
                                </button>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Add</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Edit Category Modal -->
<div class="modal fade" id="editCategoryModal" tabindex="-1" role="dialog" aria-labelledby="editCategoryModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content" id="editCategoryContent">
        </div>
    </div>
</div>

<!-- SubCategory Modal -->
<div class="modal fade" id="subCategoryModal" tabindex="-1" role="dialog" aria-labelledby="subCategoryModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content" id="subCategoryContent">
        </div>
    </div>
</div>

<div id="overlay">
    <div class="cv-spinner">
        <span class="spinner"></span>
    </div>
</div>

@push('scripts')
{{ $dataTable->scripts() }}
@endpush
@endsection