@extends('layouts.master')
@section('content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<style>
    #category-names-container input {
        margin-bottom: 10px;
        /* Add margin at the bottom of each input field */
    }

    #modal-category-names-container input {
        margin-bottom: 10px;
        /* Add margin at the bottom of each input field */
    }

    .error {
        color: red;
    }

    .password-wrapper {
        position: relative;
        display: flex;
        align-items: center;
        /* Center align items vertically */
        height: 2.5em;
        /* Adjust based on your input field height */
    }

    .password-toggle {
        position: absolute;
        right: 10px;
        cursor: pointer;
        font-size: 1.2em;
        z-index: 1;
        /* Ensure it's on top of other elements */
    }

    input.form-control {
        padding-right: 40px;
        /* Add padding to ensure text does not overlap with the icon */
    }

    #overlay {
        position: fixed;
        top: 0;
        z-index: 1070;
        width: 100%;
        height: 100%;
        display: none;
        background: rgba(0, 0, 0, 0.6);
    }

    .cv-spinner {
        height: 100%;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .spinner {
        width: 40px;
        height: 40px;
        border: 4px #ddd solid;
        border-top: 4px #2e93e6 solid;
        border-radius: 50%;
        animation: sp-anime 0.8s infinite linear;
    }

    #empList {
        max-height: 60vh;
        overflow-y: auto;
        padding-right: 5px;
    }

    .emp-card {
        background-color: #fdfdfd;
        border: 1px solid #e0e0e0;
        border-left: 4px solid transparent;
        transition: all 0.2s ease-in-out;
        box-shadow: 0 1px 2px rgba(0, 0, 0, 0.05);
    }

    .emp-card:hover {
        background-color: #f8f9fa;
    }

    .selected-card {
        background-color: #e9f5ff;
        border-left: 4px solid #0d6efd;
        box-shadow: 0 2px 4px rgba(13, 110, 253, 0.2);
    }
    @keyframes sp-anime {
    0% {
        transform: rotate(0deg);
    }
    100% {
        transform: rotate(360deg);
    }
}
</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Team Member Location</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active">Team Member Location</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="card-body">

            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Team Member Location</h3>
                            <div class="">
                                <input class="col-md-2" style="margin-left:3%;" type="date" name="selectdate"
                                    id="selectdate" value="{{ $selectdate ?? date('Y-m-d') }}"
                                    onchange="loadDataByDate()">

                                <button type="button" class="btn rounded-pill btn-icon btn-primary"
                                    style="float: right;margin: 0px 15px 5px 0px" id="refreshBtn" onclick="reloadMap()">

                                    <span class="submit-text"><i class="fa-solid fa-arrows-rotate"></i></span>
                                    <div class="spinner-border text-light submit-loader" role="status" style="width:23px;height:23px;display:none;">
                                        <span class="visually-hidden"></span>
                                    </div>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-9 col-sm-6">
                                    <div id="googleMap" style="width:100%;height:64vh;"></div>
                                </div>
                                <div class="col-md-3 col-sm-6">
                                    <div class="card mb-4">
                                        <h5 class="card-header"><b>Team Member</b></h5>
                                        <hr class="my-0" />
                                        <div class="card-body" id="empList">

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>



<div id="overlay">
    <div class="cv-spinner">
        <span class="spinner"></span>
    </div>
</div>

@push('scripts')
<script>
   function setLoader(show = true) {
    if (show) {
        $('#overlay').fadeIn(150);
    } else {
        $('#overlay').fadeOut(150);
    }
}
    let map;
    let markers = [];
    let gmarkers = [];
    let flightPath = [];
    let markerCluster;
    let infowindow = new google.maps.InfoWindow();

$(document).ajaxStart(function () {
    setLoader(true);
});

$(document).ajaxStop(function () {
    setLoader(false);
});

    function setGoogleMap() {
        const defaultCenter = {
            lat: 22.9540961,
            lng: 79.3824058
        };
        infowindow = new google.maps.InfoWindow();
        map = new google.maps.Map(document.getElementById("googleMap"), {
            zoom: 3,
            center: defaultCenter,
            mapTypeId: google.maps.MapTypeId.ROADMAP,
            scrollwheel: true,
        });

        // Example trigger (optional)
        loadDataByDate();

    }
    setGoogleMap();

    function loadDataByDate() {
        const Url = "{{route('user_attendance.fetchAllEmployees')}}"
        if ((Url !== undefined && Url !== null)) {


            $.ajax({
                type: "GET",
                url: Url,
                data: {
                    date: $("#selectdate").val()
                },
                success: function(response) {

                    // console.log(response.data);
                    addSideBarList(response.data, "loadDataByDate");


                },
                error: function(xhr) {
                    // var error = xhr.responseJSON;
                    console.log(xhr);
                    swal('Error!', "Some thing went wrong",
                        'error');


                }
            });
        }
    }

    function changeDateFormat(isoString) {
        const date = new Date(isoString);

        // Check if the date is valid
        if (isNaN(date.getTime())) {
            return null;
        }

        const hours = date.getUTCHours().toString().padStart(2, '0');
        const minutes = date.getUTCMinutes().toString().padStart(2, '0');
        const seconds = date.getUTCSeconds().toString().padStart(2, '0');

        return `${hours}:${minutes}:${seconds}`;
    }

    function addSideBarList(data, type) {
        removeMarkers();

        $("#empList").html("");
        const displayIds = [];


        data.forEach((item, i) => {
            const CheckInlat = parseFloat(item.checkin_lat);
            const CheckInlng = parseFloat(item.checkin_lng);
            const CheckOutlat = parseFloat(item.checkout_lat);
            const CheckOutlng = parseFloat(item.checkout_lng);
            const CheckInTime = changeDateFormat(item.check_in_time)
            const CheckOutTime = changeDateFormat(item.check_out_time)
            const CustomerName = item.CustomerName;
            const id = item.id;

            const checkOutHTML = CheckOutTime ?
                `<div>
        <i class="fa-solid fa-arrow-right-from-bracket me-1 text-danger"></i> ${CheckOutTime}
    </div>` :
                ''; // If no check-out time, return an empty string

            const content = `
    <div class="emp-card shadow-sm rounded p-2 mb-3" data-id="${id}" data-CheckInlat="${CheckInlat}" data-CheckInlng="${CheckInlng}" data-CheckInTime="${CheckInTime}" data-CheckOutTime="${CheckOutTime}" data-CustomerName="${CustomerName}" data-CheckOutlat="${CheckOutlat}" data-CheckOutlng="${CheckOutlng}" style="cursor: pointer; transition: all 0.2s ease;">
        <div class="fw-semibold text-dark mb-1 d-flex align-items-center" style="font-size: 15px;">
            <i class="fa-solid fa-user me-2 text-primary"></i> ${CustomerName}
        </div>
        <div class="d-flex justify-content-between small text-muted px-1">
            <div>
                <i class="fa-solid fa-arrow-right-to-bracket me-1 text-success"></i> ${CheckInTime}
            </div>
            ${checkOutHTML}
        </div>
    </div>
`;
            $("#empList").append(content);
            // const marker = new google.maps.Marker({
            //     position: {
            //         lat,
            //         lng
            //     },
            //     map,
            // });

            // marker.addListener("click", () => {
            //     const content = ``;
            //     infowindow.setContent(content);
            //     infowindow.open(map, marker);
            // });

            // markers.push(marker);

        });

        console.log(displayIds);
        // if (displayIds.length > 0 && lastLat && lastLng) {
        //     zoomMapOnVisitor(lastLat, lastLng);

        //     // markerCluster = new markerClusterer.MarkerClusterer({ map, markers });
        // }

        // document.querySelector(".total-location").textContent = `- ${displayIds.length} location found`;
    }

    function zoomMapOnVisitor(lat, lng) {
        map.setCenter({
            lat: parseFloat(lat),
            lng: parseFloat(lng)
        });
        map.setZoom(10);
    }




    function removeMarkers() {
        if (flightPath.length) {
            flightPath.forEach(path => path.setMap(null));
            flightPath = [];
        }

        markers.forEach(marker => marker.setMap(null));
        gmarkers.forEach(marker => marker.setMap(null));

        markers = [];
        gmarkers = [];

        if (markerCluster) {
            markerCluster.clearMarkers();
        }
    }

    function reloadMap() {
        // setLoader($("#refreshBtn"),true);
        setGoogleMap();
        // setLoader($("#refreshBtn"),false);

    }
    $(document).ready(function() {
        $(document).on('click', '.emp-card', function() {
            removeMarkers();
            const id = $(this).data('id');
            const CheckInlat = parseFloat($(this).data('checkinlat'));
            const CheckInlng = parseFloat($(this).data('checkinlng'));
            const CheckOutlat = parseFloat($(this).data('checkoutlat'));
            const CheckOutlng = parseFloat($(this).data('checkoutlng'));
            const CheckInTime = $(this).data('checkintime')
            const CheckOutTime = $(this).data('checkouttime')
            const CustomerName = $(this).data('customername');

            let LastLat = null;
            let LastLng = null;
            console.log($(this).data());
            if (CheckInlat && CheckInlng && CheckInlat != 0.0 && CheckInlng != 0.0) {
                LastLat = CheckInlat;
                LastLng = CheckInlng;
                 marker = new google.maps.Marker({
        position: {
            lat: CheckInlat,
            lng: CheckInlng
        },
        map,
        icon: 'http://maps.google.com/mapfiles/ms/icons/green-dot.png',
        title: `${CustomerName} - Check-In`
    });

                marker.addListener("click", () => {
                     const content = `
        <div style="font-family:'Segoe UI', sans-serif; font-size: 13px; min-width: 240px; padding: 10px; border-radius: 8px; box-shadow: 0 2px 6px rgba(0,0,0,0.1); background: #e9fbee;">
            <div style="display: flex; align-items: center; margin-bottom: 8px;">
                <i class="fa-solid fa-user text-success" style="margin-right: 8px;"></i>
                <strong style="font-size: 15px;">${CustomerName}</strong>
            </div>
            <hr style="margin: 5px 0;">
            <div style="display: flex; align-items: center; color: #198754;">
                <i class="fa-solid fa-arrow-right-to-bracket me-2"></i>
                <span><strong>Check-In:</strong> ${CheckInTime}</span>
            </div>
        </div>
    `;

                    infowindow.setContent(content);
                    infowindow.open(map, marker);
                });

                markers.push(marker);
            }
            if (CheckOutlat && CheckOutlng && CheckOutlat != 0.0 && CheckOutlng != 0.0) {
                LastLat = CheckOutlat;
                LastLng = CheckOutlng;

               marker2 = new google.maps.Marker({
        position: {
            lat: CheckOutlat,
            lng: CheckOutlng
        },
        map,
        icon: 'http://maps.google.com/mapfiles/ms/icons/red-dot.png',
        title: `${CustomerName} - Check-Out`
    });

                marker2.addListener("click", () => {
                 const content = `
        <div style="font-family:'Segoe UI', sans-serif; font-size: 13px; min-width: 240px; padding: 10px; border-radius: 8px; box-shadow: 0 2px 6px rgba(0,0,0,0.1); background: #fdeeee;">
            <div style="display: flex; align-items: center; margin-bottom: 8px;">
                <i class="fa-solid fa-user text-danger" style="margin-right: 8px;"></i>
                <strong style="font-size: 15px;">${CustomerName}</strong>
            </div>
            <hr style="margin: 5px 0;">
            <div style="display: flex; align-items: center; color: #dc3545;">
                <i class="fa-solid fa-arrow-right-from-bracket me-2"></i>
                <span><strong>Check-Out:</strong> ${CheckOutTime}</span>
            </div>
        </div>
    `;
                    infowindow.setContent(content);
                    infowindow.open(map, marker2);
                });

                markers.push(marker2);
            }
           
            if(LastLat && LastLng){
                zoomMapOnVisitor(LastLat,LastLng);
            }
            // Optional: highlight selected card
            $('.emp-card').removeClass('selected-card');
            $(this).addClass('selected-card');

            // Do something like centering map, showing details, etc.
        });
    })
</script>


        @endpush
        @endsection