@extends('layouts.master')
@section('content')
    <style>
        .card-header {
            background-color: #007bff;
            color: #fff;
        }

        .input-danger {
            color: red;
            font-weight: 700;
        }

        .error {
            color: red;
            /* font-weight: 700; */
        }

        .card-title {
            float: left;
            font-size: 1.1rem;
            font-weight: 400;
            margin: 0;
        }

        /* Custom styling for radio buttons */
        .form-check-input {
            width: 1.5em;
            /* Increase size */
            height: 1.5em;
            /* Increase size */
            margin-right: 0.5em;
            /* Add space between radio and label */
        }

        .form-check-label {
            font-size: 1.1em;
            /* Make label text larger */
            display: flex;
            align-items: center;
            cursor: pointer;
            /* Change cursor to pointer on hover */
        }

        /* Optional: Add a border and background to radio button on focus */
        .form-check-input:focus {
            border-color: #007bff;
            /* Change border color on focus */
            outline: none;
            /* Remove default outline */
        }

        /* Add some margin to space out radio button options */
        .form-check {
            margin-bottom: 1em;
            /* Adjust spacing as needed */
        }

        #overlay {
            position: fixed;
            top: 0;
            z-index: 1070;
            width: 100%;
            height: 100%;
            display: none;
            background: rgba(0, 0, 0, 0.6);
        }

        .cv-spinner {
            height: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .spinner {
            width: 40px;
            height: 40px;
            border: 4px #ddd solid;
            border-top: 4px #2e93e6 solid;
            border-radius: 50%;
            animation: sp-anime 0.8s infinite linear;
        }

        @keyframes sp-anime {
            100% {
                transform: rotate(360deg);
            }
        }

        .is-hide {
            display: none;
        }
    </style>
    <style>
        .cke_button__customimageupload_icon {
            background-image: url('{{ asset('assets/images/dashboard_icons/file.png') }}');
            background-size: cover;
            width: 16px;
            height: 16px;
            border: none;
            display: inline-block;
        }

        /* Container for radio buttons and labels */
        .radio-group {
            display: flex;
            align-items: center;
            gap: 10px;
            /* Space between radio buttons and labels */
        }

        /* Style for individual radio buttons */
        .radio-large {
            transform: scale(1.5);
            /* Adjust size here (1.5 means 150%) */
            margin-right: 5px;
            /* Space between radio button and label */
        }

        /* Optional: Adjust label for better alignment */
        .radio-label {
            display: inline-block;
            vertical-align: middle;
            /* Align label with radio button */
        }
        #cke_notifications_area_content{
            display: none !important;
        }
        .ck-editor__editable {
            min-height: 200px !important;
        }
    </style>
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6" style="color:black">
                        <!-- <h1 class="m-0">Send Email</h1> -->
                         <h4> Name  :  {{ $users->CustomerName ?? '' }}</h4>
                         <h4> Email  :  {{ $users->Email ?? '' }}</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('users.list') }}">Team Member List</a></li>
                            <li class="breadcrumb-item active">Send Email</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content">
            <div class="container-fluid">
                <form id="emailDetailsForm" method="post" action="{{ route('users.store_email_admin') }}">
                    @csrf
                    {{-- <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">EMAIL CONFIGURATION
                                    </h3>
                                    <div class="card-tools">
                                        <button type="button" class="btn btn-tool" data-card-widget="collapse"
                                            title="Collapse">
                                            <i class="fas fa-minus"></i>
                                        </button>
                                    </div>
                                </div>

                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-12">
                                            <input type='hidden' name="id" value="{{ $CustomerID }}">
                                            <div class="form-group">
                                                <label for="">Sender Name</label><span class="input-danger">*</span>
                                                <input type="text" name="sender_name" class="form-control" id=""
                                                    placeholder="Enter Sender Name"
                                                    value="{{ isset($users->sender_name) ? $users->sender_name : '' }}"
                                                    required>
                                            </div>
                                            <div class="form-group">
                                                <label for="">Sender Email</label><span
                                                    class="input-danger">*</span>
                                                <input type="text" name="sender_email" class="form-control"
                                                    id="sender_email" placeholder="Enter Sender Email"
                                                    value="{{ isset($users->sender_email) ? $users->sender_email : '' }}"
                                                    required>
                                            </div>
                                            <div class="form-group">
                                                <label for="">CC Email</label><span class=""> ( Optional
                                                    )</span>
                                                <input type="text" name="cc_email" class="form-control" id=""
                                                    placeholder="Enter CC Email"
                                                    value="{{ isset($users->cc_email) ? $users->cc_email : '' }}">
                                            </div>
                                            <div class="form-group">
                                                <label for="">BCC Email</label><span class=""> ( Optional
                                                    )</span>
                                                <input type="text" name="bcc_email" class="form-control" id=""
                                                    placeholder="Enter BCC Email"
                                                    value="{{ isset($users->bcc_email) ? $users->bcc_email : '' }}">
                                            </div>
                                        </div>
                                    </div>

                                </div>

                            </div>
                        </div>
                    </div> --}}
                    <div class="row mt-2">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">SELECT DEFAULT EMAIL
                                    </h3>
                                    <span style="color: yellow" >   &nbsp;( Note : Default Mail will go to Client when New Client is Added From the Mobile App )</span>
                                    <div class="card-tools">
                                        <a target="_blank" style="color: white; text-decoration: none;" href="{{route('emails.create')}}"><span>Create New Draft</span></a>
                                        <button type="button" class="btn btn-tool" data-card-widget="collapse"
                                            title="Collapse">
                                            <i class="fas fa-minus"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="col">
                                                @if (isset($primary_emails) && !empty($primary_emails))
                                                    @foreach ($primary_emails as $key => $p_email)
                                                        @if (isset($p_email->email_type) && $p_email->email_type == 'primary')
                                                            <div class="row" style="margin-top:0.5rem;">
                                                                @if ($users->primary_email)
                                                                    <input class="col-lg-1" type="radio"
                                                                        {{ $users->primary_email == $p_email->id ? 'checked' : '' }}
                                                                        value="{{ $p_email->id }}" name="primary_email"
                                                                        id="primary_email_{{ $key + 1 }}"><span
                                                                        class="col">{{ $p_email->subject }}</span>
                                                                @else
                                                                    <input class="col-lg-1" type="radio"
                                                                        {{ $key == 0 ? 'checked' : '' }}
                                                                        value="{{ $p_email->id }}" name="primary_email"
                                                                        id="primary_email_{{ $key + 1 }}"><span
                                                                        class="col">{{ $p_email->subject }}</span>
                                                                @endif

                                                            </div>
                                                        @endif
                                                    @endforeach
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-2">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">EMAIL CONFIGURATION</h3>
                                    <div class="card-tools">

                                        <button type="button" class="btn btn-tool" data-card-widget="collapse"
                                            title="Collapse">
                                            <i class="fas fa-minus"></i>

                                        </button>
                                    </div>
                                </div>

                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-6">
                                            <input type='hidden' name="id" value="{{ $CustomerID }}">
                                            <div class="form-group">
                                                <label for="">Sender Name</label><span class="input-danger">*</span>
                                                <input type="text" name="sender_name" class="form-control" id=""
                                                    placeholder="Enter Sender Name"
                                                    value="{{ isset($users->sender_name) ? $users->sender_name : '' }}"
                                                    required>
                                            </div>
                                            <div class="form-group">
                                                <label for="">CC Email</label><span class=""> ( Optional
                                                    )</span>
                                                <input type="text" name="cc_email" class="form-control" id=""
                                                    placeholder="Enter CC Email"
                                                    value="{{ isset($users->cc_email) ? $users->cc_email : '' }}">
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-group">
                                                <label for="">Sender Email</label><span
                                                    class="input-danger">*</span>
                                                <input type="text" name="sender_email" class="form-control"
                                                    id="sender_email" placeholder="Enter Sender Email"
                                                    value="{{ isset($users->sender_email) ? $users->sender_email : '' }}"
                                                    required>
                                            </div>
                                            <div class="form-group">
                                                <label for="">BCC Email</label><span class=""> ( Optional
                                                    )</span>
                                                <input type="text" name="bcc_email" class="form-control" id=""
                                                    placeholder="Enter BCC Email"
                                                    value="{{ isset($users->bcc_email) ? $users->bcc_email : '' }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row mt-4">
                                        <div class="col-sm-6">
                                            <div class="form-group d-flex">
                                                <div class="form-check ml-2">
                                                    <div>
                                                        <input @if(isset($user_emailconfig->host) && $user_emailconfig->host == 'smtp.gmail.com') checked @endif class="form-check-input smtpOptions" value="Gsuit" type="radio" id="SmtpGsuit"
                                                            name="smtpOption">
                                                        <label class="form-check-label"
                                                            style="margin-left: 10px;margin-top: 2px;"
                                                            for="defaultSmtp">Gsuit ( <a target="_blank" href="https://knowledge.workspace.google.com/kb/how-to-create-app-passwords-000009237">&nbsp;Create App password for Email&nbsp;</a> )</label>
                                                    </div>
                                                </div>
                                                <div class="form-check ml-3">
                                                    <input @if(isset($user_emailconfig->host) && $user_emailconfig->host == 'smtp.office365.com') checked @endif class="form-check-input smtpOptions" value="Office365" type="radio" id="SmtpOffice"
                                                        name="smtpOption" >
                                                    <label class="form-check-label"
                                                        style="margin-left: 10px;margin-top: 2px;" for="customSmtp">
                                                       Office 365</label>

                                                </div>
                                                <div class="form-check ml-3">
                                                    <input class="form-check-input smtpOptions" value="Godaddy" type="radio" id="SmtpGodaddy" name="smtpOption" @if(isset($user_emailconfig->host) && $user_emailconfig->host == 'smtpout.secureserver.net') checked @endif >
                                                    <label class="form-check-label"
                                                        style="margin-left: 10px;margin-top: 2px;" for="customSmtp">
                                                        Godaddy</label>
                                                </div>
                                                <div class="form-check ml-3">
                                                    <input class="form-check-input smtpOptions" value="Hostinger" type="radio" id="SmtpHostinger" name="smtpOption" @if(isset($user_emailconfig->host) && $user_emailconfig->host == 'smtp.hostinger.com') checked @endif >
                                                    <label class="form-check-label"
                                                        style="margin-left: 10px;margin-top: 2px;" for="customSmtp">
                                                        Hostinger</label>
                                                </div>
                                                <div class="form-check ml-3">
                                                    <input class="form-check-input smtpOptions" value="ZOHO" type="radio" id="SmtpZOHO" name="smtpOption" @if(isset($user_emailconfig->host) && $user_emailconfig->host == 'smtp.zoho.com') checked @endif >
                                                    <label class="form-check-label"
                                                        style="margin-left: 10px;margin-top: 2px;" for="customSmtp">
                                                        ZOHO</label>
                                                </div>
                                                <div class="form-check ml-3">
                                                    <input class="form-check-input smtpOptions" value="Other" type="radio" id="SmtpOther"
                                                        name="smtpOption" @if(empty($user_emailconfig->host) ||  $user_emailconfig->host != 'smtp.gmail.com' &&  $user_emailconfig->host != 'smtp.office365.com' &&  $user_emailconfig->host != 'smtpout.secureserver.net' &&  $user_emailconfig->host != 'smtp.hostinger.com' &&  $user_emailconfig->host != 'smtp.zoho.com') checked @endif>
                                                    <label class="form-check-label"
                                                        style="margin-left: 10px;margin-top: 2px;" for="customSmtp">
                                                        Other</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="smtpDetailsCard">
                                        <div class="row">
                                            <div class="col-6">
                                                <br>
                                                <div class="form-group">
                                                    <label for="">SMTP Transport</label><span
                                                        class="input-danger">*</span>
                                                    <input type="text" id="smtp_transport" name="smtp_transport"
                                                        class="form-control required" placeholder="SMTP"
                                                        value="{{ isset($user_emailconfig->smtp_transport) ? $user_emailconfig->smtp_transport : 'smtp' }}">
                                                </div>
                                                <div class="form-group">
                                                    <label for="">Host</label><span class="input-danger">*</span>
                                                    <input type="text" id="smtp_host" name="host" class="form-control required"
                                                        placeholder="Enter Host"
                                                        value="{{ isset($user_emailconfig->host) ? $user_emailconfig->host : '' }}">
                                                </div>
                                                <div class="form-group" id="smtp_port_div">
                                                    <label for="smtp_port">Port</label><span class="input-danger">*</span>
                                                    <select id="smtp_port" name="port_select" class="form-control required">
                                                        <option value="465" {{ isset($user_emailconfig->port) && $user_emailconfig->port == '465' ? 'selected' : '' }}>465</option>
                                                        <option value="587" {{ isset($user_emailconfig->port) && $user_emailconfig->port == '587' ? 'selected' : '' }}>587</option>
                                                        <option value="other" {{ isset($user_emailconfig->port) && $user_emailconfig->port != '465' && $user_emailconfig->port != '587' ? 'selected' : '' }}>Other</option>
                                                    </select>
                                                </div>

                                                <div class="form-group" id="other_port_input_container" style="display: {{ isset($user_emailconfig->port) && $user_emailconfig->port != '465' && $user_emailconfig->port != '587' ? 'block' : 'none' }}">
                                                    <label for="smtp_port_other">Specify Port</label>
                                                    <input type="text" id="smtp_port_other" name="port_other" class="form-control" placeholder="Enter Port" value="{{ isset($user_emailconfig->port) && $user_emailconfig->port != '465' && $user_emailconfig->port != '587' ? $user_emailconfig->port : '' }}">
                                                </div>
                                                <input type="hidden" name="port" id="hidden_port" value="{{ isset($user_emailconfig->port) ? $user_emailconfig->port : '' }}">
                                            </div>
                                            <div class="col-6">
                                                <br>
                                                <div class="form-group">
                                                    <label for="">User Name</label><span
                                                        class="input-danger">*</span>
                                                    <input type="text" id="smtp_user_name"  name="username" class="form-control required"
                                                        placeholder="Enter User Name"
                                                        value="{{ isset($user_emailconfig->username) ? $user_emailconfig->username : $users->sender_email ?? '' }}">
                                                </div>
                                                <div class="form-group">
                                                    <label for="">Password</label><span
                                                        class="input-danger">*</span>
                                                    <input type="password" id="smtp_password" name="password" class="form-control required"
                                                        placeholder="Enter Password"
                                                        value="{{ isset($user_emailconfig->password) ? $user_emailconfig->password : '' }}">
                                                </div>

                                                <div class="form-group">
                                                    <label for="smtp_encryption">SMTP Encryption</label><span class="input-danger">*</span>
                                                    <select id="smtp_encryption" name="encryption_select" class="form-control required">
                                                        <option value="tls" {{ isset($user_emailconfig->smtp_encryption) && $user_emailconfig->smtp_encryption == 'tls' ? 'selected' : '' }}>tls</option>
                                                        <option value="ssl" {{ isset($user_emailconfig->smtp_encryption) && $user_emailconfig->smtp_encryption == 'ssl' ? 'selected' : '' }}>ssl</option>
                                                        <option value="starttls" {{ isset($user_emailconfig->smtp_encryption) && $user_emailconfig->smtp_encryption == 'starttls' ? 'selected' : '' }}>starttls</option>
                                                        <option value="other" {{ isset($user_emailconfig->smtp_encryption) && !in_array($user_emailconfig->smtp_encryption, ['tls', 'ssl', 'starttls']) ? 'selected' : '' }}>Other</option>
                                                    </select>
                                                </div>
                                                <div class="form-group" id="other_encryption_input_container" style="display: {{ isset($user_emailconfig->smtp_encryption) && !in_array($user_emailconfig->smtp_encryption, ['tls', 'ssl', 'starttls']) ? 'block' : 'none' }}">
                                                    <label for="smtp_encryption_other">Specify Encryption</label>
                                                    <input type="text" id="smtp_encryption_other" name="encryption_other" class="form-control" placeholder="Enter Encryption" value="{{ isset($user_emailconfig->smtp_encryption) && !in_array($user_emailconfig->smtp_encryption, ['tls', 'ssl', 'starttls']) ? $user_emailconfig->smtp_encryption : '' }}">
                                                </div>
                                                <input type="hidden" name="smtp_encryption" id="hidden_encryption" value="{{ isset($user_emailconfig->smtp_encryption) ? $user_emailconfig->smtp_encryption : '' }}">
                                                <input type="hidden" id="old_encryption" value="{{ isset($user_emailconfig->smtp_encryption) ? $user_emailconfig->smtp_encryption : ''}}">
                                            </div>
                                            <div class="col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Signature</label>
                                                    <textarea class="editor" cols="10" rows="10" name="signature" id="content">{{ isset($users->signature) ? $users->signature : ''}}</textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="row mb-3">
                        <div class="col-12">
                            <div class="">
                                <button type="submit" name="submit" value="single"
                                    class="btn btn-primary">Save</button>
                                <button  type="button" onclick="applyforall(this)"
                                    class="btn btn-primary">Save & Apply for All</button>
                                <button type="button" name="sentemail" id="testsentemail" class="btn btn-primary">Send
                                    Test Email</button>
                                <button style="visibility: hidden" type="submit" id="submitAll"  name="submit" value="apply_for_all"
                                    class="btn btn-primary">Save & Apply for All</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- show_visitor file Modal -->
    <div class="modal fade" id="show_sendEmail" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-md" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="show_sendEmailTitle">Test Email</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="testemail_form" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="testemail">Email</label><span class="input-danger">*</span>
                                    <input type="email" name="testemail" class="form-control" id="testemail"
                                        placeholder="Enter email" value="" required>
                                    <p class="error" id="invalid_email"></p>
                                </div>
                                <div class="col-12">
                                    <div class="">
                                        <button type="submit" name="testemailbtn" id="testemailbtn"
                                            class="btn btn-primary">Send Test Email</button>
                                    </div>
                                </div>
                                <div class="error" id="cf-response-message"></div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div id="overlay">
        <div class="cv-spinner">
            <span class="spinner"></span>
        </div>
    </div>
@endsection
@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    {{-- <script>
    $(document).ready(function() {
        $('#emailDetailsForm').on('submit', function(event) {
            event.preventDefault(); // Prevent the default form submission

            // Perform custom actions, e.g., AJAX request
            $.ajax({
                url: $(this).attr('action'),
                type: 'POST',
                data: $(this).serialize(), // Serialize form data
                success: function(response) {
                    console.log('Form submitted successfully:', response);
                },
                error: function(xhr, status, error) {
                    console.error('Form submission error:', status, error);
                }
            });
        });
    });
</script> --}}

        <script>
            $(document).ready(function() {
                // Function to toggle visibility of the custom encryption input
                function toggleOtherEncryptionInput() {
                    const isOther = $('#smtp_encryption').val() === 'other';
                    $('#other_encryption_input_container').toggle(isOther);
                    $('#hidden_encryption').val(isOther ? $('#smtp_encryption_other').val() : $('#smtp_encryption').val());
                }

                // Function to toggle visibility of the custom port input
                function toggleOtherPortInput() {
                    const isOther = $('#smtp_port').val() === 'other';
                    $('#other_port_input_container').toggle(isOther);
                    $('#hidden_port').val(isOther ? $('#smtp_port_other').val() : $('#smtp_port').val());

                    // Update encryption based on port selection
                    const selectedPort = $('#smtp_port').val();
                    if (selectedPort === '465') {
                        $('#smtp_encryption').val('ssl').change();
                    } else if (selectedPort === '587') {
                        $('#smtp_encryption').val('tls').change();
                    }
                }

                // Initialize states based on existing values
                function initializeSettings() {
                    const savedPort = $('#smtp_port').val();
                    const savedEncryption = $('#smtp_encryption').val();

                    // Toggle visibility based on saved values
                    toggleOtherEncryptionInput();
                    toggleOtherPortInput();

                    // Set initial encryption based on saved port if not explicitly set
                    if (savedPort === '465' && savedEncryption === '') {
                        $('#smtp_encryption').val('ssl').change();
                    } else if (savedPort === '587' && savedEncryption === '') {
                        $('#smtp_encryption').val('tls').change();
                    } else if (savedEncryption === 'starttls') {
                        $('#smtp_encryption').val('starttls').change();
                    }


                }

                // Initialize settings on page load
                initializeSettings();

                // Event listeners
                $('#smtp_encryption').change(toggleOtherEncryptionInput);
                $('#smtp_encryption_other').on('input', function() {
                    $('#hidden_encryption').val($(this).val());
                });

                $('#smtp_port').change(function() {
                    toggleOtherPortInput();
                    $('#smtp_port_other').val(''); // Clear custom port input when changing the port
                });

                $('#smtp_port_other').on('input', function() {
                    $('#hidden_port').val($(this).val());
                });

                if($('#old_encryption').val() != 'ssl' && $('#old_encryption').val() != 'tls' && $('#old_encryption').val() != 'starttls'){
                        $('#smtp_encryption').val('other')
                }

            });
        </script>

         <script>
        $(document).ready(function() {
            $('#emailDetailsForm').validate();

            $("#sender_email").keyup(function() {
                var senderEmailValue = $(this).val();
                $('#smtp_user_name').val(senderEmailValue);
            });
        });


        function applyforall(elm) {
    // Check if the form is valid
    if ($('#emailDetailsForm').valid()) {
        // SweetAlert2 confirmation dialog
        Swal.fire({
            title: 'Are you sure you want to apply for all?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Confirm',
            cancelButtonText: 'Cancel',
            reverseButtons: true,
            focusCancel: true
        }).then((result) => {
            if (result.isConfirmed) {
                // If confirmed, trigger the form submission
                $('#submitAll').click();
            }
        });
    } else {
        // If the form is not valid, show an error message
        Swal.fire({
            title: 'Please correct the errors in the form before proceeding.',
            icon: 'error',
            confirmButtonText: 'OK'
        });
    }
}

        $(".smtpOptions").click(function(e) {
            var smtpOptionsValue = $(this).val();
            var smtp_transport = 'SMTP';
            var smtp_host = '';
            var smtp_port = '465'; // Default port
            var smtp_encryption = 'ssl'; // Default encryption

            if (smtpOptionsValue === 'Gsuit') {
                smtp_host = 'smtp.gmail.com';
                smtp_port = '465';
                smtp_encryption = 'ssl';
            } else if (smtpOptionsValue === 'Office365') {
                smtp_host = 'smtp.office365.com';
                smtp_port = '587';
                smtp_encryption = 'tls';
            } else if (smtpOptionsValue === 'Godaddy') {
                smtp_host = 'smtpout.secureserver.net';
                smtp_port = '587';
                smtp_encryption = 'tls';
            } else if (smtpOptionsValue === 'Hostinger') {
                smtp_host = 'smtp.hostinger.com';
                smtp_port = '587';
                smtp_encryption = 'tls';
            } else if (smtpOptionsValue === 'ZOHO') {
                smtp_host = 'smtp.zoho.com';
                smtp_port = '587';
                smtp_encryption = 'tls';
            } else {
                // For other options, set defaults or leave as-is
                smtp_host = ''; // Set this according to your requirements
            }

            // Update the form fields
            $('#smtp_transport').val(smtp_transport);
            $('#smtp_host').val(smtp_host);
            $('#smtp_port').val(smtp_port);
            $('#smtp_encryption').val(smtp_encryption);

            // Trigger change events to ensure other inputs respond appropriately
            $('#smtp_port').change();
            $('#smtp_encryption').change();

            // Hide the custom input containers
            $('#other_encryption_input_container').hide();
            $('#other_port_input_container').hide();
        });


        $(document).ready(function() {
            $('#testsentemail').click(function() {
                $("#show_sendEmail").modal('show');
            });
            $("#testemailbtn").click(function(e) {
                e.preventDefault();
                let testemail = $('#testemail').val();
                if (testemail === '') {
                    $('#invalid_email').text("Input Fields can not be Empty!!");
                    $('#invalid_email').css("color", "red");
                    return false;
                } else if (IsEmail(testemail) === false) {
                    $('#invalid_email').text("Entered Email is not Valid!!");
                    $('#invalid_email').css("color", "red");
                    return false;
                } else {
                    $('#invalid_email').text("");
                    var url = "{{ route('users.testnewemail') }}";
                    var customer_id = "{{ $CustomerID }}";
                    $("#overlay").fadeIn(300);
                    let formData = new FormData($('#emailDetailsForm')[0]);
                    console.log(formData);
                    formData.append('email', testemail);
                    formData.append('customer_id', customer_id);
                    $.ajax({
                        url: url,
                        type: "post",
                        data: formData,
                        dataType: "json",
                        cache: false,
                        processData: false,
                        contentType: false,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]')
                                .attr('content')
                        },
                        success: function(response) {
                            console.log(response);
                            if (response) {
                                $('#cf-response-message').html(response.message);
                            }
                            setTimeout(function() {
                                $("#overlay").fadeOut(300);
                            }, 500);
                        },
                        error: function(data) {
                            console.log(data);
                            $('#cf-response-message').text(data.responseText);
                            setTimeout(function() {
                                $("#overlay").fadeOut(300);
                            }, 500);
                        }
                    });
                }
            });
        });

        function IsEmail(email) {
            const regex = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            if (!regex.test(email)) {
                return false;
            } else {
                return true;
            }
        }
    </script>

    <script>
        $(document).ready(function() {
            // CKEDITOR.replace( 'content' );
            CKEDITOR.replace('content', {
                extraPlugins: 'customImageUpload',
                height: 200
            });
        });

        (function() {
            CKEDITOR.plugins.add('customImageUpload', {
                icons: 'image',
                init: function(editor) {
                    // Add the command for uploading images
                    editor.addCommand('uploadImage', {
                        exec: function(editor) {
                            var fileInput = document.createElement('input');
                            fileInput.type = 'file';
                            fileInput.accept = 'image/*';
                            fileInput.onchange = function(event) {
                                var file = event.target.files[0];
                                var formData = new FormData();
                                formData.append('image', file);

                                $.ajax({
                                    type: 'POST',
                                    url: "{{ route('email-upload-image') }}",
                                    data: formData,
                                    cache: false,
                                    contentType: false,
                                    processData: false,
                                    headers: {
                                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]')
                                            .attr('content')
                                    },
                                    success: function(data) {
                                        if (data.status === 200 && data.url) {
                                            // Open the image dialog and set the URL field
                                            // editor.execCommand('image');
                                            // editor.once('dialogShow', function(evt) {
                                            //     var dialog = evt.data;
                                            //     if (dialog.getName() === 'image') {
                                            //         var urlField = dialog.getContentElement('info', 'url');
                                            //         if (urlField) {
                                            //             urlField.setValue(data.url);
                                            //         }
                                            //     }
                                            // });
                                            if (data.status === 200 && data
                                                .url) {
                                                editor.insertHtml('<img src="' +
                                                    data.url +
                                                    '" alt="Image">');
                                            } else {
                                                alert('Image upload failed!');
                                            }

                                        } else {
                                            alert('Image upload failed!');
                                        }
                                    },
                                    error: function(xhr, status, error) {
                                        console.error('Upload failed:', error);
                                        alert('Image upload failed!');
                                    }
                                });
                            };
                            fileInput.click();
                        }
                    });

                    // Add a custom button to the image dialog
                    CKEDITOR.on('dialogDefinition', function(ev) {
                        var dialogName = ev.data.name;
                        var dialogDefinition = ev.data.definition;

                        if (dialogName === 'image') {
                            var infoTab = dialogDefinition.getContents('info');
                            infoTab.elements.push({
                                type: 'button',
                                id: 'uploadImageButton',
                                label: 'Upload Image',
                                filebrowser: {
                                    action: 'Upload',
                                    url: '{{ route('email-upload-image') }}',
                                    title: 'Upload Image'
                                },
                                onClick: function() {
                                    editor.execCommand('uploadImage');
                                }
                            });
                        }
                    });

                    // Add the custom button to the toolbar
                    editor.ui.addButton('CustomImageUpload', {
                        label: 'Upload Image',
                        command: 'uploadImage',
                        toolbar: 'insert',
                        icon: 'customimageupload' // Referencing the CSS class for your custom icon
                    });
                }
            });
        })();

    </script>
@endpush
