@extends('layouts.master')
@section('content')
<style>
.select2-selection__choice{
    color: black !important;
}
.card-header {
    color: #fff;
    background-color: #007bff;
}

label.error{
color: red;
}
img {
    height:auto;
    width: 166px;
    object-fit: scale-down;
}

#fullpage {
    display: none;
    position: absolute;
    z-index: 9999;
    top: 0;
    left: 0;
    width: 80.3vw;
    height: 90vh;
    background-size: contain;
    background-repeat: no-repeat no-repeat;
    background-position: center center;
    background-color: black;
}
.image-gallery {
    display: flex;
    flex-wrap: wrap;
    margin: -5px;
}

.gallery-item {
    flex: 1.1 0 calc(33.33% - 10px);
    box-sizing: border-box;
    padding: 5px;
}
.img2 {
    height: 200px; /* Set the height to your desired value */
    object-fit: cover; /* This property ensures that the image retains its aspect ratio and covers the entire container */
}
</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Add Client</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        @php
                            $redirect_url = route('event.list');
                            if(Auth::user()->getUser() && Auth::user()->getUser()->is_admin == "true"){
                                $redirect_url = route('visitor.list');
                            }
                        @endphp
                        <li class="breadcrumb-item"><a href="{{ $redirect_url }}">Client List</a></li>
                        <li class="breadcrumb-item active">Add Client</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    {{--<i class="fas fa-minus"></i>--}}
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form id="visitorAddForm" method="post" action="{{ route('visitor.store') }}" name="form" enctype="multipart/form-data">
                                @csrf

                                <div class="form-group">
                                    <label for="">Visited Date</label>
                                    <input type="datetime-local" name="visited_date" value="{{ now()->setTimezone('Asia/Kolkata')->format('Y-m-d H:i') }}" class="form-control" placeholder="Enter Visited Date">
                                    @error('visited_date')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                {{-- @if(!empty(request()->get('event_id')))
                                    <input type="hidden" name="event_id" value="{{request()->get('event_id')}}">
                                @endif --}}
                                <div class="form-group">
                                    <label for="">Select Event/Folder</label>
                                    <select  class="form-control custom-select" name="event_id" id="event_id" required>
                                        <option value="" >Select Event/Folder</option>
                                        @foreach($events as $event)
                                            <option value="{{ $event->id }}" @if(request()->get('event_id') == $event->id) selected @endif>{{$event->event_name}}</option>
                                        @endforeach
                                    </select>
                                    @error('event_id')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>

                                @if(Auth::user()->getUser() && Auth::user()->getUser()->is_admin == "true")
                                    <div class="form-group">
                                        <label for="">Select Team Member</label>
                                        <select class="form-control custom-select" name="customer_id" id="customer_id" required>
                                            <option value="" >Select member</option>
                                            @foreach($members as $member)
                                                <option value="{{ $member->CustomerID }}" >{{$member->CustomerName}}</option>
                                            @endforeach
                                        </select>
                                        @error('customer_id')
                                        <div class="error">{{ $message }}</div>
                                        @enderror
                                    </div>
                                @else
                                    <input type="hidden" name="customer_id" value="{{ Auth::user()->getUser()->CustomerID }}" >
                                @endif
                                @sessionContactField('name')

                                <div class="form-group">
                                    <label for="">@defaultValue($contactFieldValue['label'] ?? 'Name') @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="name" class="form-control" placeholder="@defaultValue($contactFieldValue['hint'] ?? 'Enter Name')"  @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('name')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('designation')

                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Designation' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="designation" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Designation')" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('designation')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('company_name')

                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Company Name' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="company_name" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Company Name')" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('company_name')
                                        <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('company_website')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Website' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="website" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Website')" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('website')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('country_code_for_mobile')

                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Country Code' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <select class="form-control custom-select" name="country_code" id="country_code" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                        <option value="" >@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'No Country')</option>
                                        @foreach($countries as $country)
                                            <option value="{{ $country->iso_code }}" @if($country->iso_code== $countryCode) selected
                                                @endif >{{$country->name}}</option>
                                        @endforeach
                                    </select>
                                    @error('country')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('mobile1')

                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Mobile No.' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="mobile_no" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Mobile No')" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('mobile_no')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('mobile2')

                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Mobile No. 2' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="mobile_no2" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Mobile No2')" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('mobile_no2')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('mobile3')

                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Mobile No. 3' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="mobile_no3" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Mobile No3')" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('mobile_no3')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('email1')

                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Email' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="email" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Email')" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('email')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('email2')

                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Email 2' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="email2" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Email2')" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('email2')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('address_country_code')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Address Country Code' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <select class="form-control custom-select" name="address_country_code" id="address_country_code" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                        <option value="">@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'No Country')</option>
                                        @foreach($countries as $country)
                                            <option value="{{ $country->iso_code }}" @if($country->id== $countryCode) selected
                                                @endif>{{$country->name}}</option>
                                        @endforeach
                                    </select>
                                    @error('country')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('state')

                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'State' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <div class="states-dropdown">
                                        <select class="form-control custom-select" name="state" id="state_id" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                            <option value="">@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'No State')</option>
                                        </select>
                                    </div>
                                    {{-- <div class="states-textbox">
                                        <input type="text" id="state_textbox" name="state" class="form-control" placeholder="Enter State">
                                    </div> --}}
                                    @error('state')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('city')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'City' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <div class="cities-dropdown">
                                        <select class="form-control custom-select" name="city" id="city_id" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                            <option value="">No City</option>
                                        </select>
                                    </div>
                                    {{-- <div class="cities-textbox">
                                        <input type="text" id="city_textbox" name="city" class="form-control" placeholder="Enter City">
                                    </div> --}}
                                    @error('city')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('city')

								<div class="form-group" id="other_city" style="display:none;">
                                    <label for="othercity_textbox">@defaultValue(empty($contactFieldValue['label']) ? 'Other City' : $contactFieldValue['label'])</label>
                                    <div class="cities-dropdown">
                                        <input type="text" id="othercity_textbox" name="othercity" class="form-control" placeholder="@defaultValue(empty($contactFieldValue['hint']) ? 'Enter City Name' : $contactFieldValue['hint'])">
                                    </div>
                                    @error('city')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('area')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Area' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <div class="cities-dropdown">
                                        <select class="form-control custom-select" name="area" id="area" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                            <option value="">No Area</option>
                                        </select>
                                    </div>
                                    {{-- <div class="cities-textbox">
                                        <input type="text" id="city_textbox" name="city" class="form-control" placeholder="Enter City">
                                    </div> --}}
                                    @error('area')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('area')

								<div class="form-group" id="other_area" style="display:none;">
                                    <label for="otherarea_textbox">@defaultValue(empty($contactFieldValue['label']) ? 'Other Area' : $contactFieldValue['label'])</label>
                                    <div class="areas-dropdown">
                                        <input type="text" id="otherarea_textbox" name="otherarea" class="form-control" placeholder="@defaultValue(empty($contactFieldValue['hint']) ? 'Enter Area Name' : $contactFieldValue['hint'])">
                                    </div>
                                    @error('area')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('address')

                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Address' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="address" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Address')" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('address')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('pincode')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Pincode' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="pincode" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Pincode')" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('pincode')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('source_of_lead')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Source Of Lead' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <select class="form-control" name="source_of_lead" id="source_of_lead" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                        <option value="">@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Select Source Of Lead')</option>
                                        @foreach ($source_of_leads as $lead)
                                        <option value="{{ $lead }}" class="">{{ $lead }}</option>
                                        @endforeach
                                    </select>
                                    @error('source_of_lead')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('referred_by')
                                <div class="form-group referred_by_box" style="display: none;">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Referred By' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <select class="form-control"  name="referred_by_name" id="referred_by_name" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                        <option value="">@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Select Referred By')</option>
                                        @foreach ($referredBy as $refer)
                                        <option value="{{ $refer }}" class="">{{ $refer }}</option>
                                        @endforeach
                                    </select>
                                    @error('referred_by_name')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('category')

                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Category' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <select class="form-control custom-select" name="category[]" id="category_id" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>

                                    </select>
                                    @error('category')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('sub_category')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'SubCategory' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <select class="form-control custom-select" name="sub_category[]" id="sub_category_id" data-placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Select SubCategory')" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    </select>
                                    @error('sub_category')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('follow_up')

                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Follow up time' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="datetime-local" name="follow_up_time" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Follow Up Time')" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('follow_up_time')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('action')

                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Action' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <select class="form-control custom-select" name="action" id="action" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                        <option value="" >@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'No Action')</option>
                                        @foreach($actions as $action)
                                        <option value="{{ $action->title }}" >{{$action->title}}</option>
                                        @endforeach
                                    </select>
                                    @error('action')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('remarks')

                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Remarks' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="remarks" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Remarks')" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('remarks')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('qr_code_value')

                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'QR Code Value' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="qrcodevalue" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter QR Code Value')" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('qrcodevalue')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('priority')

                                <div class="form-group">
                                    <label for="priority">@defaultValue(empty($contactFieldValue['label']) ? 'Priority' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <select name="rating" id="priority" class="form-control" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                        <option value="">@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Select Priority')</option>
                                        <option value="High">High</option>
                                        <option value="Medium">Medium</option>
                                        <option value="Low">Low</option>
                                    </select>
                                    @error('rating')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('monthly_requirement')

                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Monthly Requirement' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="monthly_requirement" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Monthly Requirement')" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('monthly_requirement')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('products')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Products' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <select class="form-control custom-select" name="products[]" id="product_id" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                        <option></option>
                                    </select>
                                </div>
                                @endsessionContactField
                                <div class="form-group">
                                    <label for="">Front Image</label> :
                                    <input type="file" name="front_image" class="form-control @error('front_image') is-invalid @enderror" id="front_image" value="">
                                </div>
                                <div class="form-group">
                                    <label for="">Back Image</label> :
                                    <input type="file" name="back_image" class="form-control @error('back_image') is-invalid @enderror" id="back_image" value="">
                                </div>
                                <div class="form-group">
                                    <label for="">Event Images</label> :
                                    <input type="file" name="event_images[]" class="form-control @error('event_images') is-invalid @enderror" id="event_images" value="" multiple>
                                </div>
                                <div class="card-footer">
                                <button type="submit" class="btn btn-primary" >Add</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function getPics() {}
    const imgs = document.querySelectorAll('.gallery img');
    const fullPage = document.querySelector('#fullpage');

    imgs.forEach(img => {
        img.addEventListener('click', function() {
            fullPage.style.backgroundImage = 'url(' + img.src + ')';
            fullPage.style.display = 'block';
        });
    });
    $(document).ready(function() {
        $('#visitorAddForm').validate({
    errorPlacement: function(error, element) {
        if (element.hasClass("select2-hidden-accessible")) {
            // place error after the select2 container
            error.insertAfter(element.next('.select2'));
        } else {
            error.insertAfter(element);
        }
    },
})
        var addressCountryCode = "{{$countryCode}}";
        if(addressCountryCode === '' ){
            //console.log('null');
            $('.states-textbox').css('display','none');
            $('.cities-textbox').css('display','none');
            $('.states-dropdown').show();
            $('.cities-dropdown').show();
        }
        if(addressCountryCode === '99'){
            //console.log('IN');
            $('.states-textbox').css('display','none');
            $('.cities-textbox').css('display','none');
            $('.states-dropdown').show();
            $('.cities-dropdown').show();
            fetchStates(addressCountryCode);
        }else{
            //console.log('else');
            $('.states-dropdown').css('display','none');
            $('.cities-dropdown').css('display','none');
            $('.states-textbox').show();
            $('.cities-textbox').show();
            $('#state_textbox').val(" ");
            $('#city_textbox').val(" ");
        }
        setCategories();
        setProducts();
        $('#category_id').on("select2:select", function(e) {
            var categoryNames = [];
            $(e.currentTarget).find("option:selected").each(function(i, selected){
                categoryNames[i] = $(selected).text();
            });
            fetchSubCategories(categoryNames);
        });
        $('#category_id').on("select2:unselect", function(e) {
            var categoryNames = [];
            $(e.currentTarget).find("option:selected").each(function(i, selected){
                categoryNames[i] = $(selected).text();
            });
            if(categoryNames.length !== 0){
                fetchSubCategories(categoryNames);
            }else{
                var subCategoryId = $('#sub_category_id');
                $('#sub_category_id').html('');
                subCategoryId.val(null).trigger('change');
            }
        });
        $("#category_id").select2({
            @sessionContactField('category')

            placeholder: "@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Select a category')",
            @endsessionContactField
            multiple: true,
        });
        $("#sub_category_id").select2({
            @sessionContactField('sub_category')

            placeholder: "@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Select a sub category')",
            @endsessionContactField
            multiple: true,
        });
        $("#product_id").select2({
            @sessionContactField('products')

placeholder: "@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Select product')",
@endsessionContactField
            multiple: true,
        });
        // $("#source_of_lead").select2({
        //     placeholder: "Select Source Of Lead",
        //     multiple: true,
        // });

        $("#source_of_lead").on("change",function(){
            var sourceOfLead = $(this).val();
            if(sourceOfLead == 'Referred By'){
                $('.referred_by_box').show();
            }else{
                $('.referred_by_box').hide();
            }
        })
    });
    function setCategories()
    {
        var categoryNames = "{{implode(',',[])}}";
        var allCategories = '{!! ($categories)  !!}';
        var options = [];
        var categoryId = $('#category_id');
        categoryId.html('');
        categoryId.val(null).trigger('change');


        $.each(JSON.parse(allCategories), function(index, value) {
            var selected = false;
            if(jQuery.inArray(value.name, categoryNames.split(',')) !== -1){
                selected = true;
            }
            var option = new Option(value.name, value.name, false, selected);
            categoryId.append(option).trigger('change');
            options.push(value.name);
        });
        // manually trigger the `select2:select` event
        categoryId.val(null).trigger({
            type: 'select2:select',
            params: {
                data: options
            }
        });
    }

    function setProducts()
    {
        var visitorProductIds = "{{ implode(',',[]) }}";
        var allProducts = @json($allProducts);
        var options = [];
        var productId = $('#product_id');
        productId.html('');
        productId.val(null).trigger('change');
        $.each(JSON.parse(allProducts), function(index, value) {
            var selected = false;
            if(jQuery.inArray(value.id.toString(), visitorProductIds.split(',')) !== -1){
                selected = true;
            }
            var option = new Option(value.name, value.id, false, selected);
            productId.append(option).trigger('change');
            options.push({id:value.id,text:value.name});
        });
        // manually trigger the `select2:select` event
        productId.val(null).trigger({
            type: 'select2:select',
            params: {
                data: options
            }
        });
    }
    function fetchSubCategories(categoryNames) {
        var url = "{{ route('get_sub_categories') }}";
        var selectedSubCategoryNames = null;
        $.ajax({
            url: url,
            type: "GET",
            data: {
                categoryNames: categoryNames,
                selectedSubCategoryNames: selectedSubCategoryNames,
            },
            success: function(response) {
                var options = [];
                var rData = [];
                rData = response.data;
                selectedSubCategoryIds = response.selectedSubCategoryIds;
                var subCategoryId = $('#sub_category_id');
                $('#sub_category_id').html('');
                subCategoryId.val(null).trigger('change');
                $.each(rData, function(index, value) {
                    var selected = false;
                    if(jQuery.inArray(value.id, selectedSubCategoryIds) !== -1){
                        selected = true;
                    }
                    var option = new Option(value.name, value.name, false, selected);
                    subCategoryId.append(option).trigger('change');
                    options.push(value.name);
                });
                // manually trigger the `select2:select` event
                subCategoryId.trigger({
                    type: 'select2:select',
                    params: {
                        data: options
                    }
                });
            },
            error: function(error) {
                console.log(error);
            }
        });
    }

    $('#address_country_code').change(function() {
        var countryCode = $(this).val();
        if(countryCode !=='all' && countryCode === '99'){
            $('.states-textbox').css('display','none');
            $('.cities-textbox').css('display','none');
            $('.states-dropdown').show();
            $('.cities-dropdown').show();
            fetchStates(countryCode);
        }else{
            $('.states-dropdown').css('display','none');
            $('.cities-dropdown').css('display','none');
            $('.states-textbox').show();
            $('.cities-textbox').show();
        }
    });
    function fetchStates(countryCode) {
        var url = "{{ route('get_states') }}";
        $.ajax({
            url: url,
            type: "GET",
            data: {
                // countryCode: countryCode,
                countryId: countryCode,
            },
            success: function(response) {
                var options = [];
                var rData = [];
                rData = response.data;
                $.each(rData, function(index, value) {
                    var selectData = '';
                    selectData = '<option value="' + value.state + '" >' +value.state +
                        '</option>';
                    options.push(selectData);
                });
                $('#state_id').html('<option value="">No State</option>' +
                    options);
            },
            error: function(error) {
                console.log(error);
            }
        });
    }

    $('#state_id').change(function() {
        var stateId = $(this).val();
        fetchCities(stateId);
    });
	$('#city_id').change(function() {
        var city_id = $(this).val();
		$("#othercity_textbox").val('');
		if(city_id == 'Other'){
			$('#other_city').show();
			$("#othercity_textbox").prop('required',true);
		}else{
			$('#other_city').hide();
			$("#othercity_textbox").prop('required',false);
		}
        console.log(city_id);
        fetchArea(city_id);
    });
    $('#area').change(function() {
        let area = $(this).val();
		$("#otherarea_textbox").val('');
		if(area == 'Other'){
			$('#other_area').show();
			$("#otherarea_textbox").prop('required',true);
		}else{
			$('#other_area').hide();
			$("#otherarea_textbox").prop('required',false);
		}
        console.log(area);
    });
    function fetchArea(cityName) {
        var url = "{{ route('get_areas') }}";
        $.ajax({
            url: url,
            type: "GET",
            data: {
                city: cityName,
            },
            success: function(response) {
                var options = [];
                var rData = [];
                rData = response.data;

                $.each(rData, function(index, value) {
                    var selectData = '';
                    selectData = '<option value="' + value.name + '">' +value.name +
                        '</option>';
                    options.push(selectData);
                });
                $('#area').html('<option value="">No Area</option><option value="Other">Other</option>' +
                    options);
            },
            error: function(error) {
                console.log(error);
            }
        });
    }
    function fetchCities(stateName) {
        var url = "{{ route('get_cities') }}";
        $.ajax({
            url: url,
            type: "GET",
            data: {
                stateId: stateName,
            },
            success: function(response) {
                var options = [];
                var rData = [];
                rData = response.data;

                $.each(rData, function(index, value) {
                    var selectData = '';
                    selectData = '<option value="' + value.district + '">' +value.district +
                        '</option>';
                    options.push(selectData);
                });
                $('#city_id').html('<option value="">No City</option><option value="Other">Other</option>' +
                    options);
            },
            error: function(error) {
                console.log(error);
            }
        });
    }
    
</script>
@endsection
