@extends('layouts.master')
@section('content')
    <style>
        .card-header {
            color: #fff;
            background-color: #007bff;
        }

        .error {
            color: red;
        }

        .select2-container--default .select2-selection--multiple .select2-selection__choice {
            color: #000;
        }

        div.dataTables_wrapper div.dataTables_filter {
            text-align: right;
            float: left;
        }
    </style>

    <div class="content-wrapper">
        {{-- HEADER --}}
        <div class="content-header pb-1">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-9">
                        <h1 class="m-0">
                            Company Visits : <strong>{{ $company_name }}</strong>
                        </h1>
                    </div>
                    <div class="col-sm-3">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                            <li class="breadcrumb-item">
                                <a href="{{ route('visitor.list') }}">Client</a>
                            </li>
                            <li class="breadcrumb-item active">Company Visits</li>
                        </ol>
                    </div>
                    <div class="container-fluid p-0">
                        <div class="card-body p-3 pb-0 row">
                            <form method="get" id="myform" name="myform" enctype="multipart/form-data"
                                action="{{ route('visitor.companydetail') }}">
                                <input type="hidden" value="{{ urlencode($company_name) }}" name="company_name">
                                <div class="form-group mb-2 row">
                                    <div class="col-2">
                                        <label>Select Client Name</label>
                                        <div class="d-flex">
                                            <select id="visitor_filter" name="visitor_name" class="form-control">
                                                <option value="">All Clients</option>
                                                @foreach ($visitors as $visitor)
                                                    <option value="{{ $visitor }}"
                                                        {{ request('visitor_name') == $visitor ? 'selected' : '' }}>
                                                        {{ $visitor }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="mr-3 col-2 p-0">
                                        <label>Select Team Member</label>
                                        <select id="member_filter" name="attend_by" class="form-control">
                                            <option value="">All Team Members</option>
                                            @foreach ($members as $member)
                                                <option value="{{ $member }}"
                                                    {{ request('attend_by') == $member ? 'selected' : '' }}>
                                                    {{ $member }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- CONTENT --}}
        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">
                                    Visit History – {{ $company_name }}
                                </h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                </div>
                            </div>

                            <div class="card-body">

                                {{-- DATATABLE --}}
                                <div class="row mt-0">
                                    <div class="col-12 table-responsive">
                                        <div class="row mb-2">
                                            <div class="col-md-6">
                                                <button id="exportExcel" class="btn btn-2 bg-gradient-info btn-1"
                                                    style="color:white">
                                                    Export
                                                </button>
                                            </div>
                                        </div>

                                        {{ $dataTable->table() }}
                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- LOADER --}}
    <div id="overlay">
        <div class="cv-spinner">
            <span class="spinner"></span>
        </div>
    </div>

    {{-- DATATABLE SCRIPTS --}}
    @push('scripts')
        {!! $dataTable->scripts() !!}
        <script>
            $('#exportExcel').on('click', function() {
                let query = window.location.search;
                window.location.href =
                    "{{ route('visitor.companydetail') }}" + query + "&export=excel";
            });
            $('#visitor_filter, #member_filter').on('change', function() {
                $('#myform').submit();
            });
        </script>
    @endpush
@endsection
