@extends('layouts.master')
@section('content')
    <style>
        .card-header {
            color: #fff;
            background-color: #007bff;
        }
        .error{
            color: red;
        }
        .select2-container--default .select2-selection--multiple .select2-selection__choice{
            color: #000;
        }

        #fullpage {
            display: none;
            position: absolute;
            top: 0;
            left: 0;
            width: 81.4vw;
            height: 60vh;
            background-size: contain;
            background-repeat: no-repeat no-repeat;
            background-position: center center;
            background-color: black;
        }


        .item {
            width: 200px;
            text-align: center;
            display: block;
            background-color: transparent;
            border: 1px solid transparent;
            margin-right: 10px;
            margin-bottom: 1px;
            margin-top: 10px;
            float: left;
        }

        img {
            height: auto;
            width: 60px;
            object-fit: scale-down;
        }
        div.dataTables_wrapper div.dataTables_filter {
            text-align: right;
            float: left;
        }
        #overlay {
            position: fixed;
            top: 0;
            z-index: 1070;
            width: 100%;
            height: 100%;
            display: none;
            background: rgba(0, 0, 0, 0.6);
        }

        .cv-spinner {
            height: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .spinner {
            width: 40px;
            height: 40px;
            border: 4px #ddd solid;
            border-top: 4px #2e93e6 solid;
            border-radius: 50%;
            animation: sp-anime 0.8s infinite linear;
        }
        .select2-container--default .select2-selection--single {
            height: calc(2.25rem + 2px) !important;
        }
        .circle-cls{
            width: 100px;
            height: 100px;
            border: 3px solid #007bff;
            border-radius: 50%;
            display: inline-block;
            font-size: 34px;
        }
        .circle-cls .innertxt{
            vertical-align: -webkit-baseline-middle;
            font-weight: 500;
        }
        .dashboardtxt{
            font-size: 24px;
            font-weight: 500;
        }
    </style>
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Dashboard Details</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard Details</li>
                        </ol>
                    </div>
                    <div class="container-fluid">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3">
                                    <p><strong>Team Member </strong>: {{$CustomerID}} </p>
                                </div>
                                <div class="col-md-3">
                                    <p><strong>Start Date </strong>: {{$start_date}} </p>
                                </div>
                                <div class="col-md-3">
                                    <p><strong>End Date </strong>: {{$end_date}} </p>
                                </div>
                                <div class="col-md-3">
                                    <p><strong>Action </strong>: {{$action}} </p>
                                </div>
                            </div>

                            <!-- <form method="get" id="myform" name="myform" action="{{ route('client.dashboard') }}"
                                enctype="multipart/form-data">
                                <div class="form-group row">
                                    
                                    @if(Auth::user()->type != "user")
                                    <div class="col-2 mb-2">
                                        <label for="">Select Team Member</label>
                                        <select class="form-control custom-select" name="CustomerID" id="CustomerID">
                                            <option value="all" @if ($CustomerID == 'all') selected @endif>All
                                            </option>
                                            @foreach ($users as $username)
                                                <option value="{{ $username->CustomerID }}"
                                                    @if ($CustomerID == $username->CustomerID) selected @endif>
                                                    {{ $username->CustomerName }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @endif

                                    
                                    <div class="col-2 mb-2">
                                        <label for="">Select Start Date</label>
                                        <input type="date" name="start_date" id="start_date" class="form-control"
                                            value="{{ $start_date }}">
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select End Date</label>
                                        <input type="date" name="end_date" id="end_date" class="form-control"
                                            value="{{ $end_date }}">
                                    </div>
                                    <div class="col-2">
                                        <div class="form-group mb-0">
                                            <button type="submit" class="btn btn-2 bg-gradient-info btn-1 mr-2" style="color:white;margin-top: 30px;">Submit</button>
                                        </div>
                                    </div>
                                </div>
                                
                            </form> -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">
                        <form method="post" name="frm_no_kids" id="frm_no_kids" class="getstarted"
                                    action="{{ route('client.exportclientdashboarddetails') }}">
                                    @csrf
                                    <input type="hidden" id="CustomerID" name="CustomerID"
                                        value="@if (isset($_GET['CustomerID'])) {{ $_GET['CustomerID'] }} @endif">

                                    <input type="hidden" id="action" name="action"
                                        value="@if (isset($_GET['action'])) {{ $_GET['action'] }} @endif">    
                                    <input type="hidden" id="startDate" name="start_date"
                                        value="@if (isset($_GET['start_date'])) {{ $_GET['start_date'] }} @endif">
                                    <input type="hidden" id="endDate" name="end_date"
                                        value="@if (isset($_GET['end_date'])) {{ $_GET['end_date'] }} @endif">

                                    

                                    <input type="submit" id="submit_export" name="submit_export" style="display:none;">
                                    <button class="btn btn-2 bg-gradient-info btn-1" data-toggle="tooltip"
                                        data-placement="left" title="Export" style="color:white">
                                        <i class="bx bxs-edit" aria-hidden="true"></i>Export
                                    </button>
                                </form>
                        <div class="row">
                            <div class="col-12 mt-4 table-responsive">
                                {{ $dataTable->table() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    
    


    <div id="overlay">
        <div class="cv-spinner">
            <span class="spinner"></span>
        </div>
    </div>

    @push('scripts')
        {!! $dataTable->scripts() !!}
        <script>

        </script>
    @endpush



@endsection
