<?php $__env->startSection('content'); ?>
    <style>
        .card-header {
            color: #fff;
            background-color: #007bff;
        }
        .error{
            color: red;
        }
        .select2-container--default .select2-selection--multiple .select2-selection__choice{
            color: #000;
        }

        #fullpage {
            display: none;
            position: absolute;
            top: 0;
            left: 0;
            width: 81.4vw;
            height: 60vh;
            background-size: contain;
            background-repeat: no-repeat no-repeat;
            background-position: center center;
            background-color: black;
        }


        .item {
            width: 200px;
            text-align: center;
            display: block;
            background-color: transparent;
            border: 1px solid transparent;
            margin-right: 10px;
            margin-bottom: 1px;
            margin-top: 10px;
            float: left;
        }

        img {
            height: auto;
            width: 60px;
            object-fit: scale-down;
        }
        div.dataTables_wrapper div.dataTables_filter {
            text-align: right;
            float: left;
        }
        #overlay {
            position: fixed;
            top: 0;
            z-index: 1070;
            width: 100%;
            height: 100%;
            display: none;
            background: rgba(0, 0, 0, 0.6);
        }

        .cv-spinner {
            height: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .spinner {
            width: 40px;
            height: 40px;
            border: 4px #ddd solid;
            border-top: 4px #2e93e6 solid;
            border-radius: 50%;
            animation: sp-anime 0.8s infinite linear;
        }
    </style>

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Client List</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                            <li class="breadcrumb-item active">Client</li>
                        </ol>
                    </div>
                    <div class="container-fluid">
                        <div class="card-body">
                            <form method="get" id="myform" name="myform" action="<?php echo e(route('visitor.list')); ?>"
                                enctype="multipart/form-data">
                                <input type="hidden" value="" name="type" id="formType">
                                <div class="form-group row">
                                    <div class="col-2">
                                        <label for="">Select Event/Folder</label>
                                        <select class="form-control custom-select select2-multiple-event" data-placeholder="Select Event/Folder" name="event_id[]" multiple id="event_id">
                                            
                                            <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($val->id); ?>"
                                                    <?php echo (in_array($val->id,($event_id ?? []))) ? 'selected' : ''; ?>><?php echo e($val->event_name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <?php if(Auth::user()->type != "user"): ?>
                                    <div class="col-2">
                                        <label for="">Select Team Member</label>
                                        <select class="form-control custom-select select2-multiple-customer" data-placeholder="Select Team Member" name="CustomerID[]" multiple id="CustomerID">
                                            
                                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $username): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($username->is_delete == 'true'): ?>
                                                    <option value="<?php echo e($username->CustomerID); ?>" <?php echo (in_array($username->CustomerID,($CustomerID ?? []))) ? 'selected' : ''; ?> style="color:red;"> <?php echo e($username->CustomerName); ?> (Blocked)</option>
                                                <?php else: ?>
                                                    <option value="<?php echo e($username->CustomerID); ?>" <?php echo (in_array($username->CustomerID,($CustomerID ?? []))) ? 'selected' : ''; ?>> <?php echo e($username->CustomerName); ?></option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <?php endif; ?>

                            <?php $contactFieldValue = session('contact_detail_fields.' . 'source_of_lead'); if (
            empty($contactFieldValue) ||
            !isset($contactFieldValue['hide']) ||
            ($contactFieldValue['hide'] === false)
        ):  ?>

                                    <div class="col-2">
                                        <label for=""><?php echo empty($contactFieldValue['label']) ? 'Select Source of Lead' : $contactFieldValue['label']; ?></label>
                                        <select class="form-control custom-select select2-multiple-sourceoflead" data-placeholder="<?php echo empty($contactFieldValue['label']) ? 'Select Source of Lead' : $contactFieldValue['label']; ?>" name="sourceoflead[]" multiple id="sourceoflead">
                                            
                                            <?php $__currentLoopData = $sourceofleadList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($val->name); ?>"
                                                    <?php echo (in_array($val->name,($sourceoflead ?? []))) ? 'selected' : ''; ?>><?php echo e($val->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <?php endif; unset($contactFieldValue); ?>
                            <?php $contactFieldValue = session('contact_detail_fields.' . 'category'); if (
            empty($contactFieldValue) ||
            !isset($contactFieldValue['hide']) ||
            ($contactFieldValue['hide'] === false)
        ):  ?>

                                    <div class="col-2">
                                        <label for=""><?php echo empty($contactFieldValue['label']) ? 'Select Category' : $contactFieldValue['label']; ?></label>
                                        <select class="form-control custom-select select2-multiple-category" data-placeholder="<?php echo empty($contactFieldValue['label']) ? 'Select Category' : $contactFieldValue['label']; ?>" name="category_id[]" multiple id="category_id">
                                                
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($val->id); ?>"
                                                    <?php echo (in_array($val->id,($category_id ?? []))) ? 'selected' : ''; ?>><?php echo e($val->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <?php endif; unset($contactFieldValue); ?>
                            <?php $contactFieldValue = session('contact_detail_fields.' . 'sub_category'); if (
            empty($contactFieldValue) ||
            !isset($contactFieldValue['hide']) ||
            ($contactFieldValue['hide'] === false)
        ):  ?>

                                    <div class="col-2">
                                        <label for=""><?php echo empty($contactFieldValue['label']) ? 'Select Sub Category' : $contactFieldValue['label']; ?></label>
                                        <select class="form-control custom-select select2-multiple-subcategory" data-placeholder="<?php echo empty($contactFieldValue['label']) ? 'Select Sub Category' : $contactFieldValue['label']; ?>" name="sub_category_id[]" multiple id="sub_category_id">
                                            
                                        </select>
                                    </div>
                                    <?php endif; unset($contactFieldValue); ?>
                                    <?php $contactFieldValue = session('contact_detail_fields.' . 'action'); if (
            empty($contactFieldValue) ||
            !isset($contactFieldValue['hide']) ||
            ($contactFieldValue['hide'] === false)
        ):  ?>

                                    <div class="col-2">
                                        <label for="action"><?php echo empty($contactFieldValue['label']) ? 'Action' : $contactFieldValue['label']; ?></label>
                                        <select class="form-control custom-select select2-multiple-action" multiple data-placeholder="<?php echo empty($contactFieldValue['label']) ? 'Select Action' : $contactFieldValue['label']; ?>" name="action[]" id="action" style="width: 100%;">
                                            
                                            <?php $__currentLoopData = $actionList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($a->title); ?>" <?php echo (in_array($a?->title,($action ?? []))) ? 'selected' : ''; ?>>
                                                    <?php echo e($a->title); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <?php endif; unset($contactFieldValue); ?>
                                    <div class="col-2">
                                        <label for="">Select Start Date</label>
                                        <input type="date" name="start_date" id="start_date" class="form-control"
                                            value="<?php echo e($start_date); ?>">
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select End Date</label>
                                        <input type="date" name="end_date" id="end_date" class="form-control"
                                            value="<?php echo e($end_date); ?>">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="col-2">
                                        <label for="">Region</label>
                                        <select class="form-control custom-select select2-multiple-region" data-placeholder="Select Region" name="region[]" multiple id="region">
                                            
                                            <?php if($regions): ?>
                                                <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($val->id); ?>" <?php echo (in_array($val?->id,($region ?? []))) ? 'selected' : ''; ?>
                                                        >
                                                        <?php echo e($val->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>

                                    <div class="col-2">
                                        <label for="">Is International</label>
                                        <select class="form-control custom-select" name="is_international"
                                            id="is_international">
                                            <option value="all" <?php echo ($is_international == 'all') ? 'selected' : ''; ?>>All
                                            </option>
                                            <option value="false" <?php echo ($is_international == 'false') ? 'selected' : ''; ?>>India
                                            </option>
                                            <option value="true" <?php echo ($is_international == 'true') ? 'selected' : ''; ?>>
                                                International</option>
                                        </select>
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select Country</label>
                                        <select class="form-control custom-select select2-multiple-country" multiple data-placeholder="Select Country" name="country_id[]" id="country_id">
                                            
                                            </option>
                                        </select>
                                    </div>
                                    <?php $contactFieldValue = session('contact_detail_fields.' . 'state'); if (
            empty($contactFieldValue) ||
            !isset($contactFieldValue['hide']) ||
            ($contactFieldValue['hide'] === false)
        ):  ?>

                                    <div class="col-2">
                                        <label for=""><?php echo empty($contactFieldValue['label']) ? 'Select State' : $contactFieldValue['label']; ?></label>
                                        <select class="form-control custom-select select2-multiple-state" multiple data-placeholder="<?php echo empty($contactFieldValue['label']) ? 'Select State' : $contactFieldValue['label']; ?>" name="state_id[]" id="state_id">
                                            
                                        </select>
                                    </div>
                                    <?php endif; unset($contactFieldValue); ?>
                                    <?php $contactFieldValue = session('contact_detail_fields.' . 'city'); if (
            empty($contactFieldValue) ||
            !isset($contactFieldValue['hide']) ||
            ($contactFieldValue['hide'] === false)
        ):  ?>

                                    <div class="col-2">
                                        <label for=""><?php echo empty($contactFieldValue['label']) ? 'Select City' : $contactFieldValue['label']; ?></label>
                                        <select class="form-control custom-select select2-multiple-city" multiple data-placeholder="<?php echo empty($contactFieldValue['label']) ? 'Select City' : $contactFieldValue['label']; ?>" name="city_id[]" id="city_id">
                                            
                                        </select>
                                    </div>
                                    <?php endif; unset($contactFieldValue); ?>
                                    <?php $contactFieldValue = session('contact_detail_fields.' . 'area'); if (
            empty($contactFieldValue) ||
            !isset($contactFieldValue['hide']) ||
            ($contactFieldValue['hide'] === false)
        ):  ?>

                                    <div class="col-2">
                                        <label for=""><?php echo empty($contactFieldValue['label']) ? 'Select Area' : $contactFieldValue['label']; ?></label>
                                        <select class="form-control custom-select select2-multiple-area" multiple data-placeholder="<?php echo empty($contactFieldValue['label']) ? 'Select Area' : $contactFieldValue['label']; ?>" name="area[]" id="area">
                                            
                                        </select>
                                    </div>
                                    <?php endif; unset($contactFieldValue); ?>

                                </div>
                                <div class="form-group">
                                    <button type="submit" class="btn btn-2 bg-gradient-info btn-1"
                                        style="color:white;">Submit</button>
                                    <button type="button" class="btn btn-2 bg-gradient-info btn-1"
                                        onclick="exportImages(this);" style="color:white;">Export Images</button>
                                    <!-- <button type="button" class="btn btn-primary" onclick="sendMail('followup');">Send
                                        FollowUp Email</button>
                                    <button type="button" class="btn btn-primary" onclick="sendMail('primary');">Send
                                        Primary Email</button> -->
                                    <button type="button" class="btn btn-primary"
                                        onclick="setOtherEmail(this);">Schedule Email</button>
                                    <?php if(Session::get('bulk_whatsapp') == 1): ?>
                                    <button type="button" class="btn btn-primary"
                                        onclick="sendBulkMessage(this);">Send Bulk Message</button>
                                    <?php endif; ?>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Client</h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"
                                        title="Collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                    <!-- <button type="button" class="btn btn-tool" data-card-widget="remove" title="Remove">
                                            <i class="fas fa-times"></i>
                                        </button> -->
                                </div>
                            </div>
                            <div class="card-body">
                                <form method="post" name="frm_no_kids" id="frm_no_kids" class="getstarted"
                                    action="<?php echo e(route('export.exportvisitorlist')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <?php if(request()->get('event_id')): ?>
                                    <?php $__currentLoopData = request()->get('event_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <input type="hidden" id="event_id" name="event_id[]"
                                        value="<?php echo e($a); ?>">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php else: ?>
                                    <input type="hidden" id="event_id" name="event_id"
                                        value="">
                                    <?php endif; ?>

                                    <?php if(request()->get('CustomerID')): ?>
                                    <?php $__currentLoopData = request()->get('CustomerID'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <input type="hidden" id="CustomerID" name="CustomerID[]"
                                        value="<?php echo e($a); ?>">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <input type="hidden" id="CustomerID" name="CustomerID"
                                        value="">
                                    <?php endif; ?>

                                    <?php if(request()->get('sourceoflead')): ?>
                                    <?php $__currentLoopData = request()->get('sourceoflead'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <input type="hidden" id="sourceoflead" name="sourceoflead[]"
                                        value="<?php echo e($a); ?>">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <input type="hidden" id="sourceoflead" name="sourceoflead"
                                        value="">
                                    <?php endif; ?>

                                    <?php if(request()->get('category_id')): ?>
                                    <?php $__currentLoopData = request()->get('category_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <input type="hidden" id="category_id" name="category_id[]"
                                        value="<?php echo e($a); ?>">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <input type="hidden" id="category_id" name="category_id"
                                        value="">
                                    <?php endif; ?>

                                    <?php if(request()->get('sub_category_id')): ?>
                                    <?php $__currentLoopData = request()->get('sub_category_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <input type="hidden" id="sub_category_id" name="sub_category_id[]"
                                        value="<?php echo e($a); ?>">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <input type="hidden" id="sub_category_id" name="sub_category_id"
                                        value="">
                                    <?php endif; ?>

                                    <?php if(request()->get('state_id')): ?>
                                    <?php $__currentLoopData = request()->get('state_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <input type="hidden" id="state_id" name="state_id[]"
                                        value="<?php echo e($a); ?>">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <input type="hidden" id="state_id" name="state_id"
                                        value="">
                                    <?php endif; ?>

                                    <?php if(request()->get('city_id')): ?>

                                    <?php $__currentLoopData = request()->get('city_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <input type="hidden" id="city_id" name="city_id[]"
                                        value="<?php echo e($a); ?>">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <input type="hidden" id="city_id" name="city_id"
                                        value="">
                                    <?php endif; ?>

                                    <?php if(request()->get('area')): ?>
                                    <?php $__currentLoopData = request()->get('area'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <input type="hidden" id="area" name="area[]"
                                        value="<?php echo e($a); ?>">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <input type="hidden" id="area" name="area"
                                        value="">
                                    <?php endif; ?>

                                    <?php if(request()->get('action')): ?>
                                    <?php $__currentLoopData = request()->get('action'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <input type="hidden" id="action" name="action[]"
                                        value="<?php echo e($a); ?>">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <input type="hidden" id="action" name="action"
                                        value="">
                                    <?php endif; ?>
                                    
                                    <input type="hidden" id="is_international" name="is_international"
                                        value="<?php echo e(request()->get('is_international')); ?>">
                                    

                                    <?php if(request()->get('country_id')): ?>
                                    <?php $__currentLoopData = request()->get('country_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <input type="hidden" id="country_id" name="country_id[]"
                                        value="<?php echo e($a); ?>">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <input type="hidden" id="country_id" name="country_id"
                                        value="">
                                    <?php endif; ?>
                                    <?php if(request()->get('region')): ?>
                                    <?php $__currentLoopData = request()->get('region'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <input type="hidden" id="region" name="region[]"
                                        value="<?php echo e($a); ?>">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <input type="hidden" id="region" name="region"
                                        value="">
                                    <?php endif; ?>
                                    <input type="hidden" id="startDate" name="start_date"
                                        value="<?php if(isset($_GET['start_date'])): ?> <?php echo e($_GET['start_date']); ?> <?php endif; ?>">
                                    <input type="hidden" id="endDate" name="end_date"
                                        value="<?php if(isset($_GET['end_date'])): ?> <?php echo e($_GET['end_date']); ?> <?php endif; ?>">
                                    <input type="submit" id="submit_export" name="submit_export" style="display:none;">
                                    <button class="btn btn-2 bg-gradient-info btn-1" data-toggle="tooltip"
                                        data-placement="left" title="Export" style="color:white">
                                        <i class="bx bxs-edit" aria-hidden="true"></i>Export
                                    </button>
                                </form>

                                <form method="post" name="frm_no_kids" id="frm_no_kids" class="getstarted"
                                    action="<?php echo e(route('export.export_pdf')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <?php if(request()->get('event_id')): ?>
<?php $__currentLoopData = request()->get('event_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <input type="hidden" id="event_id" name="event_id[]" value="<?php echo e($val); ?>">
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
<input type="hidden" id="event_id" name="event_id" value="">
<?php endif; ?>

                                   
<?php if(request()->get('CustomerID')): ?>
<?php $__currentLoopData = request()->get('CustomerID'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <input type="hidden" id="CustomerID" name="CustomerID[]" value="<?php echo e($val); ?>">
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
<input type="hidden" id="CustomerID" name="CustomerID" value="">
<?php endif; ?>


<?php if(request()->get('sourceoflead')): ?>
<?php $__currentLoopData = request()->get('sourceoflead'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <input type="hidden" id="sourceofleadId" name="sourceoflead[]" value="<?php echo e($val); ?>">
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
<input type="hidden" id="sourceofleadId" name="sourceoflead" value="">
<?php endif; ?>


<?php if(request()->get('category_id')): ?>
<?php $__currentLoopData = request()->get('category_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <input type="hidden" id="categoryId" name="category_id[]" value="<?php echo e($val); ?>">
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
<input type="hidden" id="categoryId" name="category_id" value="">
<?php endif; ?>


<?php if(request()->get('sub_category_id')): ?>
<?php $__currentLoopData = request()->get('sub_category_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <input type="hidden" id="subCategoryId" name="sub_category_id[]" value="<?php echo e($val); ?>">
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
<input type="hidden" id="subCategoryId" name="sub_category_id" value="">
<?php endif; ?>


<?php if(request()->get('state_id')): ?>
<?php $__currentLoopData = request()->get('state_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <input type="hidden" id="stateId" name="state_id[]" value="<?php echo e($val); ?>">
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
<input type="hidden" id="stateId" name="state_id" value="">
<?php endif; ?>


<?php if(request()->get('city_id')): ?>
<?php $__currentLoopData = request()->get('city_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <input type="hidden" id="cityId" name="city_id[]" value="<?php echo e($val); ?>">
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
<input type="hidden" id="cityId" name="city_id" value="">
<?php endif; ?>


<?php if(request()->get('area')): ?>
<?php $__currentLoopData = request()->get('area'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <input type="hidden" id="areaId" name="area[]" value="<?php echo e($val); ?>">
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
<input type="hidden" id="areaId" name="area" value="">
<?php endif; ?>
<?php if(request()->get('action')): ?>
<?php $__currentLoopData = request()->get('action'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <input type="hidden" id="actionId" name="action[]" value="<?php echo e($val); ?>">
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
<input type="hidden" id="actionId" name="action" value="">
<?php endif; ?>



<input type="hidden" id="isInternational" name="is_international" value="<?php echo e(request()->get('is_international')); ?>">



<?php if(request()->get('country_id')): ?>
<?php $__currentLoopData = request()->get('country_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <input type="hidden" id="countryId" name="country_id[]" value="<?php echo e($val); ?>">
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
<input type="hidden" id="countryId" name="country_id" value="">
<?php endif; ?>


<?php if(request()->get('region')): ?>
<?php $__currentLoopData = request()->get('region'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <input type="hidden" id="region" name="region[]" value="<?php echo e($val); ?>">
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
<input type="hidden" id="region" name="region" value="">
<?php endif; ?>

                                    <input type="hidden" id="startDate" name="start_date"
                                        value="<?php if(isset($_GET['start_date'])): ?> <?php echo e($_GET['start_date']); ?> <?php endif; ?>">
                                    <input type="hidden" id="endDate" name="end_date"
                                        value="<?php if(isset($_GET['end_date'])): ?> <?php echo e($_GET['end_date']); ?> <?php endif; ?>">
                                    <input type="submit" id="submit_export" name="submit_export" style="display:none;">
                                    <button class="btn btn-2 bg-gradient-info btn-1" data-toggle="tooltip"
                                        data-placement="left" title="Export"
                                        style="    color: white;
                                    margin-top: -66px;
                                    margin-left: 92px;">
                                        <i class="bx bxs-edit" aria-hidden="true"></i>Export Pdf
                                    </button>
                                </form>

                                <button class="btn btn-2 bg-gradient-info btn-1 importbtndata" data-toggle="modal"
                                    data-target="#exampleModal" title="import" style="margin-left: 214px;margin-top: -112px;color: white;">
                                    <i class="bx bxs-edit" aria-hidden="true"></i>Import
                                </button>

                                <button id="move-button" class="btn btn-2 bg-gradient-info btn-1" data-toggle="modal"
                                    data-target="#Modal" title="Move"
                                    style="margin-left: 25px;margin-top: -112px;color:white">
                                    <i class="bx bxs-edit" aria-hidden="true"></i>Move
                                </button>

                                <a href="<?php echo e(route('visitor.add')); ?>">
                                    <button id="add-button" class="btn btn-2 bg-gradient-info btn-1" style="margin-left: 25px;margin-top: -112px;color:white">
                                        <i class="bx bxs-edit" aria-hidden="true"></i>Add Client
                                    </button>
                                </a>

                                <button id="assignclient-button" class="btn btn-2 bg-gradient-info btn-1" data-toggle="modal"
                                    data-target="#Modal" title="Move"
                                    style="margin-left: 25px;margin-top: -112px;color:white">
                                    <i class="bx bxs-edit" aria-hidden="true"></i>Assign Client
                                </button>

                                 <a href="<?php echo e(route('visitor.map')); ?>" target="_blank">
                                    <button id="add-button" class="btn btn-2 bg-gradient-info btn-1" style="margin-left: 25px;margin-top: -112px;color:white">
                                        <i class="bx bxs-edit" aria-hidden="true"></i>Map View
                                    </button>
                                </a>

                                

                                <!-- <a href="">
                                        <button class="btn btn-2 bg-gradient-info btn-1" title="Edit"
                                        style="margin-left: 920px;margin-top: -62px;">
                                        <i class="bx bxs-edit" aria-hidden="true"></i>Edit
                                    </button>
                                    </a> -->
                                <div class="table-responsive">
                                <?php echo e($dataTable->table()); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade" id="editEmailModal" tabindex="-1" role="dialog" aria-labelledby="editEmailModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editEmailModalLabel">Update Email</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&ti ;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(route('visitor.update-email')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="id" id="modalId" class="form-control" value="">
                        <div class="form-group">
                            <label for="">Email</label>
                            <input type="text" name="email" class="form-control" id="modalEmail" value=""
                                required>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="sendEmailModal" tabindex="-1" role="dialog" aria-labelledby="sendEmailModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="sendEmailModalLabel">Select Email Type</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(route('send.email')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <input type="hidden" name="visitor_id" id="visitor_id">
                            <select class="form-control" name="email_type" id="email_type">
                                <option>Select Email</option>
                                <option value="primary">Primary Email</option>
                                <option value="followup">Follow Up Email</option>
                            </select>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary close-modal">Send Email</button>
                </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Import Modal -->
    <form method="post" name="frm_no_kids" id="frm_no_kids" class="getstarted"
        action="<?php echo e(route('import.insertexportfile')); ?>" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Import File</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <label for="">Select Team Member</label>
                        <select class="form-control custom-select" name="CustomerID">
                            <?php $__currentLoopData = $user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->CustomerID); ?>"
                                    <?php if($item->CustomerID == $item->CustomerID): ?> selected <?php endif; ?>><?php echo e($item->CustomerName); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="modal-body">
                        <label for="">Select Event</label>
                        <select class="form-control custom-select" name="event_id">
                            <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val->id); ?>" <?php if($event_id == $val->id): ?> selected <?php endif; ?>>
                                    <?php echo e($val->event_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="modal-body">
                        <a href="<?php echo e(asset('sample_new_file.xlsx')); ?>">
                            Download Sample File
                        </a>
                    </div>
                    <div class="modal-body">
                        Select File <input type="file" name="importfile" required>
                    </div>
                    <div class="modal-body" id="importbtndata">
                    <?php
                        if(session('dataInvalid')){
                            $totalData = session('totalData');
                            $dataDuplicate = session('dataDuplicate');
                            $dataInvalid = session('dataInvalid');
                    ?>
                        <p class="text-danger">Please check XLS file format, Below Records having data format issue</p>
                        <p>Total Data : <?php echo e($totalData); ?></p>
                        <p class="text-primary">Duplicate Data ( Email | Phone ): <?php echo e(count($dataDuplicate)); ?></p>
                        <p class="text-danger">Invalid Data : <?php echo e(count($dataInvalid)); ?></p>
                            <table class="table table-bordered">
                                <thead>
                                    <th>Sr No.</th>
                                    <th>Date</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                </thead>
                                <tbody>
                                    <?php

                                        for ($i=0; $i < count($dataInvalid); $i++) {
                                            $rowdata = $dataInvalid[$i];
                                            ?>
                                            <tr>
                                                <td class="text-danger"><?php echo e($rowdata['0']); ?></td>
                                                <td class="text-danger">
                                                    <?php if($rowdata['1'] != "" && $rowdata['1'] != null): ?>

                                                    <?php else: ?>
                                                        Date Field Should not be Blank
                                                    <?php endif; ?>

                                                </td>
                                                <td class="text-danger">
                                                    <?php if($rowdata['9'] != "" && $rowdata['9'] != null): ?>

                                                    <?php else: ?>
                                                        Name Field Should not be Blank
                                                    <?php endif; ?>

                                                </td>
                                                <td><?php echo e($rowdata['11']); ?></td>
                                                <td><?php echo e($rowdata['14']); ?></td>
                                            </tr>
                                            <?php
                                        }
                                    ?>
                                    <?php

                                        for ($i=0; $i < count($dataDuplicate); $i++) {
                                            $rowdata = $dataDuplicate[$i];
                                            ?>
                                            <tr>
                                                <td class="text-primary"><?php echo e($rowdata['0']); ?></td>
                                                <td class="text-primary"><?php echo e($rowdata['1']); ?></td>
                                                <td><?php echo e($rowdata['9']); ?></td>
                                                <td class="text-primary"><?php echo e($rowdata['11']); ?></td>
                                                <td class="text-primary"><?php echo e($rowdata['14']); ?></td>
                                            </tr>
                                            <?php
                                        }
                                    ?>
                                </tbody>
                            </table>
                    <?php
                        }
                    ?>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>

                </div>
            </div>
        </div>
    </form>

    <!-- Modal -->
    <div class="modal fade" id="scheduleEmailModal" tabindex="-1" role="dialog"
        aria-labelledby="scheduleEmailModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editEmailModalLabel">Schedule Email</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('visitor.set-mail')); ?>" method="get">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <input type="hidden" value="" name="event_id" id="modalEvent_id">
                        <input type="hidden" value="" name="CustomerID" id="modalCustomerID">
                        <input type="hidden" value="" name="category_id" id="modalCategoryId">
                        <input type="hidden" value="" name="sub_category_id" id="modalSubCategoryId">
                        <input type="hidden" value="" name="state_id" id="modalStateId">
                        <input type="hidden" value="" name="city_id" id="modalCityId">
                        <input type="hidden" value="" name="area" id="modalArea">
                        <input type="hidden" value="" name="is_international" id="modalIsInternational">
                        <input type="hidden" value="" name="country_id" id="modalCountryId">
                        <input type="hidden" value="" name="region" id="modalRegion">
                        <input type="hidden" value="" name="start_date" id="modalStartDate">
                        <input type="hidden" value="" name="end_date" id="modalEndDate">
                        <input type="hidden" value="" name="action" id="modalAction">
                        <input type="hidden" value="" name="sourceoflead" id="modalSourceoflead">
                        <input type="hidden" value="other" name="type">
                        <div class="form-group">
                            <label class="form-label" for="">Schedule Date</label>
                            <input type="date" value="<?php echo e(now()->format('Y-m-d')); ?>" name="schedule_date" class="form-control col-lg-10"
                                id="modalScheduleDate" value="" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Select Email Draft</label>
                            <select class="form-control col-lg-10" name="email_draft_id" id="email_draft_id" required>
                                <option value="" selected disabled>Select Email Draft</option>
                                <?php $__currentLoopData = $otherEmailDrafts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $emailDraft): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($emailDraft->id); ?>"><?php echo e($emailDraft->subject); ?> (<?php echo e($emailDraft->email_type); ?>)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-check">
                          <input type="checkbox" value="true" name="ccemail" id="ccemail" class="form-check-input">
                          <label class="form-check-label" for="ccemail">CC Email</label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Bulk Message Modal -->
    <div class="modal fade" id="sendBulkMessageModal" tabindex="-1" role="dialog"
        aria-labelledby="sendBulkMessageModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editSendBulkMessageModalLabel">Send Bulk Message</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="sendBulkMessageForm" data-url="<?php echo e(route('visitor.send-bulk-message')); ?>" method="get">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <input type="hidden" value="" name="event_id" id="sendBulkMessageModalEvent_id">
                        <input type="hidden" value="" name="CustomerID" id="sendBulkMessageModalCustomerID">
                        <input type="hidden" value="" name="category_id" id="sendBulkMessageModalCategoryId">
                        <input type="hidden" value="" name="sub_category_id" id="sendBulkMessageModalSubCategoryId">
                        <input type="hidden" value="" name="state_id" id="sendBulkMessageModalStateId">
                        <input type="hidden" value="" name="city_id" id="sendBulkMessageModalCityId">
                        <input type="hidden" value="" name="area" id="sendBulkMessageModalArea">
                        <input type="hidden" value="" name="is_international" id="sendBulkMessageModalIsInternational">
                        <input type="hidden" value="" name="country_id" id="sendBulkMessageModalCountryId">
                        <input type="hidden" value="" name="region" id="sendBulkMessageModalRegion">
                        <input type="hidden" value="" name="start_date" id="sendBulkMessageModalStartDate">
                        <input type="hidden" value="" name="end_date" id="sendBulkMessageModalEndDate">
                        <input type="hidden" value="" name="action" id="sendBulkMessageModalAction">
                        <input type="hidden" value="" name="sourceoflead" id="sendBulkMessageModalSourceoflead">
                        <input type="hidden" value="other" name="type">
                        <div class="form-group">
                            <label class="form-label">Select Template</label>
                            <select class="form-control col-lg-10" name="template_id" id="template_id" required>
                                <option value="" selected disabled>Select Template</option>
                                <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($template->id); ?>"><?php echo e($template->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button id="sendBulkMessageFormBtn" type="submit" class="btn btn-primary">Submit</button>
                    </div>
                    <div class="error" id="cf-response-message"></div>
                </form>
            </div>
        </div>
    </div>
    <!-- Image Modal -->
    <div class="modal fade" id="modalimageshow" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-x" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalimageshowTitle"></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Image</th>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0" id="showImage">
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- event list Modal -->
    <div class="modal fade" id="modalieventlist" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-x" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalieventlistTitle">Event List</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(route('visitor.update_event_name')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" value="visitor_id" name="visitor_id[]" id="modalvisitor_id">
                        <div class="table-responsive text-nowrap">
                            <table class="table" id="showevetlist">
                                <thead>
                                    <tr>
                                        <th>Event Name</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody class="table-border-bottom-0">
                                </tbody>
                            </table>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- image file Modal -->
    <div class="modal fade" id="modalimagefile" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalimagefileTitle">File List</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>File</th>
                                    <th>Description</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0" id="showfilewithimage">
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- show_visitor file Modal -->
    <div class="modal fade" id="show_visitordata" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="show_visitordataTitle">Multiple Entries</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Date</th>
                                    <th>Event Name</th>
                                    <th>TeamMember name</th>
                                    <th>Mobile Number</th>
                                    <th>Email</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0" id="show_visitor">
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- event list Modal -->
    <div class="modal fade" id="dataimportsuccess" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-x" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalieventlistTitle">Import File</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Data Imported Successfully</p>
                    <?php
                        if(session('totalData')){
                            $totalData = session('totalData');
                            $dataDuplicate = session('dataDuplicate');
                    ?>
                        <p>Total Data : <?php echo e($totalData); ?></p>
                        <p class="text-primary">Duplicate Data ( Email | Phone ) : <?php echo e(count($dataDuplicate)); ?></p>
                    <?php
                        }
                    ?>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">OK</button>
                    </div>
                </div>
            </div>
        </div>
    </div>


   <!-- event list Modal -->
    <div class="modal fade" id="modalassignclient" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-x" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalassignclientTitle">Event List</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(route('visitor.assigneventids')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" value="visitor_id" name="visitor_id[]" id="modalassignclientvisitor_id">
                        <div class="table-responsive text-nowrap">
                            <table class="table" id="showassignclientevetlist">
                                <thead>
                                    <tr>
                                        <th>Event Name</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody class="table-border-bottom-0">
                                </tbody>
                            </table>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div id="overlay">
        <div class="cv-spinner">
            <span class="spinner"></span>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <?php echo $dataTable->scripts(); ?>


    <script>

        $("#sendBulkMessageFormBtn").click(function(e) {
            e.preventDefault();
            var url = $('#sendBulkMessageForm').data('url');
            $("#overlay").fadeIn(300);
            // console.log($('#sendBulkMessageForm').serialize()); return false;
            $.ajax({
                url: url,
                type: "GET",
                data: $('#sendBulkMessageForm').serialize(),
                success: function(response) {
                    if (response) {
                        $('#cf-response-message').text(response.message);
                    }
                    setTimeout(function() {
                        $("#overlay").fadeOut(300);
                    }, 500);
                },
                error: function(data) {
                    console.log(data);
                    $('#cf-response-message').text(data.responseText);
                    setTimeout(function() {
                        $("#overlay").fadeOut(300);
                    }, 500);
                }
            });
        });


        $('#sendBulkMessageModal').on('hidden.bs.modal', function () {
            $('#sendBulkMessageModal form')[0].reset();
            $('#cf-response-message').text(' ');
        });

        function checkExportFilter(elm) {
            var type = elm.id;
            var name = $('#name').val();
            var event_name = $('#event_name').val();
            var CustomerName = $('#CustomerName').val();
            var mobile_no = $('#mobile_no').val();
            var email = $('#email').val();
            var action = $('#action').val();

            $('#data').val([name, event_name, CustomerName, mobile_no, email, action]);
            $('#submit_export').click();
        }

        function exportImages(elm) {
            var event_id = $('#event_id').val();
            var CustomerID = $('#CustomerID').val();

            window.location = "<?php echo e(url('visitor/download-images')); ?>" + '?event_id=' + event_id + '&CustomerID=' +
                CustomerID;
        }

        function selectEmailType(id) {
            $('#visitor_id').val(id);
            $('#sendEmailModal').modal('show');
        }

        function editEmail(id) {
            $('#modalEmail').val($('.btn-' + id).data('email'));
            $('#modalId').val(id);
            $('#editEmailModal').modal('show');
        }

        function setOtherEmail() {
            $('#modalEvent_id').val($('#event_id').val());
            $('#modalCustomerID').val($('#CustomerID').val());
            $('#modalCategoryId').val($('#category_id').val());
            $('#modalSubCategoryId').val($('#sub_category_id').val());
            $('#modalStateId').val($('#state_id').val());
            $('#modalCityId').val($('#city_id').val());
            $('#modalArea').val($('#area').val());
            $('#modalIsInternational').val($('#is_international').val());
            $('#modalRegion').val($('#region').val());
            $('#modalStartDate').val($('#start_date').val());
            $('#modalEndDate').val($('#end_date').val());
            $('#modalCountryId').val($('#country_id').val());
            $('#modalAction').val($('#action').val());
            $('#modalSourceoflead').val($('#sourceoflead').val());
            $('#scheduleEmailModal').modal('show');
        }

        function sendBulkMessage() {
            $('#sendBulkMessageModalEvent_id').val($('#event_id').val());
            $('#sendBulkMessageModalCustomerID').val($('#CustomerID').val());
            $('#sendBulkMessageModalCategoryId').val($('#category_id').val());
            $('#sendBulkMessageModalSubCategoryId').val($('#sub_category_id').val());
            $('#sendBulkMessageModalStateId').val($('#state_id').val());
            $('#sendBulkMessageModalCityId').val($('#city_id').val());
            $('#sendBulkMessageModalArea').val($('#area').val());
            $('#sendBulkMessageModalIsInternational').val($('#is_international').val());
            $('#sendBulkMessageModalRegion').val($('#region').val());
            $('#sendBulkMessageModalStartDate').val($('#start_date').val());
            $('#sendBulkMessageModalEndDate').val($('#end_date').val());
            $('#sendBulkMessageModalCountryId').val($('#country_id').val());
            $('#sendBulkMessageModalAction').val($('#action').val());
            $('#sendBulkMessageModalSourceoflead').val($('#sourceoflead').val());

            $('#sendBulkMessageModal').modal('show');
        }

        $(function() {
            $('.close-modal').click(function() {
                $('#sendEmailModal').modal('hide');
                $('#email_type').val();
            });
        });


        function sendMail(type) {
            $('#formType').val(type);
            $('#myform').attr('action', '<?php echo route('visitor.set-mail'); ?>');
            $('#myform').submit();
        }

        function showImage(elm) {
            var id = $(elm).attr('data-id');
            $.ajax({
                url: "<?php echo e(url('ajax/get_image')); ?>",
                type: "GET",
                data: {
                    id: id,
                },
                success: function(response) {
                    if (response) {
                        $("#showImage").html('');

                        $.each(response['data'], function(i, item) {
                            var imageUrl = item['front_image'];
                            var static_image = '../no-image.png';
                            var images = imageUrl.substring(imageUrl.indexOf('/frenzincrm_api'));

                            var html = '<tr>' + '<td>';

                            if (imageUrl && imageUrl.trim() !== '') {
                                html += '<img src="' + images +
                                    '" alt="" class="img" style="height: 240px; width: 450px">';
                            } else {
                                html += '<img src="' + static_image +
                                    '" alt="" class="img" style="height: 240px; width: 450px">';
                            }

                            html += '</td>' +
                                '</tr>';
                            // html =  `<tr>
                        //             <td>
                        //                 <img  src="` + imageUrl + `" alt=""  class="img" style="height: 240px;width:450px">
                        //             </td>
                        //         </tr>`;
                            $("#showImage").append(html);
                            $("#modalimageshow").modal('show');
                        });
                    } else {
                        alert('no data found!')
                    }
                },
                error: function(error) {
                    console.log(error);
                }
            });
        }

        function showfilewithimage(elm) {
            var mobile_number = $(elm).attr('data-mobile_number');
            $.ajax({
                url: "<?php echo e(url('ajax/get_productlist')); ?>",
                type: "GET",
                data: {
                    mobile_number: mobile_number,
                },
                success: function(response) {
                    if (response) {
                        $("#showfilewithimage").html('');
                        $.each(response['data'], function(i, item) {

                            var imageName = item.image.split('/').pop();
                            var imageNameX = item.image.split('.').pop();

                            var html = `<tr>
                        <td><strong>${item['id']}</strong></td>
                        <td>
                            <a href="${item['image']}" target="_blank" style="text-decoration: none;">
                                ${imageNameX === 'pdf' ? `<i class="far fa-file-pdf pdf-icon fa-2x" style="color:red;"></i> ${imageName}` : `<img src="${item['image']}" alt="" class="img">`}
                            </a>
                        </td>
                        <td>${item['description']}</td>
                        <td>
                            <a href="https://wa.me/${mobile_number}?text=(${item['image']})" target="_blank">
                                <i class="fab fa-whatsapp" style="font-size: 31px; color: #25D366; margin-left: 37px;"></i>
                            </a>
                        </td>
                    </tr>`;
                            $("#showfilewithimage").append(html);
                            $("#modalimagefile").modal('show');
                        });
                    } else {
                        alert('no data found!')
                    }
                },
                error: function(error) {
                    console.log(error);
                }
            });
        }

        function deletePopupvisitor(elm) {
            let id = $(elm).data('id');
            let url = $(elm).data('url');
            swal({
                title: 'Are you sure!',
                icon: 'error',
                dangerMode: true,
                buttons: true,
                confirm: "Confirm",
            }).then(function(isConfirm) {
                if (isConfirm === true) {
                    $.ajax({
                        type: 'GET',
                        url: url,
                        dataType: 'json',
                        success: function(data) {
                            location.reload(true);
                        },
                        error: function(data) {
                            console.log(data);
                        }
                    });
                }
            });
        }


        let subCategorySelected = <?php echo json_encode($sub_category_id ?? [], 15, 512) ?>;

        function fetchSubCategories(id) {
            var url = "<?php echo e(route('get_sub_categories_bulk')); ?>";
            $.ajax({
                url: url,
                type: "GET",
                data: {
                    category_id: id,
                },
                success: function(response) {
                    var options = [];
                    var rData = [];
                    rData = response.data;
                    // console.log('rData__'+rData);
                    $('#sub_category_id').html('');
                    $.each(rData, function(index, value) {
                        let selectData = '';
                        console.log('subCategory__',subCategorySelected,value);
                        options.push({
                            id: value.id,
                            text: value.name,
                            selected: subCategorySelected.includes((value.id).toString()),
                        });
                    });
                    $('#sub_category_id').val(null).trigger('select2:change');
                    $('#sub_category_id').select2('destroy');
                    $('#sub_category_id').select2({
                        data: options,
                        placeholder: $("#sub_category_id").data('placeholder'),
                    }).trigger('select2:change');
                    subCategorySelected = [];
                },
                error: function(error) {
                    console.log(error);
                }
            });
        }


        let countrySelected = <?php echo json_encode($country_id, 15, 512) ?>;

        function clearAndInitSelect2(id,data = []){
            $(id).html('');
            $(id).val(null).trigger('select2:change');
            $(id).select2('destroy');
            $(id).select2({
                data: data,
                placeholder: $(id).data('placeholder'),
            });
        }
        function fetchCountries() {
            var url = "<?php echo e(route('get_countries')); ?>";
            $.ajax({
                url: url,
                type: "GET",
                success: function(response) {
                    var options = [];
                    var rData = [];
                    rData = response.data;
                    $.each(rData, function(index, value) {
                        var selectData = '';
                        var selectedValue = countrySelected.includes(value.name);
                        options.push({
                            id: value.name,
                            text: value.name,
                            selected: selectedValue,
                        });
                    });
                    clearAndInitSelect2('#country_id',options);
                    countrySelected = [];
                },
                error: function(error) {
                    console.log(error);
                }
            });
        }

        let stateSelected = <?php echo json_encode($state_id, 15, 512) ?>;
        let stateCount = 1;
        function fetchStates(countryId,isInternational = false,firstTime = true) {
            var url = "<?php echo e(route('get_states_bulk')); ?>";
            $.ajax({
                url: url,
                type: "GET",
                data: {
                    countryId: countryId,
                },
                success: function(response) {
                    var options = [];
                    var rData = [];
                    rData = response.data;

                    if(!firstTime){
                        stateSelected = $("#state_id").val();
                        console.log('stateSelected__',stateSelected);
                    }

                    $.each(rData, function(index, value) {
                        var selectData = '';
                        options.push({
                            id: value.state,
                            text: value.state,
                            selected: stateSelected.includes((value.state).toString()),
                        });
                    });
                    clearAndInitSelect2('#state_id',options);
                    if(stateCount == 2){
                        stateSelected = [];
                    }
                    stateCount++;
                    console.log('stateSelected__',stateSelected,isInternational);

                },
                error: function(error) {
                    console.log(error);
                }
            });
        }




        let citySelected = <?php echo json_encode($city_id, 15, 512) ?>;
        function fetchCities(stateId,firstTime = true) {
            var url = "<?php echo e(route('get_cities_bulk')); ?>";
            $.ajax({
                url: url,
                type: "GET",
                data: {
                    stateId: stateId,
                },
                success: function(response) {
                    var options = [];
                    var rData = [];
                    rData = response.data;
                    // console.log('fetchCities__'+rData);
                    if(!firstTime){
                        citySelected = $("#city_id").val();
                        console.log('citySelected__',citySelected);
                    }
                    $.each(rData, function(index, value) {
                        var selectData = '';
                        var selectedValue = citySelected.includes(value.district);
                        options.push({
                            id: value.district,
                            text: value.district,
                            selected: selectedValue,
                        });
                    });
                    clearAndInitSelect2('#city_id',options);
                    citySelected = [];
                },
                error: function(error) {
                    console.log(error);
                }
            });
        }

        let areaSelected = <?php echo json_encode($area, 15, 512) ?>;
        function fetchArea(cityName,firstTime = true) {
            console.log('cityName__',cityName);
        var url = "<?php echo e(route('get_areas_bulk')); ?>";
        $.ajax({
            url: url,
            type: "GET",
            data: {
                city: cityName,
            },
            success: function(response) {
                var options = [];
                var rData = [];
                rData = response.data;
                if(!firstTime){
                    areaSelected = $("#area").val();
                }
                console.log('areaSelected__',areaSelected);
                $.each(rData, function(index, value) {
                    let selectData = '';
                    let selectedValue = areaSelected.includes(value.name);
                    options.push({
                        id: value.name,
                        text: value.name,
                        selected: selectedValue,
                    });
                });
                clearAndInitSelect2('#area',options);
                areaSelected = [];
            },
            error: function(error) {
                console.log(error);
            }
        });
    }


        function checkRegion(region) {
            console.log('region__',region);
            if (region.length > 0) {
                $('#is_international').attr('disabled', true);
                $('#country_id').attr('disabled', true);
                $('#state_id').attr('disabled', true);
                $('#city_id').attr('disabled', true);
                $('#area').attr('disabled', true);
                // clearAndInitSelect2("#country_id");
                // clearAndInitSelect2("#state_id");
                // clearAndInitSelect2("#city_id");
                // clearAndInitSelect2("#area");

            } else {
                $('#is_international').attr('disabled', false);
                $('#country_id').attr('disabled', false);
                $('#state_id').attr('disabled', false);
                $('#city_id').attr('disabled', false);
                $('#area').attr('disabled', false);
            }
        }

        function changeIsInternational(isInternational) {
            console.log('isInternational__',isInternational);
            // $('#country_id').html('<option value="all">All</option>');
            // $('#state_id').html('<option value="all">All</option>');
            // $('#city_id').html('<option value="all">All</option>');
            $('#country_id').attr('disabled', false);
            clearAndInitSelect2("#country_id");
                clearAndInitSelect2("#state_id");
                clearAndInitSelect2("#city_id");
                clearAndInitSelect2("#area");
            if (isInternational !== 'all' && isInternational !== 'false') {
                fetchCountries();
            } else if (isInternational !== 'all' && isInternational === 'false') {
                var options = [];
                var selectedValue = 'selected';
                var valueId = 99;
                var valueName = "India";
                options.push({
                    id: valueName,
                    text: valueName,
                    selected: true,
                });
                $('#country_id').val(null).trigger('select2:change');
                $('#country_id').select2('destroy');
                $('#country_id').select2({
                    data: options,
                    placeholder: $("#country_id").data('placeholder'),
                }).trigger('select2:change');
                fetchStates([valueName],true);
            }
        }
      $(document).ready(function() {
        let initSelect2Classes = ['select2-multiple-event','select2-multiple-action', 'select2-multiple-subcategory', 'select2-multiple-category', 'select2-multiple-sourceoflead', 'select2-multiple-customer', 'select2-multiple-region', 'select2-multiple-country', 'select2-multiple-state', 'select2-multiple-city', 'select2-multiple-area'];
            $(initSelect2Classes).each(function(index, value) {
                $(`.${value}`).select2({
                    placeholder: $(`.${value}`).data('placeholder'),
                });
            });
        var categoryId = <?php echo json_encode($category_id ?? [], 15, 512) ?>;
            if (categoryId.length > 0) {
                fetchSubCategories(categoryId);
            }

            var isInternational = <?php echo json_encode($is_international, 15, 512) ?>;
            changeIsInternational(isInternational);

            var countryId = <?php echo json_encode($country_id, 15, 512) ?>;
            if (countryId.length > 0) {
                fetchStates(countryId);
            }
            var stateId = <?php echo json_encode($state_id, 15, 512) ?>;
            if (stateId.length > 0) {
                fetchCities(stateId);
            }
            var cityId = <?php echo json_encode($city_id, 15, 512) ?>;
            if (cityId.length > 0) {
                fetchArea(cityId);
            }
            console.log($('meta[name="csrf-token"]').attr('content'));
            $('.token').val($('meta[name="csrf-token"]').attr('content'));

        $('#category_id').change(function() {
            var id = $(this).val();
            if (id.length > 0) {
                fetchSubCategories(id);
            }
        });
        $('#city_id').change(function() {
            var cityId = $(this).val();
            fetchArea(cityId,false);
            clearAndInitSelect2("#area");

        });
        $('#is_international').change(function() {
            var isInternational = $(this).val();
            changeIsInternational(isInternational);
        });
        $('#region').change(function() {
            var region = $(this).val();
            checkRegion(region);
        });

        $('#country_id').change(function() {
            var countryId = $(this).val();
            if (countryId.length > 0) {
                fetchStates(countryId,false,false);

            }
            clearAndInitSelect2("#state_id");
            clearAndInitSelect2("#city_id");
            clearAndInitSelect2("#area");
        });
        $('#state_id').change(function() {
            var stateId = $(this).val();
            var selectedOption = $(this).find('option:selected');
            var countryUid = selectedOption.data('country_id');
            if (stateId.length > 0) {
                // alert(selectedText);
                fetchCities(stateId,false);
            }
            clearAndInitSelect2("#city_id");
            clearAndInitSelect2("#area");
        });
        checkRegion(<?php echo json_encode($region ?? [], 15, 512) ?>);
      });
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>


    <script>
        var selectedData = [];

        function getid(elm) {

            var id = $(elm).attr('data-id');
            if (!selectedData.includes(id)) {
                selectedData.push(id);
            }
            var event_id = $(elm).attr('data-event_id');
        }
        $(document).ready(function() {
            var table = $('#showevetlist').DataTable({
                paging: true,
                searching: true
            });

            $('#move-button').click(function() {
                if (selectedData.length > 0) {
                    var jsonData = JSON.stringify(selectedData);
                    $.ajax({
                        url: "<?php echo e(url('ajax/get_eventlist')); ?>",
                        type: "GET",
                        data: {
                            id: jsonData,
                        },
                        success: function(response) {
                            if (response && response.data.length > 0) {
                                // Clear existing table data
                                table.clear();

                                // Add new data to the table
                                response.data.forEach(function(item) {
                                    table.row.add([
                                        item.event_name,
                                        '<input type="radio" name="eventid" value="' +
                                        item.id + '" required>'
                                    ]).draw();
                                });

                                // Show the modal
                                $('#modalvisitor_id').val(jsonData);
                                $("#modalieventlist").modal('show');
                            } else {
                                alert('No data found!');
                            }
                        },
                        error: function(error) {
                            console.log(error);
                        }
                    });
                }
            });

            var assignclienttable = $('#showassignclientevetlist').DataTable({
                paging: false,
                searching: true
            });

            $('#assignclient-button').click(function() {
                if (selectedData.length > 0) {
                    var jsonData = JSON.stringify(selectedData);
                    $.ajax({
                        url: "<?php echo e(url('ajax/get_eventlist')); ?>",
                        type: "GET",
                        data: {
                            id: jsonData,
                        },
                        success: function(response) {
                            if (response && response.data.length > 0) {
                                // Clear existing table data
                                assignclienttable.clear();

                                // Add new data to the table
                                response.data.forEach(function(item) {
                                    assignclienttable.row.add([
                                        item.event_name,
                                        '<input type="checkbox" name="event_id[]" value="' +
                                        item.id + '">'
                                    ]).draw();
                                });

                                // Show the modal
                                $('#modalassignclientvisitor_id').val(jsonData);
                                $("#modalassignclient").modal('show');
                            } else {
                                alert('No data found!');
                            }
                        },
                        error: function(error) {
                            console.log(error);
                        }
                    });
                }
            });

        });

        function show_visitor(elm) {
            var id = $(elm).attr('data-id');
            var email = $(elm).attr('data-email');
            var mobile_no = $(elm).attr('data-mobile_no');

            $.ajax({
                url: "<?php echo e(url('ajax/get_visitorlist_id')); ?>",
                type: "GET",
                data: {
                    id: id,
                    email: email,
                    mobile_no: mobile_no,
                },
                success: function(response) {
                    if (response) {
                        $("#show_visitor").html('');
                        $.each(response['data'], function(i, item) {
                            var visitedDate = moment(item['visited_date'], 'YYYY-MM-DD HH:mm:ss');
                            var detailUrl = "<?php echo e(route('visitor.detail', ['id' => '__ID__'])); ?>".replace('__ID__', item['id']);
                            if (visitedDate.isValid()) {
                                var formattedVisitedDate = visitedDate.format('D/M/Y');
                            } else {
                                var formattedVisitedDate = '';
                            }

                            var deleteUrl = "<?php echo e(route('visitor.Multiple_Entries_destroy', ':id')); ?>";
                            deleteUrl = deleteUrl.replace(':id', item['id']);

                            var html = `<tr>
                            <td> <a href="${detailUrl}"">
                                  ${item['id']}
                                </a></td>
                            <td>${formattedVisitedDate}</td>
                            <td>${item['event_name']}</td>
                            <td>${item['CustomerName']}</td>
                            <td>${item['mobile_no'] || '-'}</td>
                            <td>${item['email'] || '-'}</td>
                            <td>

                                <a data-toggle="modal" data-target="#deletePopup" data-url="${deleteUrl}"  data-id="${item['id']}"
                                    onclick="deletePopupvisitor_Multiple(this)">
                                    <button class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="right" title="Delete " style="margin-top: 10px;margin-left: 9px;">
                                        <i class="fas fa-trash" aria-hidden="true"></i>
                                    </button>
                                </a>
                            </td>
                        </tr>`;
                            $("#show_visitor").append(html);
                            $("#show_visitordata").modal('show');
                        });
                    } else {
                        alert('no data found!')
                    }
                },
                error: function(error) {
                    console.log(error);
                }
            });
        }

        function deletePopupvisitor_Multiple(elm) {
            let id = $(elm).data('id');
            let url = $(elm).data('url');
            swal({
                title: 'Are you sure!',
                icon: 'error',
                dangerMode: true,
                buttons: true,
                confirm: "Confirm",
            }).then(function(isConfirm) {
                if (isConfirm === true) {
                    $.ajax({
                        type: 'GET',
                        url: url,
                        dataType: 'json',
                        success: function(data) {
                            location.reload(true);
                        },
                        error: function(data) {
                            console.log(data);
                        }
                    });
                }
            });
        }

        // $('#move-button').click(function() {
        //     if(selectedData != ''){
        //         var jsonData = JSON.stringify(selectedData);
        //         $.ajax({
        //             url: "<?php echo e(url('ajax/get_eventlist')); ?>",
        //             type: "GET",
        //             data: {
        //                 id: jsonData,
        //             },
        //             success: function(response) {
        //                 if (response) {
        //                     $("#showevetlist").html('');
        //                     $.each(response['data'], function(i, item) {
        //                         html =  `<tr>
    //                                     <td>
    //                                         ` + item['event_name'] + `
    //                                     </td>
    //                                     <td>
    //                                         <input type="radio" name="eventid"  id="event_name" value=" ` + item['id'] + `" required>
    //                                     </td>
    //                                 </tr>`;
        //                         $("#showevetlist").append(html);
        //                         $('#modalvisitor_id').val(jsonData);
        //                         $("#modalieventlist").modal('show');
        //                     });
        //                     table.draw();
        //                 } else {
        //                     alert('no data found!')
        //                 }
        //             },
        //             error: function(error) {
        //                 console.log(error);
        //             }
        //         });
        //     }

        // });

        // Visit data Modal
        $(document).on("click", ".sendEmail", function() {
            // alert('dsfsdf');
            $('.sendEmail').prop('disabled', true);
            const modal = $(this).data('modal')
            const Url = $(this).data('url')
            const event_id = $(this).data('event_id')
            const visitor_id = $(this).data('visitor_id')
            const visit_data_id = $(this).data('visit_data_id')

            if ((Url !== undefined && Url !== null) && (modal !== undefined && modal !== null)) {

                $.ajax({
                    type: "GET",
                    url: Url,
                    dataType: "json",
                    cache: false,
                    data: {
                        event_id: event_id,
                        visitor_id: visitor_id,
                        visit_data_id: visit_data_id
                    },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        $('.sendEmail').prop('disabled', false);
                        $('#ajaxModalHtml').html(response.modalHtml)
                        $('#' + modal).modal('show')
                    },
                    error: function(error) {
                        $('.sendEmail').prop('disabled', false);
                        console.log('something went wrong');
                    }
                });
            }
        });
        // Visit data Modal End

        <?php
            if(session('dataInvalid')){
        ?>
            $('#exampleModal').modal('show');
        <?php

            }
        ?>

        $('.importbtndata').click(function() {
            $('#importbtndata').html('');
        });
        <?php
            if(session('dataImported')){
            ?>
                $('#dataimportsuccess').modal('show');
            <?php

            }
        ?>

    </script>

    <?php $__env->stopPush(); ?>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u974978517/domains/arrowmedicalproducts.com/public_html/frenzincrm/resources/views/visitor/index.blade.php ENDPATH**/ ?>