<?php $__env->startSection('content'); ?>
<style>
.class-link {
    color: #6cc417;
    text-decoration: none;
}

.class-link:hover {
    color: #ffbb00;
}
#cke_notifications_area_technical_specification{
    display: none !important;
}
.ck-editor__editable {
    min-height: 200px !important;
}
</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Add Product </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('product.list')); ?>">Product List</a></li>
                        <li class="breadcrumb-item active">Add Product</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" class="ajaxModalForm" action="<?php echo e(route('product.addproductstore')); ?>" name="form"
                                enctype="multipart/form-data" data-redirect="<?php echo e(route('product.list')); ?>">
                                <?php echo csrf_field(); ?>
                                <input type='hidden' name="id" value="">
                                <div class="form-group">
                                    <label for="">Product Name</label>
                                    <input type="text" name="name" class="form-control" id="" placeholder="Product Name"
                                        value="" >
                                        <span class="text-danger error-text name-error common-ajax-error"></span>
                                </div>
                                <?php if(Session::get('productqr') == 1): ?>
                                <div class="form-group">
                                    <div class="form-check">
                                      <input class="form-check-input" type="checkbox" id="qrcodecheck" name="qrcodecheck">
                                      <label class="form-check-label" for="qrcodecheck">Generate QR Code</label>
                                    </div>
                                </div>
                                <div class="form-group displayIfQrRequired">
                                    <label for="">Product Code</label>
                                    <input type="text" name="product_code" class="form-control" id="" placeholder="Product Code"
                                        value="" >
                                        <span class="text-danger error-text product_code-error common-ajax-error"></span>

                                </div>
                                <div class="form-group displayIfQrRequired">
                                    <label for="">Product Message</label>
                                    <textarea name="product_message" class="form-control" id="" placeholder="Product Message" rows="15"></textarea>
                                </div>
                                <?php endif; ?>
                                <div class="form-group">
                                    <div class="form-check">
                                      <input class="form-check-input" type="checkbox" id="quotationcheck">
                                      <label class="form-check-label" for="quotationcheck">Quotation</label>
                                    </div>
                                </div>
                                <div id="quotation_data" style="display:none;">
                                    <div class="form-group">
                                        <label for="">HSN Code</label>
                                        <input type="text" name="hsn_code" class="form-control" id="" placeholder="HSN Code"
                                            value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="">Price</label>
                                        <input type="number" name="price" class="form-control" id="" placeholder="Price"
                                            value="">
                                    </div>

                                    <div class="form-group">
                                        <label for="">GST(%)</label>
                                        <input type="number" name="gst" class="form-control" id="" placeholder="GST(%)"
                                            value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="technical_specification">Technical Specification</label>
                                        <textarea class="editor" cols="10" rows="10" name="technical_specification" id="technical_specification"></textarea>
                                    </div>
                                    <div class="form-group">
                                        <label for="">Quotation Image</label>
                                        <input type="file" name="quotation_image" class="form-control" id="quotation_image"  accept="image/*">
                                    </div>
                                </div>
                                <div id="with_image">
                                    <div class="row" style="align-items: center;">
                                        <div class="col-md-10 dynamic-field" id="dynamic-field-1">
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <div class="staresd">
                                                        <div class="form-group">
                                                            <label for=""><i class="fa fa-image"></i> Upload
                                                                Brochure</label>
                                                            <input type="file" name="image[]" id="image">
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="">Brochure Description</label>
                                                            <input type="text" name="description[]" class="form-control" id=""
                                                                placeholder="Description" value="" >
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-2 mt-30 append-buttons">
                                            <div class="clearfix">
                                                <button type="button" id="add-button"
                                                    class="btn btn-secondary float-left text-uppercase shadow-sm"><i
                                                        class="fa fa-plus fa-fw"></i>
                                                </button>
                                                <button type="button" id="remove-button"
                                                    class="btn btn-secondary float-left text-uppercase ml-1"
                                                    disabled="disabled"><i class="fa fa-minus fa-fw"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <button type="submit" id="submit-button" class="btn btn-primary">  <span class="submit-text">Submit</span>
                                        <div class="spinner-border text-light submit-loader" role="status"
                                            style="width:16px;height:16px;display:none;">
                                            <span class="visually-hidden"></span>
                                        </div></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->startPush('scripts'); ?>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="<?php echo e(asset('js/commonAjax.js')); ?>"></script>
<script>

// $(document).ready(function() {
//     var buttonAdd = $("#add-button");
//     var buttonRemove = $("#remove-button");
//     var className = ".dynamic-field";
//     var count = 0;
//     var field = "";
//     var maxFields = 50;

//     function totalFields() {
//         return $(className).length;
//     }

//     function addNewField() {
//         count = totalFields() + 1;
//         field = $("#dynamic-field-1").clone();
//         field.attr("id", "dynamic-field-" + count);
//         field.children("label").text("Field " + count);
//         field.find("input").val("");
//         $(className + ":last").after($(field));
//     }

//     function removeLastField() {
//         if (totalFields() > 1) {
//             $(className + ":last").remove();
//         }
//     }

//     function enableButtonRemove() {
//         if (totalFields() === 2) {
//             buttonRemove.removeAttr("disabled");
//             buttonRemove.addClass("shadow-sm");
//         }
//     }

//     function disableButtonRemove() {
//         if (totalFields() === 1) {
//             buttonRemove.attr("disabled", "disabled");
//             buttonRemove.removeClass("shadow-sm");
//         }
//     }

//     function disableButtonAdd() {
//         if (totalFields() === maxFields) {
//             buttonAdd.attr("disabled", "disabled");
//             buttonAdd.removeClass("shadow-sm");
//         }
//     }

//     function enableButtonAdd() {
//         if (totalFields() === (maxFields - 1)) {
//             buttonAdd.removeAttr("disabled");
//             buttonAdd.addClass("shadow-sm");
//         }
//     }

//     buttonAdd.click(function() {
//         addNewField();
//         enableButtonRemove();
//         disableButtonAdd();
//     });

//     buttonRemove.click(function() {
//         removeLastField();
//         disableButtonRemove();
//         enableButtonAdd();
//     });
// });
</script>
<script>

    $(document).ready(function() {
        // Handle file input change event for dynamically added fields
        $(document).on('change', 'input[type="file"]', function() {
            var fileInput = $(this);
            var descriptionInput = fileInput.closest('.staresd').find('input[name="description[]"]');

            var files = fileInput.prop('files');
            var descriptions = [];

            for (var i = 0; i < files.length; i++) {
                var fileName = files[i].name;
                descriptions.push(fileName);
            }

            descriptionInput.val(descriptions.join(', '));
        });
        $(document).on("change","#qrcodecheck",function(){
            if($(this).is(':checked')){
                $('.displayIfQrRequired').show();
            }else{
                $('.displayIfQrRequired').hide();
            }
        });
        if($('#qrcodecheck').is(':checked')){
            $('.displayIfQrRequired').show();
        }else{
            $('.displayIfQrRequired').hide();
        }
        // Add and remove dynamic fields
        var dynamicFieldCounter = 1;

        $('#add-button').click(function() {
            dynamicFieldCounter++;
            var dynamicField = $('#dynamic-field-1').clone();
            dynamicField.attr('id', 'dynamic-field-' + dynamicFieldCounter);

            dynamicField.find('input[name="image[]"]').val(''); // Clear image input
            dynamicField.find('input[name="description[]"]').val(''); // Clear description input

            $('.dynamic-field').last().after(dynamicField);
            $('#remove-button').prop('disabled', false);
        });

        $('#remove-button').click(function() {
            if (dynamicFieldCounter > 1) {
                $('#dynamic-field-' + dynamicFieldCounter).remove();
                dynamicFieldCounter--;

                // Disable remove button if only one dynamic field left
                if (dynamicFieldCounter === 1) {
                    $(this).prop('disabled', true);
                }
            }
        });
    });
    $(document).ready(function() {
        // CKEDITOR.replace( 'content' );
        CKEDITOR.replace('technical_specification', {
            height: 200
        });

        $('#quotationcheck').on('change', function() {
            if ($(this).is(':checked')) {
                // Perform actions when checked
                $('#quotation_data').show();
            } else {
                // Perform actions when unchecked
                $('#quotation_data').hide();
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u974978517/domains/arrowmedicalproducts.com/public_html/frenzincrm/resources/views/product/addproduct.blade.php ENDPATH**/ ?>