<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class RunQueueWorker extends Command
{
    protected $signature = 'queue:custom-work';
    protected $description = 'Process the queue jobs using the database connection';

    public function handle()
    {
         // Set the queue connection dynamically
        config(['queue.default' => 'database']);

        $this->info('Starting queue worker with database connection...');
        
        // Call the queue:work command
        $this->call('queue:work', ['--stop-when-empty' => true]);

        $this->info('Queue worker completed.');
    }
}
