<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Category;
use App\Models\SubCategory;
use Illuminate\Support\Facades\Validator;

class CategoryController extends Controller
{
    public $successStatus = 200;
    public $failureStatus = 203;

    public function __construct()
    {
        $this->category = new Category();
    }

    public function store(Request $request)
    {
        DB::beginTransaction();
        try {

            $validator = Validator::make($request->all(), [
                'name' => 'required|unique:category,name',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => false,
                    'data' => [],
                    'msg' => $validator->errors(),
                ], 400);
            }
            
            $categoryid = $this->category->insertcategory($request->all());

            DB::commit();
            if ($categoryid) {
                $category = Category::where('id', $categoryid)->first();
                return response()->json(
                    [
                        'status' => true,
                        'data' => $category,
                        'message' => "Data fetched successfully!",
                    ],
                    $this->successStatus
                );
            } else {
                return response()->json(
                    [
                        'status' => false,
                        'message' => "Something went wrong please try again later!",
                    ],
                    $this->failureStatus
                );
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }
    public function update(Request $request)
    {
        DB::beginTransaction();
        try {

            $validator = Validator::make($request->all(), [
                'name' => 'required|unique:category,name,'.$request->id.',id',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => false,
                    'data' => [],
                    'msg' => $validator->errors(),
                ], 400);
            }

            $categoryid = $this->category->updateCategory($request->all());

            DB::commit();
            if ($categoryid) {
                $category = Category::where('id', $categoryid)->first();
                return response()->json(
                    [
                        'status' => true,
                        'data' => $category,
                        'message' => "Data fetched successfully!",
                    ],
                    $this->successStatus
                );
            } else {
                return response()->json(
                    [
                        'status' => false,
                        'message' => "Something went wrong please try again later!",
                    ],
                    $this->failureStatus
                );
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
        
    }


    public function addEditSubCategory(Request $request)
    {
        DB::beginTransaction();
        try {

            $validator = Validator::make($request->all(), [
                'fk_category_id' => 'required',
                'name' => 'required|unique:sub_categories,name,'.$request->id.',id',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => false,
                    'data' => [],
                    'msg' => $validator->errors(),
                ], 400);
            }
            
            $categoryid = $this->category->insertOrUpdatesubcategory($request->all());

            DB::commit();
            if ($categoryid) {
                $category = SubCategory::where('id', $categoryid)->first();
                return response()->json(
                    [
                        'status' => true,
                        'data' => $category,
                        'message' => "Data fetched successfully!",
                    ],
                    $this->successStatus
                );
            } else {
                return response()->json(
                    [
                        'status' => false,
                        'message' => "Something went wrong please try again later!",
                    ],
                    $this->failureStatus
                );
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }


    public function subCategoryList(Request $request)
    {
        try{

        $validator = Validator::make($request->all(), [
            'fk_category_id' => 'required|exists:category,id',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'data' => [],
                'msg' => $validator->errors(),
            ], 400);
        }

        $sub_categories = SubCategory::where('fk_category_id', $request->fk_category_id)->get();

        if(count($sub_categories) == 0){
            return response()->json(
                [
                    'status' => false,
                    'data'=>[],
                    'message' => "No Sub Category Found",
                ],
                $this->failureStatus
            );
        }

        return response()->json(
            [
                'status' => true,
                'data' => $sub_categories,
                'message' => "Data fetched successfully!",
            ],
            $this->successStatus
        );
           
       
            
        } catch (\Throwable $th) {
           
            throw $th;
        }
    }

    public function categoryDelete(Request $request){

        $validator = Validator::make($request->all(), [
            'id' => 'required|exists:category,id',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'data' => [],
                'msg' => $validator->errors(),
            ], 400);
        }
 
        Category::destroy($request->id);

        return response()->json(
            [
                'status' => true,
                'message' => "Category Deleted Successfully",
            ],
            $this->successStatus
        );
    }

    public function subCategoryDelete(Request $request){
        
        $validator = Validator::make($request->all(), [
            'id' => 'required|exists:sub_categories,id',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'data' => [],
                'msg' => $validator->errors(),
            ], 400);
        }

        SubCategory::destroy($request->id);

        return response()->json(
            [
                'status' => true,
                'message' => "Sub Category Deleted Successfully",
            ],
            $this->successStatus
        );
    }
}
