<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\SourceOfLead;
use App\Models\SubCategory;
use Illuminate\Support\Facades\Validator;

class SourceOfLeadController extends Controller
{
    public $successStatus = 200;
    public $failureStatus = 203;

    public function __construct()
    {

    }

    public function list(Request $request)
    {
        $SourceOfLead = SourceOfLead::orderBy('updated_at')->get();

        if($SourceOfLead)
        {
            return response()->json([
                'status' => true,
                'data' => $SourceOfLead
            ]);
        }
        else
        {
            return response()->json([
                'status' => false,
                'data' => [],
                'msg' => 'Source Of Lead Data Not Found'
            ], 201);
        }
    }

}
