<?php
// NEW UPDATES OF CUSTOMERS WILL BE NOW USERS IN USERCONTROLLER
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Visitor;
use App\Models\User;
use App\Models\CustomerEmail;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use App\Models\Template;
use App\Models\WhatsappLog;
use App\Models\WhatsappReplies;
use GuzzleHttp\Client;
use GuzzleHttp\Promise;
use GuzzleHttp\Exception\RequestException;
use App\Models\Sendpush;
use Illuminate\Support\Facades\Http;

class TemplateController extends Controller
{

    public function whatsAppTempletes()
    {
        $templates = DB::table('templates')->get();

        if (count($templates) > 0) {
            return response()->json([
                'status' => true,
                'data' => $templates
            ]);
        } else {
            return response()->json([
                'status' => false,
                'data' => [],
                'msg' => 'Templates Not Found'
            ], 201);
        }
    }


  public function get_recent_whatsapp_replies(Request $request)
    {

        $templates = DB::table('whatsapp_replies')
        ->join('visitors', 'whatsapp_replies.visitor_id', '=', 'visitors.id')
        ->select(
            'whatsapp_replies.*',
            'visitors.indiamart_query_id',
            'visitors.name',
            'visitors.event_id',
            'visitors.customer_id',
            'visitors.zoho_id',
            'visitors.company_name',
            'visitors.website',
            'visitors.mobile_no',
            'visitors.mobile_no2',
            'visitors.mobile_no3',
            'visitors.email',
            'visitors.email2',
            'visitors.state',
            'visitors.city',
            'visitors.address',
            'visitors.designation',
            'visitors.category',
            'visitors.follow_up_time',
            'visitors.action',
            'visitors.remarks',
            'visitors.qrcodevalue',
            'visitors.attended_by',
            'visitors.rating',
            'visitors.audio_file',
            'visitors.front_image',
            'visitors.back_image',
            'visitors.visited_date',
            'visitors.pincode',
            'visitors.lat',
            'visitors.lng',
            'visitors.event_ids',
            'visitors.is_international',
            'visitors.monthly_requirement',
            'visitors.sub_category',
            'visitors.country_code',
            'visitors.address_country_code',
           
            DB::raw("IF(whatsapp_replies.created_at > ?, true, false) as unread")
        )
        ->whereIn('whatsapp_replies.id', function ($query) use ($request) {
        $query->selectRaw('MAX(id)')
            ->from('whatsapp_replies')
            ->groupBy('visitor_id');
        })
        ->orderBy('whatsapp_replies.created_at', 'desc')
        //->groupBy('whatsapp_replies.visitor_id')

        ->setBindings([$request->last_message_time], 'select')
        ->paginate(100);

    return response()->json([
        'status' => true,
        'data' => $templates
    ]);

    }

    

    public function get_single_whatsapp_replies(Request $request)
    {

        $sentMessages = DB::table('whatsapp_logs')
        ->leftJoin('templates', function ($join) {
            $join->on('whatsapp_logs.template_id', '=', 'templates.id')
                 ->where('whatsapp_logs.template_id', '!=', 0);
        })
        ->select(
            'whatsapp_logs.id',
            'whatsapp_logs.message',
            'whatsapp_logs.visitor_id',
            'whatsapp_logs.created_at',
            DB::raw("'sent' as message_type"),
            'templates.name as template_name' // Get template name if template_id is not zero
        )
        ->where('whatsapp_logs.visitor_id', $request->visitor_id);

        $replies = DB::table('whatsapp_replies')
            ->select(
                'whatsapp_replies.id',
                'whatsapp_replies.reply as message',
                'whatsapp_replies.visitor_id',
                'whatsapp_replies.created_at',
                DB::raw("'received' as message_type"),
                DB::raw("null as template_name") // No template name for replies, so set as null
            )
            ->where('whatsapp_replies.visitor_id', $request->visitor_id);

        $conversation = $sentMessages
            ->unionAll($replies)
            ->orderBy('created_at', 'asc')
            ->get();

        return response()->json([
            'status' => true,
            'data' => $conversation
        ]);

    }

    public function send_whatsapp_test_message(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'mobile_number' => 'required',
            'template_id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'msg' => $validator->errors(),
            ], 400);
        }

        $whatsappConfig = DB::table('whatsapp_configs')->first();
        if (empty($whatsappConfig)) {
            return response()->json([
                "status" => false,
                "msg" => 'Message could not be sent because config data not found!'
            ]);
        }

        $template = Template::where('id', $request->template_id)->first();
        $mobile_number = $request->mobile_number;
        if ($whatsappConfig) {
            $sendTestMessageUrl = 'https://graph.facebook.com/v21.0/' . $whatsappConfig->phone_id . '/messages';
            if ($template->file_type) {
                if ($template->file_type == 'image') {
                    $data = [
                        "messaging_product" => "whatsapp",
                        "to" => $mobile_number,
                        "type" => "template",
                        "template" => [
                            "name" =>  $template->name,
                            "language" => [
                                "code" => "en"
                            ],
                            "components" => [
                                [
                                    "type" => "header",
                                    "parameters" => [
                                        [
                                            "type" => "image",
                                            "image" => [
                                                "id" => $template->whatsapp_file_id
                                            ]
                                        ]
                                    ]
                                ]
                            ]
                        ]
                    ];
                } else {
                    $data = [
                        "messaging_product" => "whatsapp",
                        "to" => $mobile_number,
                        "type" => "template",
                        "template" => [
                            "name" =>  $template->name,
                            "language" => [
                                "code" => "en"
                            ],
                            "components" => [
                                [
                                    "type" => "header",
                                    "parameters" => [
                                        [
                                            "type" => "DOCUMENT",
                                            "document" => [
                                                "id" => $template->whatsapp_file_id
                                            ]
                                        ]
                                    ]
                                ]
                            ]
                        ]
                    ];
                }
            } else {
                $data = [
                    "messaging_product" => "whatsapp",
                    "to" => $mobile_number,
                    "type" => "template",
                    "template" => [
                        "name" =>  $template->name,
                        "language" => [
                            "code" => "en"
                        ]
                    ]
                ];
            }
            $ch = curl_init($sendTestMessageUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'Authorization: Bearer ' . $whatsappConfig->token
            ]);
            $sendTestMessageResponse = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            $data = json_decode($sendTestMessageResponse ,true);
            
             // Check if the 'messages' key exists and has a valid value
             if (isset($data['messages']) && !empty($data['messages'][0])) {
            // Extract the necessary information
            $messageId = $data['messages'][0]['id'];
            $messageStatus = $data['messages'][0]['message_status'];

            // Get the wa_id from the contacts array
            $wa_id = $data['contacts'][0]['wa_id'] ?? null;

            
        
            // Prepare data for logging
            $requestData = [
                'user_id' => auth()->id(),
                'visitor_id' => 0,
                'template_id' => $request->template_id,
                'mobile' => $wa_id ?? $mobile_number,
                'wamid' => $messageId,
                'status' => $messageStatus,
            ];
        
            // Save to WhatsappLog only if the conditions are met
            WhatsappLog::create($requestData);
            }
            else
            {
             // Prepare data for logging
            $requestData = [
                'user_id' => auth()->id(),
                'visitor_id' => 0,
                'template_id' => $request->template_id,
                'mobile' => $mobile_number,
                'wamid' => json_encode($data)
            ];
             // Save to WhatsappLog only if the conditions are met
            //WhatsappLog::create($requestData);

            }


            return response()->json([
                "status" => true,
                "msg" => 'Message Send to whatsApp Successfully!'
            ]);
        }

        return response()->json([
            "status" => false,
            "msg" => 'Message could not be sent because error while send message!'
        ]);
    }


    public function send_whatsapp_single_message(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'mobile_number' => 'required',
            'message' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'msg' => $validator->errors(),
            ], 400);
        }

        $whatsappConfig = DB::table('whatsapp_configs')->first();
        if (empty($whatsappConfig)) {
            return response()->json([
                "status" => false,
                "msg" => 'Message could not be sent because config data not found!'
            ]);
        }

        $mobile_number = $request->mobile_number;
        if ($whatsappConfig) {
            $sendTestMessageUrl = 'https://graph.facebook.com/v21.0/' . $whatsappConfig->phone_id . '/messages';
            
                $data = [
                    "messaging_product" => "whatsapp",
                    "to" => $mobile_number,
                    "type" => "text",
                    "text" => [
                        "preview_url" =>  false,
                        "body" => $request->message
                    ]
                ];
            
            $ch = curl_init($sendTestMessageUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'Authorization: Bearer ' . $whatsappConfig->token
            ]);
            $sendTestMessageResponse = curl_exec($ch);
            //echo "test tset ".$sendTestMessageResponse;
             $this->logWrite($sendTestMessageResponse);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            $data = json_decode($sendTestMessageResponse ,true);
            
             // Check if the 'messages' key exists and has a valid value
             if (isset($data['messages']) && !empty($data['messages'][0])) 
             {
            // Extract the necessary information
            $messageId = $data['messages'][0]['id'];
            if(isset($data['messages'][0]['message_status']))
            {
             $messageStatus = $data['messages'][0]['message_status'];
            }
           

            // Get the wa_id from the contacts array
            $wa_id = $data['contacts'][0]['wa_id'] ?? null;

            
        
            // Prepare data for logging
            $requestData = [
                'user_id' => auth()->id(),
                'visitor_id' => $request->visitor_id,
                'template_id' => 0,
                'mobile' => $wa_id ?? $mobile_number,
                'wamid' => $messageId,
                'message' => $request->message,
                'status' => $messageStatus??"",
            ];
        
            // Save to WhatsappLog only if the conditions are met
            WhatsappLog::create($requestData);
            }
            


            return response()->json([
                "status" => true,
                "msg" => 'Message Send to whatsApp Successfully!'
            ]);
        }

        return response()->json([
            "status" => false,
            "msg" => 'Message could not be sent because error while send message!'
        ]);
    }



    /// USING PROMISES...
    public function send_whatsapp_bulk_message_old(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'visitorID' => 'required',
            'template_id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'msg' => $validator->errors(),
            ], 400);
        }
       
        $whatsappConfig = DB::table('whatsapp_configs')->first();
        if (empty($whatsappConfig)) {
            return response()->json([
                "status" => false,
                "msg" => 'Message could not be sent because config data not found!'
            ]);
        }

        $visitorIds = explode(',', $request->visitorID);
        if (count($visitorIds) == 0) {
            return response()->json([
                'status' => false,
                'msg' => 'Visitor Not Found'
            ], 201);
        }
        
        $client = new Client();
        $promises = [];

        $template = Template::where('id', $request->template_id)->first();
        if (!$template) {
            return response()->json([
                'status' => false,
                'msg' => 'Template not found'
            ], 404);
        }
        
        $messageData = $this->prepareMessageData($template);
        
        foreach ($visitorIds as $visitorId) {
            $visitor = Visitor::where('id', $visitorId)->first();
            if ($visitor) {
                $visitorNumber = $visitor->mobile_no;
                if (!empty($visitorNumber)) {                 
                    $messageData['to'] = $visitorNumber;
                
                    $promises[] = $client->postAsync('https://graph.facebook.com/v21.0/' . $whatsappConfig->phone_id . '/messages', [
                        'json' => $messageData,
                        'headers' => [
                            'Content-Type' => 'application/json',
                            'Authorization' => 'Bearer ' . $whatsappConfig->token
                        ]
                    ])
                        ->then(
                            function ($response) use ($visitor, $request) { 
                            
                                $data = json_decode($response->getBody() ,true);


                                $this->logWhatsappMessage($visitor, $request , $data);
                                return [
                                    'status' => true,
                                    'msg' => 'Message sent to ' . $visitor->mobile_no
                                ];
                            },
                            function (RequestException $e) {
                                return [
                                    'status' => false,
                                    'msg' => 'Error sending message: ' . $e->getMessage()
                                ];
                            }
                        );
                }
            }
        }
        
        $results = Promise\Utils::settle($promises)->wait();
        // $successMessages = [];
        // $errorMessages = [];

        // foreach ($results as $result) {
        //     if ($result['state'] === 'fulfilled') {
        //         $successMessages[] = $result['value'];
        //     } else {
        //         $errorMessages[] = $result['reason'];
        //     }
        // }

        return response()->json([
            'status' => true,
            'msg' => 'Messages Send Successfully!',          
        ]);
    }




    /// WITH QUEUE
    public function send_whatsapp_bulk_message(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'visitorID' => 'required',
            'template_id' => 'required',
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'msg' => $validator->errors(),
            ], 400);
        }
    
        $whatsappConfig = DB::table('whatsapp_configs')->first();
        if (empty($whatsappConfig)) {
            return response()->json([
                'status' => false,
                'msg' => 'Message could not be sent because config data not found!',
            ]);
        }
    
        $visitorIds = explode(',', $request->visitorID);
        if (count($visitorIds) == 0) {
            return response()->json([
                'status' => false,
                'msg' => 'Visitor Not Found',
            ], 201);
        }
    
        $whatsappCountsData = [
            'user_id' => auth()->id(),         
            'template_id' => $request->template_id,
            'sent_count' => count($visitorIds),
            'created_at' => now(),
            'updated_at' => now()
        ];
        
        $whatsappCountId = DB::table('whatsapp_batch')->insertGetId($whatsappCountsData);

        foreach ($visitorIds as $visitorId) {
            // Dispatch a job for each visitor
            \App\Jobs\SendWhatsAppMessageJob::dispatch($visitorId, $request->template_id , $whatsappConfig,$whatsappCountId);
        }
     
       // $baseUrl = env('APP_URL');
       // $url = "{$baseUrl}/frenzincrm_api_dev/public/api/run-queue";
       // $this->nonBlockingCurlWithCurl($url);

        return response()->json([
            'status' => true,
            'msg' => 'Messages queued for sending!', 
        ]); 
    }

    function nonBlockingCurlWithCurl($url)
    {
        $ch = curl_init($url);
    
        // Set curl options
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 1); // Timeout after 1 second
        curl_setopt($ch, CURLOPT_FORBID_REUSE, true);
        curl_setopt($ch, CURLOPT_FRESH_CONNECT, true);
    
        // Execute curl request
        curl_exec($ch);
        curl_close($ch);
    }

    private function prepareMessageData($template)
    {       
        if ($template->file_type) {
            if ($template->file_type == 'image') {
                return [
                    "messaging_product" => "whatsapp",
                    "type" => "template",
                    "template" => [
                        "name" => $template->name,
                        "language" => ["code" => "en"],
                        "components" => [
                            [
                                "type" => "header",
                                "parameters" => [
                                    ["type" => "image", "image" => ["id" => $template->whatsapp_file_id]]
                                ]
                            ]
                        ]
                    ]
                ];
            } else {
                return [
                    "messaging_product" => "whatsapp",
                    "type" => "template",
                    "template" => [
                        "name" => $template->name,
                        "language" => ["code" => "en"],
                        "components" => [
                            [
                                "type" => "header",
                                "parameters" => [
                                    ["type" => "DOCUMENT", "document" => ["id" => $template->whatsapp_file_id]]
                                ]
                            ]
                        ]
                    ]
                ];
            }
        } else {
            return [
                "messaging_product" => "whatsapp",
                "type" => "template",
                "template" => [
                    "name" => $template->name,
                    "language" => ["code" => "en"]
                ]
            ];
        }
    }



    private function logWhatsappMessage($visitor, $request , $data)
    {

      // Check if the 'messages' key exists and has a valid value
        if (isset($data['messages']) && !empty($data['messages'][0])) {
            // Extract the necessary information
            $messageId = $data['messages'][0]['id'];
            $messageStatus = $data['messages'][0]['message_status'];

            // Get the wa_id from the contacts array
            $wa_id = $data['contacts'][0]['wa_id'] ?? null;
        
            // Prepare data for logging
            $requestData = [
                'user_id' => auth()->id(),
                'visitor_id' => $visitor->id,
                'template_id' => $request->template_id,
                'mobile' => $wa_id ?? $visitor->mobile_no,
                'wamid' => $messageId,
                'status' => $messageStatus,
            ];
        
            // Save to WhatsappLog only if the conditions are met
            WhatsappLog::create($requestData);
        }
    }

    private function logWhatsappReplies($webhookData)
    {        

       // Ensure 'entry', 'changes', and 'messages' keys are present and not empty
        if (isset($webhookData['entry'][0]['changes'][0]['value']['messages'][0])) {
            $entry = $webhookData['entry'][0];
            $change = $entry['changes'][0]['value'];
            $message = $change['messages'][0];
        
            // Check and extract relevant data with default fallbacks
            $fromNumber = $message['from'] ?? null;
            $textBody = $message['text']['body'] ?? null;
            $timestamp = $message['timestamp'] ?? null;
            $wamid = $message['id'] ?? null;
            $contextId = $message['context']['id'] ?? null;

            /// FROM HERE WE NEED TO CHECK IF CONTEXTID IS NULL , THEN WE NEED TO SEARCH LAST MESSAGE THAT WE SEND TO THIS NUMBER  , THEN FROM THAT RECORD , WE CAN GET WAMID AND SAVE IT AS CONTEXT ID

            if($contextId == null)
            {

              $pastMessage = WhatsappLog::where('mobile', $fromNumber)->latest('id')->first();

              if(isset($pastMessage))
              {
                $contextId = $pastMessage->id;
                $visitor_id = $pastMessage->visitor_id;
              }


            }
            else
            {
                $pastMessage = WhatsappLog::where('wamid', $contextId)->latest('id')->first();

                if(isset($pastMessage))
                {
                $contextId = $pastMessage->id;
                $visitor_id = $pastMessage->visitor_id;
                }

            }

        
            // Save to the database only if 'wamid' is not null
            if ($wamid) {
               // Check if 'wamid' already exists in the database
                    if (!WhatsappReplies::where('wamid', $wamid)->exists()) {


                    if(isset($contextId) && $contextId != null && $contextId != "" && isset($visitor_id) && $visitor_id != null)
                        {
                           $visitor = Visitor::select('visitors.*')
                                              ->where('id', $visitor_id)
                                              ->first();

                        }


                        // Prepare the data
                        $requestData = [
                            'wamid' => $wamid,
                            'fk_wam_id' => $contextId,
                            'reply' => $textBody,
                            'visitor_id' => $visitor_id ??  0,
                            'sender_mobile' => $fromNumber
                        ];
                    
                        // Create a new record if 'wamid' does not exist
                        WhatsappReplies::create($requestData);

                        if(isset($contextId) && $contextId != null && $contextId != "")
                        {

                                // FROM HERE WE NEED TO SEND PUSH NOTIFICATION TO USER , FROM FK_WAM_ID , WE NEED TO FIND WHICH USER SENT MESSAGE TO THIS NUMBER.
                                $pushObj = new Sendpush();

                                $user = User::select('users.*')
                                              ->join('whatsapp_logs', 'users.user_id', '=', 'whatsapp_logs.user_id')
                                              ->join('whatsapp_replies', 'whatsapp_logs.id', '=', 'whatsapp_replies.fk_wam_id')
                                              ->where('whatsapp_replies.fk_wam_id', $contextId)
                                              ->first();

                             

                                

                                if(!isset($user) || $user == null)
                                {
                                    return response()->json([
                                    "status" => true,
                                    "msg" => 'Message saved successfully!',
                                    ]);
                                };

                                if(isset($visitor) && $visitor != null)
                                {
                                    $title = $visitor->name." has replied to your message";
                                    $msg = "" . $textBody;
                                    $message = array("notification_type" => "client_message", "message" => $msg, "title" => $title, 'visitor_id' => $visitor->id);
                                }
                                else
                                {
                                    $title = "Your received message on whatsapp.";
                                    $msg = "1 New Message";
                                    $message = array("notification_type" => "client_message", "message" => $msg, "title" => $title, 'visitor_id' => 0);
                                }
                                
                                
                              

                                if(isset($user->device_type))
                                {
                                    if ($user->device_type == "android" || $user->device_type == "Android") 
                                    {
                                        $pushObj->sendAndriodNotification($user->push_token, $message);
                                    }
                                    else
                                    {
                                        $pushObj->sendIOSNotification($user->push_token, $message, $title);
                                    }
                                }
                        
                        }
                        
                        return response()->json([
                            "status" => true,
                            "msg" => 'Message saved successfully!',
                        ]);
                    } else {
                        return response()->json([
                            "status" => false,
                            "msg" => 'This wamid already exists!',
                        ]);
                    }
            }
        }

          if (isset($webhookData['entry'][0]['changes'][0]['value']['statuses'][0]))
        {
            $entry = $webhookData['entry'][0];
            $change = $entry['changes'][0]['value'];
            $status = $change['statuses'][0];
           
            $timestamp = $status['timestamp'] ?? null;
            $wamid = $status['id'] ?? null;
            $status_text = $status['status'] ?? null;

            if($wamid !=null)
            {  /// 
               WhatsappLog::where('wamid', $wamid)->update(['status' => $status_text]);
            }
        }
    }


    // Set your verification token
    private $verifyToken = "frenzin123";

    public function verifyToken(Request $request)
    {
        // Check if required parameters are present
        if ($request->has(['hub_mode', 'hub_challenge', 'hub_verify_token'])) {
            // Verify the token
            if ($request->input('hub_verify_token') === $this->verifyToken) {
                return response($request->input('hub_challenge'), 200);
            } else {
                return response("Invalid verify token", 403);
            }
        } else {
            return response("Missing parameters", 400);
        }
    }

   
    public function receiveData(Request $request)
    {
        // Get the raw JSON data from the request
        $data = $request->getContent();

        // Log the raw JSON data to a file (equivalent to your `logWrite` function)
        $this->logWrite($data);
        
        $data = json_decode($data ,true);
        $this->logWhatsappReplies($data);

        return response()->json(['status' => 'success'], 200);
    }

     private function logWrite($data)
    {
        // Format the log entry with a timestamp
        $logEntry = "[" . now()->format('Y-m-d H:i:s') . "] " . $data . PHP_EOL;

        // Save log entry to a file
        file_put_contents(storage_path('logs/webhook_log.txt'), $logEntry, FILE_APPEND);
    }

    public function whatsapp_batch_list()
    {
        // Fetch whatsapp counts and related template details
        $whatsapp_batch = DB::table('whatsapp_batch')
            ->leftJoin('templates', 'whatsapp_batch.template_id', '=', 'templates.id')
            ->leftJoin('whatsapp_logs', 'whatsapp_logs.fk_whatsapp_batch_id', '=', 'whatsapp_batch.id')
            ->select(
                'whatsapp_batch.*',
                'templates.created_by',
                'templates.whatsapp_template_id',
                'templates.whatsapp_file_id',
                'templates.name',
                'templates.header',
                'templates.message',
                'templates.footer',
                'templates.is_default',
                'templates.file',
                'templates.file_type',
                'templates.file_size_in_bytes',
                'templates.file_mime_type',
                'templates.status as template_status',
                'templates.approved_at',
                DB::raw('SUM(CASE WHEN whatsapp_logs.status = "failed" THEN 1 ELSE 0 END) as failed_count'),
                DB::raw('SUM(CASE WHEN whatsapp_logs.status NOT IN ("failed", "accepted") THEN 1 ELSE 0 END) as success_count')
            )
            ->groupBy('whatsapp_batch.id', 'templates.id')
            ->orderBy('whatsapp_batch.id', 'desc') // Ensure to group by the primary keys
            ->get();

        // Check if any records are returned
        if (count($whatsapp_batch) > 0) {
            return response()->json([
                'status' => true,
                'data' => $whatsapp_batch
            ]);
        } else {
            return response()->json([
                'status' => false,
                'data' => [],
                'msg' => 'Whatsapp Counts Not Found'
            ], 201);
        }
    }

    public function whatsappLogByBatch_id(Request $request)
    {
        // Validate incoming request
        $validator = Validator::make($request->all(), [
            'fk_whatsapp_batch_id' => 'required',
            'type' => 'required|in:total,sent,failed', // Validate that 'type' is one of 'total', 'sent', or 'failed'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'msg' => $validator->errors(),
            ], 400);
        }

        $fk_whatsapp_batch_id = $request->fk_whatsapp_batch_id;
        $type = $request->type; // Get the 'type' parameter ('total', 'sent', or 'failed')

        // Start building the query
        $query = DB::table('whatsapp_logs')
            ->leftJoin('whatsapp_batch', 'whatsapp_logs.fk_whatsapp_batch_id', '=', 'whatsapp_batch.id')
            ->leftJoin('templates', 'whatsapp_batch.template_id', '=', 'templates.id')
            ->select(                
                'whatsapp_logs.visitor_id',            
            )
            ->where('whatsapp_logs.fk_whatsapp_batch_id', $fk_whatsapp_batch_id);

        // Apply filters based on 'type' (sent, failed, total)
        if ($type == 'sent') {
            // For 'sent', exclude 'failed' status
            $query->whereNotIn('whatsapp_logs.status', ['failed', 'accepted']);
        } elseif ($type == 'failed') {
            // For 'failed', only include 'failed' status
            $query->where('whatsapp_logs.status', '=', 'failed');
        }
        // No filter needed for 'total' since we want all logs.

        // Execute the query
        $whatsapp_logs = $query->orderBy('whatsapp_logs.id', 'desc')->get();

        // Check if any records are returned
        if (count($whatsapp_logs) > 0) {
            return response()->json([
                'status' => true,
                'data' => $whatsapp_logs
            ]);
        } else {
            return response()->json([
                'status' => false,
                'data' => [],
                'msg' => 'No WhatsApp Logs Found for the specified Batch'
            ], 201);
        }
    }

    
    


}
