<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Visitor;

class Event extends Model
{
    use HasFactory;

    protected $fillable = ['event_name', 'city', 'details', 'start_date', 'end_date','type_show_all'];
    
    public function assignes(){
        return $this->hasMany(EventAssignment::class, 'fk_event_id', 'id');
    }

    public function assignes_admins(){
        return $this->hasMany(EventAssignment::class, 'fk_event_id', 'id')->where('is_admin','true');
    }
	
	public function visitors()
{
    return $this->hasMany(Visitor::class, 'event_id', 'id');
}
}
