<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;


class Permissions extends Model
{
    use HasFactory;
    protected $table = 'permissions';
    public $timestamps = false;

    protected $fillable = [
        'fk_customer_id',
        'Contact_Share',
        'Call_Contact',
        'Send_Whatsapp',
        'Save_Contact',
        'Export_Excel',
        'updated_at', // Add updated_at if you need to update it manually
    ];
    
    public static function Permissionslist()
    {
        $user = Auth::user()->CustomerID;

        return Permissions::all()->where('fk_customer_id',$user);
    }
    
    public function insertpermission($user_id)
    {

        $obj = Permissions::updateOrCreate(
            ['fk_customer_id' => $user_id],
            [
                'Contact_Share' => '1',
                'Call_Contact' => '1',
                'Send_Whatsapp' => '1',
                'Save_Contact' => '1',
                'Export_Excel' => '1',
                'updated_at' => now(),
            ]
        );

        return $obj->id;
    }

}