<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserLocation extends Model
{
    use HasFactory;
    protected $fillable = ['user_id', 'lat', 'lng', 'traveld_km', 'on_demand', 'date_time'];

    public $timestamps = false;
    protected $appends = ['user_location_time'];
    public function addRecode(array $data)
    {
        self::create($data);
    }


    public function getUserLocationTimeAttribute()
    {
        $created_at = $this?->created_at;
        if(!empty($created_at)){
            return $created_at = Carbon::parse($created_at)->timezone('Asia/Kolkata')->diffForHumans();
        }
        return null;

    }
}
