<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use App\Models\Product;
use App\Models\Visit_data_images;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use App\Models\VisitorProduct;
use App\Models\Visit_data;
use App\Models\Action;


class Visitor extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'event_id',
        'customer_id',
        'company_name',
        'website',
        'mobile_no',
        'mobile_no2',
        'mobile_no3',
        'email',
        'email2',
        'state',
        'city',
        'address',
        'designation',
        'category',
        'follow_up_time',
        'action',
        'remarks',
        'attended_by',
        'rating',
        'audio_file',
        'front_image',
        'back_image',
        'visited_date',
        'lat',
        'lng',
        "product_with_qty_json"
    ];

	protected $casts = [
    'customer_id' => 'integer',
];



    public function getCreatedAtAttribute($date)
    {
        return Carbon::parse($date)->setTimezone('Asia/Kolkata')->format('Y-m-d H:i:s');
    }

    public function getUpdatedAtAttribute($date)
    {
        return Carbon::parse($date)->setTimezone('Asia/Kolkata')->format('Y-m-d H:i:s');
    }


    public function eventImages()
    {
        return $this->hasMany(EventImage::class);
    }

    public function products()
    {
        return $this->hasMany(VisitorProduct::class);
    }

    public function updateVisitor($data)
    {
        $visitor = Visitor::find($data['visitorid']);
        if ($visitor->front_image != "") {
            if (file_exists(public_path('uploads/visitor') . $visitor->front_image)) {
                unlink(public_path('uploads/visitor') . $visitor->front_image);
            }
        }

        if ($visitor->back_image != "") {
            if (file_exists(public_path('uploads/visitor') . $visitor->back_image)) {
                unlink(public_path('uploads/visitor') . $visitor->back_image);
            }
        }

        if ($visitor->audio_file != "") {
            if (file_exists(public_path('uploads/visitor') . $visitor->audio_file)) {
                unlink(public_path('uploads/visitor') . $visitor->audio_file);
            }
        }

        $event_images = EventImage::where('visitor_id', $visitor->id)->get();
        if (isset($event_images)) {
            foreach ($event_images as $value) {
                if ($value->event_image) {
                    if (file_exists(public_path('uploads/visitor') . $value->event_image)) {
                        // unlink(public_path('uploads/visitor/').$visitor->event_image);
                        echo public_path('uploads/visitor/') . $value->event_image;
                        die;
                    }
                }
                EventImage::where('visitor_id', $value->id)->delete();
            }
        }

        $products_arr = VisitorProduct::where('visitor_id', $visitor->id)->get();
        if (isset($products_arr)) {
            foreach ($products_arr as $value) {
                VisitorProduct::where('visitor_id', $value->id)->delete();
            }
        }

        return Self::insertVisitor($data, $visitor->id);
    }

    public function insertVisitor($data, $visitorid = "")
    {
        $front_image = '';
        $back_image = '';
        $audio_file = '';

        $event_images = $data['event_images'] ?? "";
        $event_images_arr = [];

		
		// BUG OF MULTIPLE PRODUCTS , SOLVED.
		if(isset($data['product_ids']))
		{
		$product_ids = $data['product_ids'];
		$products_arr = \explode(',', $product_ids);
		$products_arr = array_unique($products_arr);
		}

        // echo "<pre>"; print_r($products_arr); die;

    
            if (isset($data['front_image'])) {
                $file1 = $data['front_image'];
                $name = \str_replace(' ', '_', $file1->getClientOriginalName());
				
				if($name=="file.png")
				{
				$ext = $file1->getClientOriginalExtension();
				$image = md5( \microtime() . $name ) . '.' .$ext;
				}
				else
				{
					$image = $file1->getClientOriginalName();     
				}                 
				
                if ($file1->move(public_path('uploads/visitor'), $image)) {
                    $front_image = $image;
                }
            }
            
            if (isset($data['back_image'])) {
                $file2 = $data['back_image'];
				
                $name = \str_replace(' ', '_', $file2->getClientOriginalName());
				
				if($name=="file.png")
				{
				$ext = $file2->getClientOriginalExtension();
				$image2 = md5( \microtime() . $name ) . '.' .$ext;
				}
				else
				{
					$image2 = $file2->getClientOriginalName();     
				}
				
                if ($file2->move(public_path('uploads/visitor'), $image2)) {
                    $back_image = $image2;
                }

            }
        

        if (isset($data['audio_file'])) {
            $file3 = $data['audio_file'];
            $audio = $file3->getClientOriginalName();
            if ($file3->move(public_path('uploads/visitor'), $audio)) {
                $audio_file = $audio;
            }
        }

        if (isset($data['visitor_id']) && $data['visitor_id'] != "" && $data['visitor_id'] != "0") {
            $obj = Visitor::find($data['visitor_id']);
            if ($obj == null) {
                return;
            }
            $zoho_status = 'update';
        } else {
            $obj = new Visitor();
            $zoho_status = 'add';
        }

        $obj->name              = isset($data['name']) ? $data['name'] : "";

        if (isset($data['company_name'])) {
            $obj->company_name      = $data['company_name'];
        }
        // else if(isset($data['companyName'])){
        //     $obj->company_name      = $data['companyName'];
        // }
        else {
            $obj->company_name      = "";
        }

        $obj->website               = isset($data['website']) ? $data['website'] : "";
        $obj->mobile_no             = isset($data['mobile_no']) ? $data['mobile_no'] : "";
        $obj->mobile_no2            = isset($data['mobile_no2']) ? $data['mobile_no2'] : "";
        $obj->mobile_no3            = isset($data['mobile_no3']) ? $data['mobile_no3'] : "";
        $obj->email                 = isset($data['email']) ? $data['email'] : "";
        $obj->email2                = isset($data['email2']) ? $data['email2'] : "";
        $obj->state                 = isset($data['state']) ? $data['state'] : "";
        $obj->city                  = isset($data['city']) ? $data['city'] : "";
        $obj->pincode               = isset($data['pincode']) ? $data['pincode'] : "";
        $obj->address               = isset($data['address']) ? $data['address'] : "";
        $obj->designation           = isset($data['designation']) ? $data['designation'] : "";
        $obj->category              = isset($data['category']) ? $data['category'] : "";
        $obj->follow_up_time        = isset($data['follow_up_time']) ? $data['follow_up_time'] : "";
        $obj->action                = isset($data['action']) ? $data['action'] : "";
        $obj->remarks               = isset($data['remarks']) ? $data['remarks'] : "";
        $obj->attended_by           = isset($data['attended_by']) ? $data['attended_by'] : "";
        $obj->rating                = isset($data['rating']) ? $data['rating'] : "";
        $obj->event_id              = isset($data['event_id']) ? $data['event_id'] : "";
        $obj->customer_id           = isset($data['customer_id']) ? $data['customer_id'] : "";
        $obj->visited_date          = isset($data['visited_date']) ? $data['visited_date'] : "";
        $obj->qrcodevalue           = isset($data['qrcodevalue']) ? $data['qrcodevalue'] : "";
        $obj->lat                   = isset($data['latitude']) ? $data['latitude'] : "";
        $obj->lng                   = isset($data['longitude']) ? $data['longitude'] : "";
        $obj->is_international      = isset($data['is_international']) ? $data['is_international'] : "false";
        $obj->monthly_requirement   = isset($data['monthly_requirement']) ? $data['monthly_requirement'] : "";
        $obj->sub_category          = isset($data['subcategory']) ? $data['subcategory'] : "";
        $obj->country_code          = isset($data['country_code']) ? $data['country_code'] : null;
        $obj->address_country_code  = isset($data['address_country_code']) ? $data['address_country_code'] : null;
        $obj->source_of_lead  = isset($data['source_of_lead']) ? $data['source_of_lead'] : null;
        $obj->product_with_qty_json  = isset($data['product_with_qty_json']) ? $data['product_with_qty_json'] : null;

        $obj->only_for_me_reminder  = isset($data['only_for_me_reminder']) ? $data['only_for_me_reminder'] : "false";
        $obj->referred_by  = isset($data['referred_by']) ? $data['referred_by'] : "";



        if (isset($data['front_image'])) {
            if ($obj->front_image != "") {
                if (file_exists(public_path('uploads/visitor') . $obj->front_image)) {
                    unlink(public_path('uploads/visitor') . $obj->front_image);
                }
            }
            $obj->front_image       = url('uploads/visitor') . '/' . $front_image;
        }
        if (isset($data['back_image'])) {
            if ($obj->back_image != "") {
                if (file_exists(public_path('uploads/visitor') . $obj->back_image)) {
                    unlink(public_path('uploads/visitor') . $obj->back_image);
                }
            }
            $obj->back_image       = url('uploads/visitor') . '/' . $back_image;
        }
        if (isset($data['audio_file'])) {
            if ($obj->audio_file != "") {
                if (file_exists(public_path('uploads/visitor') . $obj->audio_file)) {
                    unlink(public_path('uploads/visitor') . $obj->audio_file);
                }
            }
            $obj->audio_file       = url('uploads/visitor') . '/' . $audio_file;
        }

        if (isset($data['event_ids']) && $data['event_ids'] != "") {
            //$eventIds = explode(',', $data['event_ids']);
            $eventIdsWithCommas = ',' . $data['event_ids'] . ',';
            $obj->event_ids  = isset($eventIdsWithCommas) ? $eventIdsWithCommas : null;
        } else {
            $obj->event_ids = null;
        }


        $obj->save();


         //Adding New Visit When Adding New Visitor
         if (isset($data['visitor_id']) && $data['visitor_id'] != "" && $data['visitor_id'] != "0") {
           //update visitor
        } else {

                    // ...
            $actionTitle = $data['action'] ?? 'Client Visit';

            // make sure actions table has this title
            $action = Action::firstOrCreate(
                ['title' => $actionTitle],
                ['description' => $data['description'] ?? ''] // optional
            );

            $visitData = new Visit_data();
            $visitData->fk_teammember_id =isset($data['customer_id']) ? $data['customer_id'] : "";
            $visitData->fk_visitor_id = $obj->id;
            $visitData->fk_visit_data_id = 0;
            $visitData->action = $actionTitle;
            $visitData->visit_time =date('Y-m-d H:i:s');
            $visitData->remarks = isset($data['remarks']) ? $data['remarks'] : "";

            $visitData->attend_by = DB::table('users')->where('CustomerID',isset($data['customer_id']) ? $data['customer_id'] : "")->first()?->CustomerName ?? "";
            $visitData->created_at = date('Y-m-d H:i:s');
            $visitDataId = $visitData->save();
        }

        //delete all old products of visitior
        VisitorProduct::where('visitor_id', $obj->id)->delete();

        //add new products of visitior
        if (isset($products_arr) && !empty($products_arr)) {
            foreach ($products_arr as $key1 => $product_id) {
                if (isset($product_id) && $product_id != '') {
                    $id = Product::where('id', $product_id)->first();
                    if ($id != null) {
                        VisitorProduct::create([
                            'visitor_id' => $obj->id,
                            'product_id' => $product_id,
                        ]);
                    }
                }
            }
        }

        //zoho api call

		 $zoho_crm_data = DB::table('zoho_crm')->first();
        if (!empty($zoho_crm_data))
		{
              $response =  $this->sendZohoRequest($obj,$zoho_status);
				if ($response->code === 'INVALID_TOKEN')
				{
				$zoho_crm_data = DB::table('zoho_crm')->first();
				$refreshResponse = $this->refreshAccessToken($zoho_crm_data);
				if (isset($refreshResponse->access_token)) {
					DB::table('zoho_crm')->where('id', $zoho_crm_data->id)->update(['access_token' => $refreshResponse->access_token]);
					$response =  $this->sendZohoRequest($obj,$zoho_status);
				}
				}

        $zohoId = $response->data->data[0]->details->id ?? '';
        DB::table('visitors')->where('id', $obj->id)->update(['zoho_id' => $zohoId]);
        }


        $visitorid = $obj->id;


        if (isset($data['city'])) {
            // $get_city = DB::table('cities')->first();
            // if ($get_city == null) {
            //     DB::table('cities')->insert(['name' => $data['city']]);
            // } else {
                $existingCity = DB::table('AddressDataTBL')->where('district', $data['city'])->first();

                if (!$existingCity) {


                    // if (isset($data['is_international']) && isset($data['is_international']) == 'true') {

                    //     $data_add = [
                    //         'name' => $data['city'],
                    //         'country_code' => $obj->country_code,
                    //         'created_at' => now(),
                    //     ];
                    // } else {
                    //     $getstate = DB::table('states')->where('name', $data['state'])->first();

                    //     $data_add = [
                    //         'name' => $data['city'],
                    //         'state_id' => $getstate->id,
                    //         'country_id' => $getstate->country_id,
                    //         'country_code' => $getstate->country_code,
                    //         'created_at' => now(),
                    //     ];
                    // }

                    //   DB::table('cities')->insert($data_add);

                    if (!empty($data['city']) && !empty($data['state'])  && !empty(auth()->user()->Email)) {
                        $cityData = [
                            'city' => $data['city'],
                            'state' => $data['state'],
                            'email' => auth()->user()->Email,
                        ];

                        $url = "https://frenzinsoftwares.com/visitor/webservice_v2/v1/insertCities";
                        $ch = curl_init($url);
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($ch, CURLOPT_POST, true);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($cityData));
                        curl_setopt($ch, CURLOPT_HTTPHEADER, [
                            'Content-Type: application/json',
                            'Accept: application/json'
                        ]);
                        $response = curl_exec($ch);
                        Log::error('insert city on server', ['Error' => $response]);
                    }
                }
            // }
        }
        if (isset($event_images) && !empty($event_images)) {
            foreach ($event_images as $key => $value) {
                if (isset($value) && $value != '') {
                    // $event_i_1 = \str_replace(' ', '_', $value->getClientOriginalName());

                    // $event_ext1 = pathinfo($event_i_1, PATHINFO_EXTENSION);

                    // If the extension is not obtained from the original name, try using getClientMimeType
                    // if (!$event_ext1 && $value->getClientMimeType() == 'application/pdf') {
                    //     $event_ext1 = 'pdf';
                    // }
                    // $event_ext1 = $value->getClientOriginalExtension();
                    // $event_image = md5(\microtime() . $event_i_1) . '.' . $event_ext1;
                    $event_image = $value->getClientOriginalName();
                    if ($value->move(\public_path('uploads/event'), $event_image)) {
                        $event_image = isset($event_image) && $event_image != '' ? url('uploads/event') . '/' . $event_image : '';

                        if (isset($event_image) && $event_image != '') {
                            EventImage::create([
                                'visitor_id' => $visitorid,
                                'event_id' => $data['event_id'],
                                'event_image' => $event_image,
                            ]);
                        }
                    }
                }
            }
        }
		
		//VisitorProduct::where('visitor_id', $visitorid)->delete();


        // ob_start();
        if (isset($data['auto_sync']) && $data['auto_sync'] == "true") {
            $main_admins_ids = User::where('is_admin', 'true')->pluck('user_id')->toArray();
            $eventIDs = [];
            if (!empty($data['event_ids'])) {
                $eventIDs =  explode(',', $data['event_ids']);
            } else {
                $eventIDs = [$data['event_id']];
            }
            if (count($eventIDs) >  0) {
                foreach ($eventIDs  as $eventId) {
                    $eventData = Event::with(['assignes_admins' => function ($query) use ($main_admins_ids) {
                        $query->whereNotIn('fk_user_id', $main_admins_ids);
                    }])->where('id', $eventId)->first();
                    if (!empty($eventData)) {
                        $assignes_admins_ids = $eventData->assignes_admins->pluck('fk_user_id')->toArray();
                        $push_notifications_users_ids = array_merge($main_admins_ids, $assignes_admins_ids);
                    } else {
                        $push_notifications_users_ids =  $main_admins_ids;
                    }
                    $current_user_id = Auth::user()->user_id ?? null;
                    if ($current_user_id !== null) {
                        $push_notifications_users_ids = array_diff($push_notifications_users_ids, [$current_user_id]);
                    }
                    $push_users =  User::whereIn('user_id', $push_notifications_users_ids)->get();

                    if (!empty($eventData)) {
                        $eventName =  $eventData->event_name;
                        if (count($push_users) >  0) {
                            $androidTokens = [];
                            $iosTokens = [];
                            foreach ($push_users as $assignee) {
                                if ($assignee->device_type == 'android') {
                                    array_push($androidTokens, $assignee->push_token);
                                } else {
                                    array_push($iosTokens, $assignee->push_token);
                                }
                            }
                            $title = "Client is added";
                            $pushObj = new Sendpush();
                            $msg = $data['name'] . " Client is added to " . $eventName;
                            $message = array("notification_type" => "visitor_added", "message" => $msg, "title" => $title, 'visitor_id' => $visitorid, 'event_id' => $data['event_id']);
                            if (count($androidTokens) > 0) {
                                $pushObj->sendAndriodNotification($androidTokens, $message);
                            }
                            if (count($iosTokens) > 0) {
                                $pushObj->sendIOSNotification($iosTokens, $message, $title);
                            }
                        }
                    }
                }
            }
        }

        return $visitorid;
    }

    public function sendZohoRequest($visitor,$zoho_status = '')
    {

        $zoho_crm_data = DB::table('zoho_crm')->first();
        if (empty($zoho_crm_data)) {

            return false;
        }
        $names = explode(' ', $visitor->name);
        $eventData = Event::where('id',$visitor->event_id)->first();

        $visitorData = [
            'Company' => $visitor->company_name,
            'Last_Name' => isset($names[1]) ? implode(' ', array_slice($names, 1)) : 'last name',
            'First_Name' => $names[0],
            'Email' => $visitor->email,
            'State' => $visitor->state ?? 'state',
            'Lead_Source' => $eventData->event_name ?? '',
            'front_image' => $visitor->front_image ?? '',
            'back_image' => $visitor->back_image ?? '',
            'Phone'=>$visitor->mobile_no2 ?? '',
            'Industry'=>$visitor->category ?? '',
            'Secondary_Email'=> $visitor->email2 ?? '',
            'Website'=>$visitor->website ?? '',
            'City'=>$visitor->city ?? '',
            'Country'=>$visitor->country_code ?? '',
            'Street'=>$visitor->address ?? '',
            'Zip_Code'=>$visitor->pincode ?? '',
            'Title'=>$visitor->designation ?? ''
        ];

        if (!empty($visitor->mobile_no)) {
            $visitorData['Mobile'] = $visitor->mobile_no;
        }

        // Product and remarks
        $Description =  '';
        $products = '';
        $visitorProducts = VisitorProduct::where('visitor_id',$visitor->id)->get();
        if(count($visitorProducts) > 0){
            $productNames =  [];
            foreach($visitorProducts as $vproduct){
                $productNames[] = $vproduct->ProductName;
            }
            $products = implode(',',$productNames);
        }

        if (!empty($products)) {
            $Description .= "\n\nProducts: $products";
        }

        if (!empty($visitor->remarks)) {
            if (!empty($products)) {
                $Description .= "\n\n";
            }
            $Description .= "Remarks: $visitor->remarks";
        }

        $visitorData['Description'] = $Description;
        // Product and remarks end

        //Image upload code start here
        $images = [];

        if (!empty($visitor['front_image'])) {

            $frontImageName = basename($visitor['front_image']);

            $imagePath = public_path('uploads/visitor/' . $frontImageName);
            if (file_exists($imagePath)) {
                $images[] = new \CURLFile($imagePath);
            }
        }

        if (!empty($visitor['back_image'])) {
            $backImageName = basename($visitor['back_image']);
            $imagePath = public_path('uploads/visitor/' . $backImageName);
            if (file_exists($imagePath)) {
                $images[] = new \CURLFile($imagePath);
            }
        }

        $image_upload_response = "";
        if (count($images) > 0) {
            $image_upload_response = $this->uploadDynamicFilesToZoho($images, $zoho_crm_data);
        }

        if (is_array($image_upload_response) && count($image_upload_response) > 0) {
            $visitorData['Record_Image'] = $image_upload_response[0]->File_Id__s;
            if(count($image_upload_response) == '2'){
                unset($image_upload_response[0]);
                $visitorData['File_upload'] = $image_upload_response;
            }
        }

        //Image upload code end here

        $data = [
            'data' => [$visitorData],
            "duplicate_check_fields" => [
                "Email",
            ],
            'trigger' => ['approval', 'workflow', 'blueprint']
        ];


        $ch = curl_init('https://www.zohoapis.in/crm/v7/Leads/upsert');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Authorization: Zoho-oauthtoken ' . $zoho_crm_data->access_token
        ]);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

       // Check for errors and log them
        if ($httpCode !== 200) {
            Log::error('Zoho API request failed', [
                'httpCode' => $httpCode,
                'response' => json_decode($response),
                'visitorData' => $visitorData,
            ]);
        }

        return (object)[
            'httpCode' => $httpCode,
            'data' => json_decode($response),
            'code' => isset(json_decode($response)->code) ? json_decode($response)->code : null
        ];
    }


    private function refreshAccessToken($zoho_crm_data)
    {
        $refreshData = [
            'client_id' => $zoho_crm_data->client_id,
            'client_secret' => $zoho_crm_data->client_secret,
            'refresh_token' => $zoho_crm_data->refresh_token,
            'grant_type' => 'refresh_token'
        ];

        $ch = curl_init('https://accounts.zoho.in/oauth/v2/token');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($refreshData));

        $refreshResponse = curl_exec($ch);
        curl_close($ch);

        return json_decode($refreshResponse);
    }


    private function uploadDynamicFilesToZoho($images, $zoho_crm_data)
    {

        $apiUrl = 'https://www.zohoapis.in/crm/v7/files';

        $headers = [
            'Authorization' => 'Zoho-oauthtoken ' . $zoho_crm_data->access_token,
        ];

        if (empty($images)) {
            return 'Error: No images to upload.';
        }

        $request = Http::withHeaders($headers);

        foreach ($images as $index => $image) {
            $request = $request->attach('file', fopen($image->getFilename(), 'r'), $image->getPostFilename());
        }

        $response = $request->post($apiUrl, [
            'type' => 'inline',
        ]);


        if ($response->successful()) {
            $responseData = $response->json();
            $fileIds = [];  // Initialize the array

            foreach ($responseData['data'] as $fileData) {
                if (isset($fileData['details']['id'])) {
                    $fileIds[] = (object)[
                        'File_Id__s' => $fileData['details']['id'],
                    ];
                }
            }
            return $fileIds;
        }else{
            $refreshResponse = $this->refreshAccessToken($zoho_crm_data);
            if (isset($refreshResponse->access_token)) {
                DB::table('zoho_crm')->where('id', $zoho_crm_data->id)->update(['access_token' => $refreshResponse->access_token]);
                $response = $this->uploadDynamicFilesToZoho($images,$zoho_crm_data);
                return $response;
            }
        }

        return 'Error uploading files: ' . $response->body();
    }

    public function Visit_data()
    {
        return $this->hasMany(Visit_data::class, 'fk_visitor_id', 'id');
    }
    // public function Visit_data_images()
    // {
    //     return $this->hasMany(Visit_data_images::class);
    // }

     public static function fetchAllVisitors($CustomerID, $is_admin, $updated_at, $event_id, $user_id)
    {
        // DB::enableQueryLog();
        //DB::raw("GROUP_CONCAT(visitor_products.id) as product_id")
        $query = Visitor::select(
            'visitors.*',
            DB::raw("GROUP_CONCAT(visitor_products.product_id) as product_id"),
            DB::raw("GROUP_CONCAT(event_images.event_image) as event_images"),
        )
            ->with('Visit_data.Visit_data_images', 'Visit_data.visit_data_product')
            ->leftjoin('visitor_products', 'visitor_products.visitor_id', 'visitors.id')
            ->leftjoin('event_images', 'event_images.visitor_id', 'visitors.id');

        // $query = $query->select('visit_data.*')->leftjoin('visit_data', 'visit_data.fk_visitor_id', 'visitors.id');

        if (($updated_at != null) && !empty($updated_at)) {
            $query = $query->where('visitors.updated_at', '>', $updated_at);
            $query = $query->where(function ($query) use ($event_id) {
                $query->where('visitors.event_id', $event_id)
                    ->orWhere('visitors.event_ids', 'LIKE', "%,$event_id,%");
            });
            // ->where('visitors.event_id', $event_id);
        } else {
            // $query = $query->where('visitors.event_id', $event_id);
            $query = $query->where(function ($query) use ($event_id) {
                $query->where('visitors.event_id', $event_id)
                    ->orWhere('visitors.event_ids', 'LIKE', "%,$event_id,%");
            });
        }

        // if($is_admin == "false") {
        //     $query = $query->where('visitors.customer_id', $CustomerID);
        // }

        $is_event_admin = DB::table('event_assignments')->where('fk_user_id', $user_id)->where('fk_event_id', $event_id)->first();
        // dd($is_event_admin);
        if ($is_admin == "false"  && isset($is_event_admin) && $is_event_admin->is_admin == "false") {
            $query = $query->where('visitors.customer_id', $CustomerID);
        }


        $query = $query->groupBy('visitors.id')->get();
        // dd(DB::getQueryLog());

        return $query;
    }

      public static function fetchAllVisitorsNew($CustomerID, $is_admin, $updated_at, $event_id, $user_id)
    {
        // DB::enableQueryLog();
        //DB::raw("GROUP_CONCAT(visitor_products.id) as product_id")
        $query = Visitor::select(
            'visitors.*',
            DB::raw("GROUP_CONCAT(visitor_products.product_id) as product_id"),
            DB::raw("GROUP_CONCAT(event_images.event_image) as event_images"),
        )
            ->with('Visit_data.Visit_data_images', 'Visit_data.visit_data_product')
            ->leftjoin('visitor_products', 'visitor_products.visitor_id', 'visitors.id')
            ->leftjoin('event_images', 'event_images.visitor_id', 'visitors.id');

        // $query = $query->select('visit_data.*')->leftjoin('visit_data', 'visit_data.fk_visitor_id', 'visitors.id');

        if (($updated_at != null) && !empty($updated_at)) {
            $query = $query->where('visitors.updated_at', '>=', $updated_at);
            $query = $query->where(function ($query) use ($event_id) {
                $query->where('visitors.event_id', $event_id)
                    ->orWhere('visitors.event_ids', 'LIKE', "%,$event_id,%");
            });
            // ->where('visitors.event_id', $event_id);
        } else {
            // $query = $query->where('visitors.event_id', $event_id);
            $query = $query->where(function ($query) use ($event_id) {
                $query->where('visitors.event_id', $event_id)
                    ->orWhere('visitors.event_ids', 'LIKE', "%,$event_id,%");
            });
        }

        // if($is_admin == "false") {
        //     $query = $query->where('visitors.customer_id', $CustomerID);
        // }

        $is_event_admin = DB::table('event_assignments')->where('fk_user_id', $user_id)->where('fk_event_id', $event_id)->first();
        // dd($is_event_admin);
        if ($is_admin == "false"  && isset($is_event_admin) && $is_event_admin->is_admin == "false") {
            $query = $query->where('visitors.customer_id', $CustomerID);
        }
        $query = $query->groupBy('visitors.id');
        $query = $query->orderBy('visitors.updated_at', 'asc');

        $count = $query->get()->count();
        $limit = 100;
        if($count > $limit){
            $has_more = true;
        }
        else{
            $has_more = false;
        }

        $remaining_count= ($count-$limit) > 0 ? $count-$limit : 0;
        return [$has_more,$query->take($limit)->get(),$remaining_count];
        // dd(DB::getQueryLog());

        // return $query;
    }
    public static function fetchAllVisitors2($CustomerID, $is_admin, $updated_at, $event_id, $user_id)
    {
        // DB::enableQueryLog();
        //DB::raw("GROUP_CONCAT(visitor_products.id) as product_id")
        $query = Visitor::select(
            'visitors.*',
            DB::raw("GROUP_CONCAT(visitor_products.product_id) as product_id"),
            DB::raw("GROUP_CONCAT(event_images.event_image) as event_images"),
        )
            ->with('Visit_data.Visit_data_images', 'Visit_data.visit_data_product')
            ->leftjoin('visitor_products', 'visitor_products.visitor_id', 'visitors.id')
            ->leftjoin('event_images', 'event_images.visitor_id', 'visitors.id');

        // $query = $query->select('visit_data.*')->leftjoin('visit_data', 'visit_data.fk_visitor_id', 'visitors.id');

        // if (($updated_at != null) && !empty($updated_at)) {
        $query = $query->where('visitors.updated_at', '>', $updated_at);
        // $query = $query->where(function ($query) use ($event_id) {
        //     $query->where('visitors.event_id', $event_id)
        //         ->orWhere('visitors.event_ids', 'LIKE', "%,$event_id,%");
        // });
        // ->where('visitors.event_id', $event_id);
        // }
        // else {
        //     // $query = $query->where('visitors.event_id', $event_id);
        //     $query = $query->where(function ($query) use ($event_id) {
        //         $query->where('visitors.event_id', $event_id)
        //             ->orWhere('visitors.event_ids', 'LIKE', "%,$event_id,%");
        //     });
        // }

        // if($is_admin == "false") {
        //     $query = $query->where('visitors.customer_id', $CustomerID);
        // }

        $is_event_admin = DB::table('event_assignments')->where('fk_user_id', $user_id)->where('fk_event_id', $event_id)->first();
        // dd($is_event_admin);
        if ($is_admin == "false") {
            $query = $query->where('visitors.customer_id', $CustomerID);
        }


        $query = $query->groupBy('visitors.id')->get();
        // dd(DB::getQueryLog());

        return $query;
    }
    public function get_Visitor_details($visitor_id)
    {
        return Visitor::where('id', $visitor_id)->first();
    }
    public function get_Visitor_name($visitor_name)
    {
        return Visitor::where('name', $visitor_name)->first();
    }
}
